@echo off

REM #
REM # Copyright (c) 2001 Oracle Corporation.  All rights reserved.
REM #
REM # PRODUCT
REM #   OID LDIF Migration to OID
REM #
REM # FILENAME
REM #   LDIFMigrator.bat
REM #
REM # DESCRIPTION
REM #   This script is used to launch the LIDF Migration.
REM #
REM # NOTE:
REM #   This script is typically invoked as follows:
REM #
REM #       LDIFMigration [-d "host=hostname" [port=portnumber] [dn=baseDn] [password=password]]
REM #				"Input_File=inputFileName" "Output_File=outputFileName" 
REM # 			"s_substitute_var=value"......
REM #
REM #   Note that parameters containing an '=' sign must be double-quoted when invoking
REM #   this script, else they will be broken up into separate parameters at the = sign
REM #   and errors will result.
REM #

SETLOCAL

REM Set class path
SET CLASSROOT=%ORACLE_HOME%\classes
SET LDAPJCLNT9=%ORACLE_HOME%\jlib\ldapjclnt9.jar
SET NETCFG=%ORACLE_HOME%\jlib\netcfg.jar
SET JNDIJARS=%ORACLE_HOME%\jlib\ldap.jar;%ORACLE_HOME%\jlib\jndi.jar;%ORACLE_HOME%\jlib\providerutil.jar

REM make sure ldapjclnt9.jar is present
IF NOT EXIST %LDAPJCLNT9% GOTO NO_LDAPJCLNT9JAR_FILE

SET CLASSPATHADD=%LDAPJCLNT9%;%JNDIJARS%;%CLASSROOT%;%NETCFG%;

SET JRE=%s_JRE_LOCATION%\bin\jre -nojit
SET CLASSPATH_QUAL=cp

IF "%ORACLE_OEM_JAVARUNTIME%x" == "x" GOTO JRE_START
SET JRE=%ORACLE_OEM_JAVARUNTIME%\bin\java -nojit
SET CLASSPATH_QUAL=classpath
SET CLASSPATHADD=%CLASSPATHADD%;%ORACLE_OEM_JAVARUNTIME%\lib\classes.zip

:JRE_START

%JRE% -ms4m -mx256m -%CLASSPATH_QUAL% %CLASSPATHADD% -DORACLE_HOME=%ORACLE_HOME% oracle.ldap.util.LDIFMigration %*

GOTO THE_END

:NO_LDAPJCLNT9JAR_FILE
   ECHO Missing jar file
   ECHO %LDAPJCLNT9% not found

:THE_END
   ENDLOCAL
