Rem
Rem $Header: u0703040.sql 15-dec-2004.06:59:45 rburns Exp $
Rem 
Rem u0703040.sql
Rem
Rem Copyright (c) 1992, 2004, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      u0703040.sql - additional upgrade script to be run when migrating a
Rem                     version 7 database.
Rem
Rem    DESCRIPTION
Rem      Additional upgrade script to be run during the migration of a
Rem      7.3.x database to the new release.
Rem
Rem      * This script needs to be run as a step in the
Rem        current release environment.
Rem      * See the Oracle Migration book for more details.
Rem
Rem      The upgrade is partitioned into the following 4 stages:
Rem        STAGE 1: call i0800050.sql:
Rem			This loads all tables that are necessary
Rem			to perform basic sql commands.
Rem	   STAGE 2: call utlip.sql to invalidate views, procedures, packages...
Rem        STAGE 3: call c0703040.sql:
Rem			This performs all necessary dictionary 
Rem			upgrade to bring the db from post 7.3.x to the
Rem			new release.
Rem        STAGE 4: call a0703040.sql:
Rem			This performs all necessary upgrade using
Rem			anonymous blocks.
Rem
Rem    NOTES
Rem	 WARNING:  DO NOT TOUCH THIS FILE!!!!! PUT ANY NECESSARY
Rem		   CHANGES INTO i08000x0.sql, c08000x0.sql, or
Rem		   a08000x0.sql for current upgrade
Rem
Rem      * This script needs to be run in the new release's environment
Rem        (after installing the release to which you want to upgrade).
Rem      * This script must be run using SQL*PLUS.
Rem      * You must startup up with RESTRICT to run this script.
Rem      * You must be connected AS SYSDBA to run this script.
Rem  
Rem    MODIFIED   (MM/DD/YY)
Rem    rburns      12/15/04 - check for non-SYS user 
Rem    tbgraves    02/04/02 - add server version check
Rem    rburns      12/06/01 - add doc
Rem    rburns      09/27/01 - check for OPEN MIGRATE
Rem    rburns      08/02/01 - add BYTE semantics
Rem    rburns      04/24/01 - add check for AL24UTFFSS database character set
Rem    rburns      04/17/01 - Alter system init parameters
Rem    rburns      03/26/01 - fix comments
Rem    jdavison    04/11/00 - Modify usage notes for 8.2 changes.
Rem    rshaikh     06/17/98 - rework upgrade:
Rem			      * move all critical stmts 
Rem				into i0800050.sql
Rem			      * move all non-anonymous block stmts 
Rem				into c0703040.sql
Rem			      * move all anonymous block stmts 
Rem				into a0703040.sql

Rem =========================================================================
Rem Exit immediately if there are errors in the initial checks
Rem =========================================================================

WHENEVER SQLERROR EXIT;
 
DOC 
###################################################################### 
###################################################################### 
    The following statement will cause an "ORA-01722: invalid number" 
    error and terminate the SQLPLUS session if the user is not SYS.  
    Disconnect and reconnect with AS SYSDBA. 
###################################################################### 
###################################################################### 
# 
 
SELECT TO_NUMBER('MUST_BE_AS_SYSDBA') FROM DUAL 
WHERE USER != 'SYS'; 

Rem The TO_NUMBER function will raise an error if the script is being
Rem run by the wrong server version.
Rem =========================================================================
/*
#######################################################################
#######################################################################
  The following statement will cause an "ORA-01722: invalid number"
  error if the database server version is not 9.2.0.
  Shutdown ABORT and use a different script or a different server.
#######################################################################
#######################################################################
*/
SELECT TO_NUMBER('MUST_BE_920') FROM v$instance
WHERE substr(version,1,5) != '9.2.0';

Rem =========================================================================
Rem The TO_NUMBER function will raise an error if the database status is not
Rem open for migration.
Rem =========================================================================
/*
#######################################################################
#######################################################################
  The following statement will cause an "ORA-01722: invalid number"
  error if the database has not been opened for MIGRATE.  

  Perform "SHUTDOWN ABORT"  and
  restart using MIGRATE.
#######################################################################
#######################################################################
*/

SELECT TO_NUMBER(status) FROM v$instance
WHERE status != 'OPEN MIGRATE';

Rem =========================================================================
Rem Check the Database Character Set for use of AL24UTFFSS (not supported)
Rem Terminate the upgrade script if it is in use - the database must be 
Rem converted to a supported character set prior to upgrading.
Rem The to_number function will raise an error if there is an AL24UTFFSS value
Rem in the v$nls_parameters view.
Rem =========================================================================

SELECT to_number(value) as no_AL24UTFFSS_upgrade 
FROM v$nls_parameters 
WHERE parameter = 'NLS_CHARACTERSET' AND value = 'AL24UTFFSS'; 

Rem =========================================================================
Rem Continue even if there are SQL errors in remainder of script
Rem =========================================================================

WHENEVER SQLERROR CONTINUE;  
  
Rem =========================================================================
Rem BEGIN STAGE 1: load mandatory tables - please see i0800050.sql
Rem		for definition of what a mandatory table is
Rem =========================================================================

@@i0800050

Rem =========================================================================
Rem END STAGE 1: load mandatory tables
Rem =========================================================================

Rem =========================================================================
Rem BEGIN STAGE 2: invalidate all procedure, packages, functions, trig, typs
Rem =========================================================================

Rem -- NOTHING TO BE DONE HERE since it is already done in migrate.bsq

Rem =========================================================================
Rem END STAGE 2: invalidate all procedure, packages, functions, trig, typs
Rem =========================================================================

Rem =========================================================================
Rem BEGIN STAGE 3: dictionary upgrade
Rem  ***catalog.sql and catproc.sql are run at the end of c08000x0.sql
Rem =========================================================================

@@c0703040

Rem =========================================================================
Rem END STAGE 3: dictionary upgrade
Rem =========================================================================

Rem =========================================================================
Rem BEGIN STAGE 4: upgrade using anonymous pl/sql blocks
Rem =========================================================================

@@a0703040

Rem =========================================================================
Rem END STAGE 4: upgrade using anonymous pl/sql blocks
Rem =========================================================================
