#!/bin/sh

## Initialize all the variabale

LDAP_DIR=${ORACLE_HOME}/ldap
LDAP_ADMIN=${LDAP_DIR}/admin
LDAP_BIN=${LDAP_DIR}/bin
LDAP_LOG=${LDAP_DIR}/log
TMPDIR=${LDAP_DIR}/log
ADD=0
DEVNULL=${LDAP_DIR}/log/null
DELETE=0
ATTR_NAME=null
FILENAME=attr.lst
NO_OF_ATTR=0
ERROR=0
PSWD="A"
OLDMASK=`umask`
bo=`echo  `
no=`echo `

rm -f ${LDAP_LOG}/*.bad



#########FUNCTIONS######

##Function which gives the usage message. 
usage() {
  cat << CATDEL_USAGE
usage : catalog.sh -connect <connect descriptor>  [-add | -delete] [-attr <attribute name> | -file <filename> ]
	-connect <DB connect string>   specifies the Net8 connect descriptor 
                                       used to connect to the database.
	-add                           Add catalog Index.
        -delete                        Delete catalog Index.
	-attr <attribute name>         specifies attribute name. 
        -file <filename>               Filename containing attributes(one per                                          line) which needs to be cataloged.

CATDEL_USAGE
exit 2
}

## Function which gives the error message when wrong connect descriptor given.
usage_nocon() {
 cat << CAT_USAGE_NOCON
Unable to detect database using connect descriptor ${LDAP_CONNECT}. Check
Net8 client connect descriptor configuration settings.
CAT_USAGE_NOCON
}
##
## Function to get alias name
##
getAliasName() {
      echo "set feedback off
            set heading off
            set linesize 10
            set newpage 0
            set space 0
            set pages 0
            set echo off
            spool ${LDAP_LOG}/${attr}alias.lst
            select ods_audit_seq.nextval FROM dual;
            spool off
            exit" > ${TMPDIR}/getalias.sql

${ORACLE_HOME}/bin/sqlplus -s > $DEVNULL 2>&1 << SQLPLUS_EOF
ods/${PSWD}@${LDAP_CONNECT}
@${TMPDIR}/getalias.sql
SQLPLUS_EOF
  if [ -s ${LDAP_LOG}/${attr}alias.lst ] ; then
     ERROR=0
     aliasname=`head -1 ${LDAP_LOG}/${attr}alias.lst | sed -e 's* **g'`
  else
     echo
     echo -----------------------------------------------------
     echo  Cannot Catalog Index for the attribute :: ${attr}
     echo               ERROR while generating alias 
     echo -----------------------------------------------------
     echo
     echo 
     if [ ${FILENAME} = 'attr.lst' ] ; then
       rm -f ${LDAP_LOG}/${attr}alias.lst ${TMPDIR}/getalias.sql > $DEVNULL
       exit
     fi
     ERROR=1
  fi
rm -f ${LDAP_LOG}/${attr}alias.lst ${TMPDIR}/getalias.sql >  $DEVNULL
}

## Function to create or drop synonym
##
synonymManage() {
echo "set feedback off " > ${TMPDIR}/syn.sql
if [ ${ADD} = 1 ] ; then
 if [ ${useAlias} = 1 ] ; then
    echo "CREATE SYNONYM ct_${aliasname} for ods.ct_${aliasname}; 
          commit; " >> ${TMPDIR}/syn.sql
 else
    echo "CREATE SYNONYM ct_${attr} for ods.ct_${attr}; 
          commit; " >> ${TMPDIR}/syn.sql
 fi
else
    echo " DROP SYNONYM ct_${attr} ; 
           commit; " >> ${TMPDIR}/syn.sql
fi
echo "exit; " >> ${TMPDIR}/syn.sql
${ORACLE_HOME}/bin/sqlplus -s  > ${LDAP_LOG}/catalog.log 2>&1 << SQLPLUS_EOF
odscommon/odscommon@${LDAP_CONNECT}
@${TMPDIR}/syn.sql
SQLPLUS_EOF
rm -f ${TMPDIR}/syn.sql >  $DEVNULL
if [ -s ${LDAP_LOG}/catalog.log ] ; then
   echo " Problem encounterd while creating/deleting Catalog for ${attr}"
   echo " See ${LDAP_LOG}/catalog.log "
   echo
fi
}
createdropfile() {
   echo "DROP TABLE ct_${attr} ;  
   DELETE from ds_attrstore where entryid = 912 and 
   attrname = 'orclindexedattribute' and LOWER(attrval) = LOWER('${attr}') ;
   commit;
   exit " > ${TMPDIR}/catalogdrp.sql
}


##--------------CATALOGUEDELETE function------------
## This function will delete the catalog index for all the attributes
## specified in FILENAME.
catalogueDelete() {
for attr in `cat $FILENAME` ; do
   attrN=`echo ${attr} | tr '[:upper:]' '[:lower:]'`
  if [ ${attrN} = 'dn' -o ${attrN} = 'cn' -o ${attrN} = 'objectclass' ] ; then
     echo "Catalog Delete for ${attr} not supported". 
  else
   createdropfile
   echo 
   echo deleting catalog for -- ${attr}
   echo

   ${ORACLE_HOME}/bin/sqlplus -s > ${LDAP_LOG}/catalog.log 2>&1 << SQLPLUS_EOF
ods/${PSWD}@${LDAP_CONNECT}
@${TMPDIR}/catalogdrp.sql
SQLPLUS_EOF

   err=`grep -c ERROR ${LDAP_LOG}/catalog.log`
   del=`grep -c 0 ${LDAP_LOG}/catalog.log`
   rm -f ${TMPDIR}/${attr}.sql  >  $DEVNULL
   if [ ${del} != 0 ] && [ ${err} != 0 ] ; then
      echo  Invalid attribute:  $attr
      echo  OR this attribute is currently not INDEXED
      ERROR=1
   fi
   if [ ${del} = 0 ] && [ ${err} != 0 ] ; then
      echo  Major Problem.. Cataloged table for attribut :: ${attr}
      echo  is dropped but entry specifying that this attribute is 
      echo  Cataloged cannot be deleted.
      ERROR=1
   fi
   if [ ${ERROR} = 0 ] ; then
     synonymManage
   else
     ERROR=0
   fi
  fi
done
   echo
   echo done
   echo
rm -f ${TMPDIR}/catalogdrp.sql > $DEVNULL
}
##--------------CREATETBLFILE function------------
createtblfile() {

if [ $useAlias = 1 ] ; then
echo " set feedback off
       set serveroutput on
       spool ${LDAP_LOG}/${attr}tbl.lst
         DECLARE
         cnt2 INTEGER;
         sqlCommand VARCHAR2(2048);
         sqlCursor  INTEGER;
         tableName VARCHAR2(32);
         curOpen BOOLEAN := FALSE;
         BEGIN
             SELECT count(*) into cnt2 from ds_attrstore  where entryid = 912 
             and attrname like 'orclindexedattribute' 
             and LOWER(attrval) like LOWER('${attr};%');
             IF cnt2 = 0 then
               sqlCommand := 'CREATE TABLE ct_${aliasname} (
                                  ENTRYID     NUMBER NOT NULL,
                                  ATTRVALUE   VARCHAR2(720) ,
                                  ATTRTYPE    VARCHAR2(720))
                               TABLESPACE  OLTS_CT_STORE
                               STORAGE ( FREELISTS 6)' ;
               sqlCursor := dbms_sql.open_cursor;
               curOpen := TRUE;
               dbms_sql.parse( sqlCursor, sqlCommand, dbms_sql.v7 );
               sqlCommand := 'GRANT ALL ON ct_${aliasname} TO ods_server';
               dbms_sql.parse( sqlCursor, sqlCommand, dbms_sql.v7 );
               dbms_sql.close_cursor(sqlCursor);
               curOpen := FALSE;

              INSERT INTO 
              ds_attrstore (entryid, attrname, attrval, attrkind, attrver)
              VALUES (912,'orclindexedattribute', LOWER('${attr};${aliasname}'), 'u', NULL); 
              COMMIT;
             ELSE
                  dbms_output.put_line( 'Error in creating catalog: Attribute already indexed ');
                
             END IF;
               EXCEPTION
                 WHEN OTHERS THEN
                       IF curOpen THEN
                          dbms_sql.close_cursor(sqlCursor);
                          dbms_output.put_line( 'Error in creating catalog table');
                        END IF;
         END;
/
       spool off
       exit" > ${TMPDIR}/catalogtbl.sql

else

echo " set feedback off
       spool ${LDAP_LOG}/${attr}tbl.lst 
           CREATE TABLE ct_${attr} ( 
              ENTRYID     NUMBER NOT NULL,
              ATTRVALUE   VARCHAR2(720) ,
              ATTRTYPE    VARCHAR2(720))
           TABLESPACE OLTS_CT_STORE
           STORAGE ( FREELISTS 6); 
           GRANT ALL ON ct_${attr} TO ods_server;
           GRANT ALL ON ct_${attr} TO odscommon;
           COMMIT;
         variable cnt2 number;
         BEGIN
             SELECT count(*) into :cnt2 from ds_attrstore  where entryid = 912 
             and attrname like 'orclindexedattribute' 
             and attrval = LOWER ( '${attr}' );
             IF :cnt2 = 0 then
              INSERT INTO 
              ds_attrstore (entryid, attrname, attrval, attrkind, attrver)
              VALUES (912,'orclindexedattribute', LOWER('${attr}'), 'u', NULL); 
              COMMIT;
             END IF;
         END;
/
       spool off
       exit" > ${TMPDIR}/catalogtbl.sql
fi

}
##--------------CREATEINDEXFILE function------------
createindexfile() {

if [ $useAlias = 1 ] ; then
       echo "set feedback off
             spool ${LDAP_LOG}/${attr}idx.lst
             CREATE INDEX va_${aliasname} on ct_${aliasname} (attrvalue)
             TABLESPACE OLTS_IND_CT_STORE
             PARALLEL 2 UNRECOVERABLE;
             CREATE UNIQUE INDEX st_${aliasname} on ct_${aliasname} (entryid, attrvalue,attrtype)
             TABLESPACE OLTS_IND_CT_STORE
             PARALLEL 2 UNRECOVERABLE;
             commit;
             spool off
             exit" > ${TMPDIR}/catalogidx.sql 
else
       echo "set feedback off
             spool ${LDAP_LOG}/${attr}idx.lst
             CREATE INDEX va_${attr} on ct_${attr} (attrvalue)
             TABLESPACE OLTS_IND_CT_STORE
             PARALLEL 2 UNRECOVERABLE;
             CREATE UNIQUE INDEX st_${attr} on ct_${attr} (entryid, attrvalue,attrtype)
             TABLESPACE OLTS_IND_CT_STORE
             PARALLEL 2 UNRECOVERABLE;
             commit;
             spool off
             exit" > ${TMPDIR}/catalogidx.sql 

fi
}

##--------------CREATECTLFILE function------------
createctlfile() {
if [ $useAlias = 1 ] ; then
      echo " LOAD DATA 
	     INFILE '${attr}.dat'
	     APPEND
	     INTO TABLE ct_${aliasname}
	     FIELDS TERMINATED BY X'7c7e405e'
	     trailing nullcols
	     (ENTRYID,ATTRTYPE, ATTRVALUE) " > ${TMPDIR}/catalog.ctl
else
      echo " LOAD DATA 
	     INFILE '${attr}.dat'
	     APPEND
	     INTO TABLE ct_${attr}
	     FIELDS TERMINATED BY X'7c7e405e'
	     trailing nullcols
	     (ENTRYID,ATTRTYPE, ATTRVALUE) " > ${TMPDIR}/catalog.ctl
fi
}
##-------------CREATECHKFILE function-------------
createchkfile() {
      echo "set feedback off
            spool ${LDAP_LOG}/${attr}chk.lst
            select * from ds_attrstore
            where entryid = 2
            and attrname = 'attributetypes'
            and LOWER(attrval) like LOWER('%''${attr}''%');
            spool off
            exit" > ${TMPDIR}/catalogchk.sql
}
##------------CHKIFCATALOGED function------------
chkifcataloged() {
## Now check if it is already catalogued, if not then create table.
${ORACLE_HOME}/bin/sqlplus -s  > $DEVNULL 2>&1  << SQLPLUS_EOF
ods/${PSWD}@${LDAP_CONNECT}
@${TMPDIR}/catalogtbl.sql
SQLPLUS_EOF
if [ -s ${LDAP_LOG}/${attr}tbl.lst ] ; then
  echo ------------------------------------------------------------
  echo Errors encountered while creating Catalog for attribute :: $attr
  echo ---- $attr  may already be Indexed  -------------------------
  echo See ${LDAP_LOG}/${attr}tbl.lst file 
  echo
  echo 
  rm -f ${TMPDIR}/catalogtbl.sql  ${TMPDIR}/catalogctl.sql  ${TMPDIR}/catalogidx.sql
  if [ ${FILENAME} = 'attr.lst' ] ; then
       exit
  fi
  ERROR=1
fi
}
##--------------CHECKANDLOAD function------------
checkifAttrExist() {
${ORACLE_HOME}/bin/sqlplus -s > $DEVNULL 2>&1 << SQLPLUS_EOF
ods/${PSWD}@${LDAP_CONNECT}
@${TMPDIR}/catalogchk.sql
SQLPLUS_EOF
  if [ -s ${LDAP_LOG}/${attr}chk.lst ] ; then
     ERROR=0
     #chkifcataloged
  else
     echo
     echo -----------------------------------------------------
     echo  Cannot Catalog Index for the attribute :: ${attr}
     echo               Attribute NOT VALID
     echo -----------------------------------------------------
     echo
     echo 
     if [ ${FILENAME} = 'attr.lst' ] ; then
       exit
     fi
     ERROR=1
  fi
rm -f ${LDAP_LOG}/${attr}chk.lst  ${TMPDIR}/catalogchk.sql > $DEVNULL
}
createidx() {
${ORACLE_HOME}/bin/sqlplus -s > $DEVNULL 2>&1 << SQLPLUS_EOF
ods/${PSWD}@${LDAP_CONNECT}
@${TMPDIR}/catalogidx.sql
SQLPLUS_EOF
  if [ -s ${LDAP_LOG}/${attr}idx.lst ] ; then
      echo ------------------------------------------------------------
      echo Errors encountered while creating Catalog for attribute ::
      echo See ${LDAP_LOG}/${attr}idx.lst file 
      echo
      echo 
      ERROR=1
  else
       rm -f ${LDAP_LOG}/${attr}idx.lst > $DEVNULL
  fi
}
##--------------LOADDATA function------------
loaddata() {
${ORACLE_HOME}/bin/sqlldr ods@${LDAP_CONNECT} control=${TMPDIR}/catalog.ctl log=${LDAP_LOG}/${attr}load.log bad=${LDAP_LOG}/${attr}.bad errors=1000000 DIRECT=TRUE  > $DEVNULL 2>&1 << SQLLDR_EOF
$PSWD
SQLLDR_EOF

   if [ -s ${LDAP_LOG}/${attr}.bad ] ; then
      echo ------------------------------------------------------------
      echo Errors encountered while creating Catalog for attribute ::
      echo --------------- $attr -----------------------------------
      echo See ${LDAP_LOG}/${attr}.bad file 
      echo
      ERROR=1
   fi

rm -f ${TMPDIR}/catalogtbl.sql  ${TMPDIR}/catalog.ctl ${LDAP_LOG}/${attr}tbl.lst ${LDAP_LOG}/${attr}load.log > $DEVNULL
}
      


##--------------CATALOGUEADD function------------
## Function which creates index for the attribute specified.
catalogueAdd() {

## Step 1-- Clean up all dat files
useAlias=0;
for attr in `cat $FILENAME` ; do
     rm -f ${attr}.dat > $DEVNULL
done
if [ ${FILENAME} = 'attr.lst' ] ; then
    attrlen=`echo ${attr} | wc -m` ;
    hyphenmatch=`echo ${attr} | grep -i -` ;
    if [ $attrlen -gt 27 -o -n "$hyphenmatch" ] ; then
       useAlias=1;
    fi
    if [ $useAlias = 1 ] ; then
      getAliasName;
    fi
    createtblfile
    createchkfile
    checkifAttrExist
fi

## Step 2-- Invoke Ldifwrite

if [ ${FILENAME} = 'attr.lst' ] ; then
${ORACLE_HOME}/bin/ldifwrite -c ${LDAP_CONNECT} -b "" -m TRUE -f ${FILENAME} -n 1  2> ${LDAP_LOG}/catalog.log << LDIFW_EOF
$PSWD
LDIFW_EOF
else
${ORACLE_HOME}/bin/ldifwrite -c ${LDAP_CONNECT} -b "" -m TRUE -f ${FILENAME} -n ${NO_OF_ATTR} 2> ${LDAP_LOG}/catalog.log << LDIFW_EOF
$PSWD
LDIFW_EOF
fi
if [ -s ${LDAP_LOG}/catalog.log ] ; then
   echo
   echo Error while creating catalog.
   echo check .. ${LDAP_LOG}/catalog.log
   echo
   exitClean
fi

#Step 3-- For each attribute check if Intermediate file created.. 
##   case A- If not then attibute does not have matching rule or not 
##           supported.
##   case B- If created but does not have data then create the catalog
##           table and appropriate synonym and indexex
##   case C- Have data then load the data also.
for attrN in `cat $FILENAME` ; do
  echo 
  echo " Creating Catalog for Attribute :: $attr "
  echo

  attr=`echo $attrN | tr '[:upper:]' '[:lower:]'`

  ## Check if attrname > 27 chars
  attrlen=`echo ${attr} | wc -m` ;
  hyphenmatch=`echo ${attr} | grep -i -` ;
  if [ $attrlen -gt 27 -o -n "$hyphenmatch" ] ; then
      useAlias=1;
  fi
  if [ $useAlias = 1 ] ; then
    getAliasName;
  fi

  imfiles=`ls *.dat`
  fileexist=0
  for imfile in $imfiles ; do
   if [ ${attr}.dat = $imfile ] ; then
      fileexist=1
   fi
  done
  if [ $fileexist = 1 ] ; then
       ### Create all the required files
       createctlfile
       createindexfile
       createchkfile
       createtblfile
       if [ -s ${attr}.dat ] ; then
              chkifcataloged
              if [ ${ERROR} = 0 ] ; then
               loaddata
              fi
       else
              checkifAttrExist
              if [ ${ERROR} = 0 ] ; then
               chkifcataloged
              fi
       fi
       if [ ${ERROR} = 0 ] ; then
         createidx
         synonymManage
       else
          ERROR=0
       fi
   else
      echo " ${attr} does not have any matching rule or not supported. "
   fi
   ## Reset alias name parameters
   aliasname="";
   useAlias=0;
done

   echo 
   echo done
   echo
	     
}

##--------------CLEANUP function---------------
cleanup() {
for attr in `cat $FILENAME` ; do
rm -f ${LDAP_LOG}/${attr}tbl.lst ${TMPDIR}/catalogtbl.sql ${LDAP_LOG}/${attr}idx.lst ${TMPDIR}/catalogidx.sql ${LDAP_LOG}/${attr}.log ${LDAP_LOG}/${attr}chk.lst ${TMPDIR}/catalogchk.sql  ${TMPDIR}/catalog.ctl  ${TMPDIR}/catalogdrp.sql > $DEVNULL
done
for attrX in `cat $FILENAME` ; do
  attr=`echo $attrX | tr '[:upper:]' '[:lower:]'`
rm -f ${LDAP_LOG}/${attr}tbl.lst ${TMPDIR}/catalogtbl.sql ${LDAP_LOG}/${attr}idx.lst ${TMPDIR}/catalogidx.sql ${LDAP_LOG}/${attr}.log ${LDAP_LOG}/${attr}chk.lst ${TMPDIR}/catalogchk.sql  ${TMPDIR}/catalog.ctl  ${TMPDIR}/catalogdrp.sql > $DEVNULL
done
}

exitClean() {
cleanup
rm -f attr.lst > $DEVNULL
exit
}



## Haldling Command line arguments.
while [ $# -gt 0 ] ; do
	case $1 in
		-connect) LDAP_CONNECT=$2 ;
			if [ -z "${LDAP_CONNECT}" ] ; then
			 	usage ;
			fi
			shift ;;
		-add) ADD=1;;
		-delete) DELETE=1;;
		-file) FILENAME=$2;
		    shift;;
		-w) PSWD=$2;
		    shift;;
		-attr) ATTR_NAME=$2;
                      shift;;
		-*) usage ;;
                 *) usage ;;
	esac
	shift
done	

####VARIOUS CHECKS TO ENSURE PROPER ARGUMENTS ENTERED
if   [ ${ADD} = 1 ]  && [ ${DELETE} = 1 ]   ; then
  echo Only one option among -a and -d can be specified.. Cannot delete and
  echo  add the catalog index for an attribute at the same time.
  usage
fi

if   [ ${ADD} = 0 ]  && [ ${DELETE} = 0 ]   ; then
  echo " Atleast one option -add or -delete must be specified"
  usage
fi

if [ ${ATTR_NAME} = 'null' ] && [ ${FILENAME} = 'attr.lst' ] ; then
  echo Name of the file containig Attribute name OR attribute name 
  echo which is to be Cataloged is not specified. Please specify the  
  echo attribute or Filename for which you want to delete or add INDEX.
  usage
fi
if [ ${ATTR_NAME} != 'null' ] && [ ${FILENAME} != 'attr.lst' ] ; then
  echo Only one of either attribute or Filename can be specified.
  usage
fi
### Delete or Add of some specific catalogs not allowed
###
if [ ${ATTR_NAME} = 'dn' -o ${ATTR_NAME} = 'DN' -o ${ATTR_NAME} = 'dN' -o ${ATTR_NAME} = 'Dn'    ] ; then
  echo Cannot Add or delete catalog for ...${ATTR_NAME} ... 
  echo 
  exit
fi
if [ ${ATTR_NAME} = 'cn' -o ${ATTR_NAME} = 'CN' -o ${ATTR_NAME} = 'cN' -o ${ATTR_NAME} = 'Cn'    ] ; then
  echo Cannot Add or delete catalog for ...${ATTR_NAME} ... 
  echo 
  exit
fi


if [ ${ATTR_NAME} != 'null' ] && [ ${FILENAME} = 'attr.lst' ] ; then
  echo ${ATTR_NAME} > ${FILENAME}
fi

tnsping ${LDAP_CONNECT}  > $DEVNULL 
if [ $? != 0 ] ; then
  usage_nocon
  usage
fi

if [ -z $ORACLE_HOME ] 
then
  echo ORACLE_HOME not set 
  exit 1
fi

####THis is the Security Implementation######
if [ ${PSWD} = "A" ] ; then
   echo " "
   echo "${bo}This tool can only be executed if you know database user password for OiD${no}"  
   echo " "
   printf "Enter OiD password ::" 
   stty -echo; read PSWD ; stty echo ; echo
   clear
fi
# Set umask so that only 'owner' has rw permissions and group/other have none
umask 077
echo " set feedback off
   connect ods/${PSWD}@${LDAP_CONNECT} ;
   exit; " > ${TMPDIR}/seccheck.sql
### check if the password provided is correct
${ORACLE_HOME}/bin/sqlplus   > ${LDAP_LOG}/catchecK.lst << SQLPLUS_EOF
odscommon/odscommon@${LDAP_CONNECT}
@${TMPDIR}/seccheck.sql
SQLPLUS_EOF
err=`grep -c ERROR ${LDAP_LOG}/catchecK.lst`
rm -f ${LDAP_LOG}/seccheck.lst ${TMPDIR}/seccheck.sql > $DEVNULL
if [ ${err} != 0 ] ; then
  echo " Password for OiD user is WRONG.."
  echo " Cannot execute this tool ..."
  exit
fi
#restore original umask
umask ${OLDMASK}

cleanup

  





### CHECKS COMPLETE ####


if [ ${DELETE} = 1 ] ; then
    echo ------------------------------------------------------------
    echo  DELETING CATALOG INDEXES
    echo ------------------------------------------------------------
    echo 
    echo
    catalogueDelete
else
    echo ------------------------------------------------------------
    echo  ADDING CATALOG INDEXES
    echo ------------------------------------------------------------
    echo 
    echo
    NO_OF_ATTR=`cat ${FILENAME} | wc -w `
    catalogueAdd
fi

rm -f  ${TMPDIR}/catalogtbl.sql  ${TMPDIR}/catalogidx.sql  ${TMPDIR}/catalogchk.sql  ${TMPDIR}/catalog.ctl  ${TMPDIR}/catalogdrp.sql > $DEVNULL

for attr in `cat $FILENAME` ; do
     rm -f ${attr}.dat > $DEVNULL
done

