###############################################################################
# $Header: deadmanager.tcl 30-nov-2005.05:29:42 mkiran Exp $
#
# Copyright (c) 2001, 2005, Oracle. All rights reserved.  
#
# NAME:
#
#  deadmanager.tcl : Event script to check status of concurrent managers
#
# ARGUMENTS:
#  
#           argv(0) == db username
#           argv(1) == db passwd
#           argv(2) == db connect string or alias
#	    argv(3) == Time length to determine unresponsiveness
#	    argv(4) == Placeholder
#  
# $Log:  $
#         mkiran   11/12/2005 - bug4557548: Comment last_report init setting
#         vtummala 08/02/1999
#
#
###############################################################################

# Event definition
oradefine event /oracle/cmanager/fault/deadmanager
oraarguments cmuser cmpasswd cmconstr timevar phold
oravardesc cmuser string
oravardesc cmpasswd string
oravardesc cmconstr string
oravardesc timevar string
oravardesc phold string
oradefine end

# The output variable is always needed, by the agent 
# in it's current state - 01/18/99
set output " "

# bug4557548: CLEAR_EVENT setting for last_report will not give expected
# event evaluation results for all combinations of Agent and cmanager target
# bounces. So, comment this setting.
#set last_report $CLEAR_EVENT

proc EvalEvent {} {
    
# Global Declarations 
global SCRIPT_FAIL CLEAR_EVENT NO_EVENT WARNING_EVENT ALERT_EVENT
global argv oramsg 
global last_report 
global output 
global cur

# build connect string
set user    [lindex $argv 0];
set pwd     [lindex $argv 1];
set constr  [lindex $argv 2];
set alias   $oramsg(oraobject)
set connect "$user/$pwd@$constr"

# don't put passwords in trace file
set logconnect "$user/<PASSWORD>@$constr"

set pmon  [lindex [lindex $argv 3] 0];
set twopmon [expr 15+$pmon]
ORATCL_DEBUG "deadmanager: pmon $twopmon"

# Need to define messages to display logon or tns alias problems
# if we can't connect to the database, ICM is probably down,
# but since this could be just that our connect string is bad
# we return SCRIPT_FAIL
# here in the preamble, we shouldn't ever actually find last_report as
# SCRIPT_FAIL, but I'm leaving the test in case things get moved around
if {[catch {oralogon $connect} lda]} {
    ORATCL_DEBUG "deadmanager : [oratime] logon failed to $logconnect"
    ORATCL_DEBUG "errortxt $oramsg(errortxt)"
    ORATCL_DEBUG "ocifunc $oramsg(ocifunc)"
    ORATCL_DEBUG "sqlfunc $oramsg(sqlfunc)"
    ORATCL_DEBUG "return code:  $oramsg(rc) "
    if {$last_report == $SCRIPT_FAIL} {
	return $NO_EVENT
    } else {
	set last_report $SCRIPT_FAIL
	set output [format [msgtxt [NETWORK] smamp 6000] "deadmanager"]
	set output [convertout $oramsg(agent_characterset) $output]
	return $SCRIPT_FAIL
    } 
}
ORATCL_DEBUG "deadmanager : [oratime] logon success using $logconnect" 

# open cursor
if {[catch {oraopen $lda} cur]} {
    ORATCL_DEBUG "deadmanager : [oratime] failed to open cursor"
    ORATCL_DEBUG "errortxt $oramsg(errortxt)"
    ORATCL_DEBUG "ocifunc $oramsg(ocifunc)"
    ORATCL_DEBUG "sqlfunc $oramsg(sqlfunc)"
    ORATCL_DEBUG "return code:  $oramsg(rc) "
    set last_report $SCRIPT_FAIL
    set output [format [msgtxt [NETWORK] smamp 6001] "deadmanager"]
    set output [convertout $oramsg(agent_characterset) $output]
    oralogoff $lda
    return $SCRIPT_FAIL
}
ORATCL_DEBUG "deadmanager : [oratime] opened cursor" 

set plsqlblock {  declare 
target number; 
active number; 
pmon   varchar2(30); 
stat   number; 
begin 
fnd_concurrent.get_manager_status(targetp => target, 
activep => active, 
pmon_method => pmon, 
callstat => stat); 
if (stat = 0 and active > 0) then 
:isup := 'Y'; 
else  
:isup := 'N'; 
end if; 
end; 
}

# initialize the return code
set ret_code $CLEAR_EVENT

# The main event checking function
# get status of ICM. If we can log on, but not find the package
# or otherwise run it sucessfully, it is probably script failure
# but we'll trigger the event the first time through since the
# database is probably hosed to the point that CM is effectively
# down.
if {[catch {oraplexec $cur $plsqlblock :isup " " } retlist]} {
    ORATCL_DEBUG "deadmanager : [oratime] plsql failed "
    ORATCL_DEBUG "errortxt $oramsg(errortxt)"
    ORATCL_DEBUG "ocifunc $oramsg(ocifunc)"
    ORATCL_DEBUG "sqlfunc $oramsg(sqlfunc)"
    ORATCL_DEBUG " return code:  $oramsg(rc) "
    ORATCL_DEBUG " return value is: $retlist"
    
    # Close the cursor and logoff
# If fail, cursor comes back closed: Bug#1093413
#    oraclose $cur
    oralogoff $lda
    
    set output [format [msgtxt [NETWORK] smamp 6002] "deadmanager.tcl"]
    set output [convertout $oramsg(agent_characterset) $output]
    
    if {$last_report == $SCRIPT_FAIL} {
	return $NO_EVENT
    } else {
	set last_report $SCRIPT_FAIL
	return $SCRIPT_FAIL
    } 
}

# happy with value?
if { $retlist == "Y" } {
ORATCL_DEBUG "deadmanager: Checked the ICM and it is Alive"
    
set plsqlcm {  declare 
target number; 
active number; 
pmon   varchar2(30); 
stat   number; 
begin 
fnd_concurrent.get_manager_status(:applid, :concid,
targetp => target, 
activep => active, 
pmon_method => pmon, 
callstat => stat); 
if (stat = 0 and active > 0) then 
:isup := 'Y'; 
else  
:isup := 'N'; 
end if; 
end; 
}

#############
# This initial query will find all of the CMs
# on which we will need to check the status
#############
set sqlcm "/* OracleOEM */ select application_id, concurrent_queue_id from fnd_concurrent_queues where control_code IS NULL OR (control_code != 'E' AND control_code != 'X') AND enabled_flag != 'N'"

    if {[catch {orasql $cur $sqlcm} err]} {
	ORATCL_DEBUG "deadmanager: $err"
	oralogoff $lda
	set output [format [msgtxt [NETWORK] smamp 6002] "sql deadmanager.tcl"]
	set output [convertout $oramsg(agent_characterset) $output]
	
	if {$last_report == $SCRIPT_FAIL} {
	    return $NO_EVENT
	} else {
	    set last_report $SCRIPT_FAIL
	    return $SCRIPT_FAIL
	} 
    }
    
    if {[catch {set row [orafetch $cur]} err]} {
	catch {oralogoff $lda} err
	if {$last_report == $SCRIPT_FAIL} {
	    return $NO_EVENT
	} else {
	    set last_report $SCRIPT_FAIL
	    return $SCRIPT_FAIL
	}
    }

    # initialize the return code
    set ret_code $CLEAR_EVENT
    
    set masterlist {}
    set errorlist {}
    set finalerrorlist {}
    set tmp {}
    while {$row != ""} {
	set app_id [lindex $row 0]
	set conc_id [lindex $row 1]
	
	if { !($app_id == 0 && $conc_id == 1) } {
	    # Don't Test the ICM
	    lappend tmp $app_id $conc_id
	    lappend masterlist $tmp
	    set tmp {}
	}

	if {[catch {set row [orafetch $cur]} err]} {
	    catch {oralogoff $lda} err
	    if {$last_report == $SCRIPT_FAIL} {
		return $NO_EVENT
	    } else {
		set last_report $SCRIPT_FAIL
		return $SCRIPT_FAIL
	    }
	}
    }	

    set cmcount [llength $masterlist]
    ORATCL_DEBUG "deadmanager: Rows: $cmcount, CM List: $masterlist"
    
######
# There has to be more than the ICM available for action
######    
    if {$cmcount == 0} {
        oralogoff $lda
        set output [msgtxt [NETWORK] smamp 6012]
        set output [convertout $oramsg(agent_characterset) $output]
	if {$last_report == $CLEAR_EVENT} {
            return $NO_EVENT
        } else {
            set last_report $CLEAR_EVENT
            return $CLEAR_EVENT
        }
    }

###############
# Check all of the CMs in the list to see which are up
# and which are down
###############
    foreach cmpair $masterlist {
	set app_id [lindex $cmpair 0]
	set conc_id [lindex $cmpair 1]

	if {[catch {oraplexec $cur $plsqlcm :applid $app_id :concid $conc_id :isup "" } cmretlist]} {
	    ORATCL_DEBUG "deadmanager : [oratime] plsql failed "
	    ORATCL_DEBUG "errortxt $oramsg(errortxt)"
	    ORATCL_DEBUG "ocifunc $oramsg(ocifunc)"
	    ORATCL_DEBUG "sqlfunc $oramsg(sqlfunc)"
	    ORATCL_DEBUG " return code:  $oramsg(rc) "
	    ORATCL_DEBUG " return value is: $retlist"
	    
	    # Close the cursor and logoff
	    # If fail, cursor comes back closed: Bug#1093413
	    #    oraclose $cur
	    oralogoff $lda
	    
	    set output [format [msgtxt [NETWORK] smamp 6002] "deadmanager.tcl"]
	    set output [convertout $oramsg(agent_characterset) $output]
	    
	    if {$last_report == $SCRIPT_FAIL} {
		return $NO_EVENT
	    } else {
		set last_report $SCRIPT_FAIL
		return $SCRIPT_FAIL
	    } 
	}
	
	set updown [lindex $cmretlist 2]
	if { $updown != "Y" } {
	    lappend errorlist $cmpair   
	}
    }

############
# If any of the CMs are down, sleep for the amount of time
# specified by the user (twopmon) and then test those CMs
# again.  If any are stil down, they are considered dead
############    
    if { [llength $errorlist] > 0 } {
	ORATCL_DEBUG "deadmanager: [llength $errorlist] Managers down in the first round"
	orasleep $twopmon
	# sleep and try again
	foreach errorpair $errorlist {
	    if {[catch {oraplexec $cur $plsqlcm :applid $app_id :concid $conc_id :isup "" } cmretlist2]} {
		ORATCL_DEBUG "deadmanager : [oratime] plsql failed "
		ORATCL_DEBUG "errortxt $oramsg(errortxt)"
		ORATCL_DEBUG "ocifunc $oramsg(ocifunc)"
		ORATCL_DEBUG "sqlfunc $oramsg(sqlfunc)"
		ORATCL_DEBUG " return code:  $oramsg(rc) "
		ORATCL_DEBUG " return value is: $retlist"
		
		# Close the cursor and logoff
		# If fail, cursor comes back closed: Bug#1093413
		#    oraclose $cur
		oralogoff $lda
		
		set output [format [msgtxt [NETWORK] smamp 6002] "deadmanager.tcl"]
		set output [convertout $oramsg(agent_characterset) $output]
		
		if {$last_report == $SCRIPT_FAIL} {
		    return $NO_EVENT
		} else {
		    set last_report $SCRIPT_FAIL
		    return $SCRIPT_FAIL
		} 
	    }
	    
	    set updown2 [lindex $cmretlist2 2]
	    if { $updown2 != "Y" } {
		lappend finalerrorlist $errorpair
	    }
	}
	if { [llength $finalerrorlist] > 0 } {
	    # Close the cursor and log off 
	    oraclose $cur
	    oralogoff $lda
	    set output "$finalerrorlist"
	    if {$last_report == $ALERT_EVENT} {
		return $NO_EVENT
	    } else {
		set last_report $ALERT_EVENT
		return $ALERT_EVENT
	    } 
	}
    }
    
} else {
    set output $alias
    set output [convertout $oramsg(agent_characterset) $output]
    ORATCL_DEBUG "deadmanager: $oramsg(oraobject) : [oratime] : output: $output" 
    set ret_code $NO_EVENT
}

# Close the cursor and log off 
oraclose $cur
oralogoff $lda

# return
if {$last_report == $ret_code} {    
    return $NO_EVENT
} else {
    ORATCL_DEBUG "deadmanager : $oramsg(oraobject) : [oratime] :  $ret_code"
    set last_report $ret_code
    return $ret_code 
}

}

