###############################################################################
# $Header: icmwait.tcl 30-nov-2005.05:31:06 mkiran Exp $
#
# Copyright (c) 1995, 2005, Oracle. All rights reserved.  
#
# NAME:
#
#  icmwait.tcl : Event script to check if ICM is waiting on lock
#
# ARGUMENTS:
#
#           argv(0) == db username
#           argv(1) == db passwd
#	    argv(2) == alert threshold
#	    argv(3) == warning threshold
#
# $Log:  $
#         mkiran   11/12/2005 - bug4557548: Comment last_report init setting
#
#
###############################################################################

# Event definition
oradefine event /oracle/cmanager/fault/icmwait
oraarguments cmuser cmpasswd alert warning 
oravardesc cmuser string
oravardesc cmpasswd string
oravardesc alert int
oravardesc warning int
oradefine end

# The output variable is always needed, by the agent
# in it's current state - 01/18/99
set output " "

# bug4557548: CLEAR_EVENT setting for last_report will not give expected
# event evaluation results for all combinations of Agent and cmanager target
# bounces. So, comment this setting.
#set last_report $CLEAR_EVENT


proc EvalEvent {} {
    
# Global Declarations
global SCRIPT_FAIL CLEAR_EVENT NO_EVENT WARNING_EVENT ALERT_EVENT
global argv oramsg
global last_report
global output
global cur

# build connect string
set user [lindex $argv 0];
set pwd  [lindex $argv 1];
set alias   $oramsg(oraobject)
set connect "$user/$pwd@$alias"

# don't put passwords in trace file
set logconnect "$user/<PASSWORD>@$alias"

# get the thresholds 
set alert_threshold   [lindex $argv 2];
set warning_threshold [lindex $argv 3];
ORATCL_DEBUG "icmwait:  alert_threshold   is set to - $alert_threshold"
ORATCL_DEBUG "icmwait:  warning_threshold is set to - $warning_threshold"

# if we can't connect to the database, ICM is probably down,
# but since this could be just that our connect string is bad
# we return SCRIPT_FAIL
if {[catch {oralogon $connect} lda]} {
    ORATCL_DEBUG "icmwait : [oratime] logon failed to $logconnect"
    ORATCL_DEBUG "errortxt $oramsg(errortxt)"
    ORATCL_DEBUG "ocifunc $oramsg(ocifunc)"
    ORATCL_DEBUG "sqlfunc $oramsg(sqlfunc)"
    ORATCL_DEBUG "return code:  $oramsg(rc) "
    if {$last_report == $SCRIPT_FAIL} {
        return $NO_EVENT
    } else {
        set last_report $SCRIPT_FAIL
	set output [format [msgtxt [NETWORK] smamp 6000] "icmwait"]
	set output [convertout $oramsg(agent_characterset) $output]
        return $SCRIPT_FAIL
    }
}
ORATCL_DEBUG "icmwait : [oratime] logon success using $logconnect"

# open cursor
if {[catch {oraopen $lda} cur]} {
    ORATCL_DEBUG "cmupdown : [oratime] failed to open cursor"
    ORATCL_DEBUG "errortxt $oramsg(errortxt)"
    ORATCL_DEBUG "ocifunc $oramsg(ocifunc)"
    ORATCL_DEBUG "sqlfunc $oramsg(sqlfunc)"
    ORATCL_DEBUG "return code:  $oramsg(rc) "
    set last_report $SCRIPT_FAIL
    set output [format [msgtxt [NETWORK] smamp 6001] "icmwait"]
    set output [convertout $oramsg(agent_characterset) $output]
    oralogoff $lda
    return $SCRIPT_FAIL
}
ORATCL_DEBUG "icmwait : [oratime] opened cursor"

# Tie the audit session ID to look into v$session and then to v$lock
# for the holder of the locking session, blocking the ICM (whose
# Concurrent Queue ID is 1) from continuing. Get the time to determine
# whether to throw an alert or a warning depending on the thresholds
# set by the user.

set plsqlblock { declare 
begin
/* OracleOEM */
select  /*+ RULE */ hl.ctime , hs.audsid, hs.program, hs.osuser, hs.process, 
hs.machine, hs.terminal,
decode (hl.lmode, 1, 'NULL', 2, 'ROW SHARE', 3, 'ROW EXCLUSIVE', 4 , 
'SHARE' , 5, 'SHARE ROW EXCLUSIVE',  6, 'EXCLUSIVE', '?') 
into    :wait_time , :session_id, :program_name, :osuser_name, 
:process_id, :machine_name, :terminal_name, :lock_mode
from v$session hs, v$lock hl, v$lock wl, v$session ws, fnd_concurrent_processes p
where p.queue_application_id = 0 and 
p.concurrent_queue_id = 1  and
p.PRocess_Status_Code = 'A' and
p.session_id = ws.audsid and 
ws.lockwait is not null and 
ws.lockwait = wl.kaddr  and 
wl.id1 = hl.id1 and wl.id2 = hl.id2 and hl.request = 0 and 
hl.sid = hs.sid 
;
end ;
}

# initialize the return code
set ret_code $CLEAR_EVENT

# The main event checking function
if {[catch {oraplexec $cur $plsqlblock :wait_time "" :session_id "" :program_name "" :osuser_name "" :process_id "" :machine_name "" :terminal_name "" :lock_mode "" } retlist]} {
    ORATCL_DEBUG "icmwait : [oratime] plsql failed "
    ORATCL_DEBUG "errortxt $oramsg(errortxt)"
    ORATCL_DEBUG "ocifunc $oramsg(ocifunc)"
    ORATCL_DEBUG "sqlfunc $oramsg(sqlfunc)"
    ORATCL_DEBUG " return code:  $oramsg(rc) "
    ORATCL_DEBUG " return value is: $retlist"
    
    # Close the cursor and logoff
#    oraclose $cur
    oralogoff $lda
   
    set output [format [msgtxt [NETWORK] smamp 6002] "icmwait.tcl"] 
    set output [convertout $oramsg(agent_characterset) $output]
    
    if {$last_report == $SCRIPT_FAIL} {
        return $NO_EVENT
    } else {
        set last_report $SCRIPT_FAIL
        return $SCRIPT_FAIL
    }
}

set session_id 	 [lindex $retlist 1]
set program_name [lindex $retlist 2]
set osuser_name  [lindex $retlist 3]
set process_id   [lindex $retlist 4]
set machine_name [lindex $retlist 5]
set term_name    [lindex $retlist 6]
set lock_mode 	 [lindex $retlist 7]


# extract the value of the lock wait time, to decide 
# whether or not to issue an Alert or Warning as may be neccessary
# per the thresholds set by the user. 
set lock_wait_time [lindex $retlist 0]
ORATCL_DEBUG "icmwait: lock wait time - $lock_wait_time Sessionid - $session_id
 process_id - $process_id machine_name - $machine_name term_name $term_name lock_mode $lock_mode " 
set output $session_id
lappend output $lock_wait_time

if { $lock_wait_time > $alert_threshold * 60  } {
    set ret_code $ALERT_EVENT
    lappend output "Alert"
    lappend output $alert_threshold 

} elseif {$lock_wait_time > $warning_threshold * 60 } {
    set ret_code $WARNING_EVENT
    lappend output "Warning"
    lappend output $warning_threshold
}
    lappend output $process_id
    lappend output $osuser_name
    lappend output $lock_mode 
    lappend output $machine_name
    lappend output $term_name

# set the value of the locking session id to output 
# so that if a fix-it job exists for this event, it could read 
# trigevent (result) to kill the locking session as may be 
# neccessary.
# set output $session_id 

# Close the cursor and log off
oraclose $cur
oralogoff $lda

# return
if {$last_report == $ret_code} {
    return $NO_EVENT
} else {
    ORATCL_DEBUG "icmwait : $oramsg(oraobject) : [oratime] :  $ret_code"
    set last_report $ret_code
    return $ret_code
}

}
