###############################################################################
# $Header: reqwarns.tcl 30-nov-2005.05:38:35 mkiran Exp $
#
# Copyright (c) 1995, 2005, Oracle. All rights reserved.  
#
# NAME:
#
#  reqwarns.tcl : Request Warning Rate 
#
# ARGUMENTS:
#
#           argv(0) == db username
#           argv(1) == db passwd
#	    argv(2) == alert threshold
#	    argv(3) == warning threshold
#
# $Log:  $
# This is part of the Application Management Pak - Advanced Events for
#                                                  Concurrent Manager
# mkiran   11/12/2005 - bug4557548: Comment last_report init setting
# vtummala 08/02/1999
#
#
###############################################################################

# Event definition
oradefine event /oracle/cmanager/fault/reqwarns
oraarguments cmuser cmpasswd alert warning 
oravardesc cmuser string
oravardesc cmpasswd string
oravardesc alert int
oravardesc warning int
oradefine end

# The output variable is always needed, by the agent
# in it's current state - 01/18/99
set output " "

# bug4557548: CLEAR_EVENT setting for last_report will not give expected
# event evaluation results for all combinations of Agent and cmanager target
# bounces. So, comment this setting.
#set last_report $CLEAR_EVENT

proc EvalEvent {} {
    
# Global Declarations
global SCRIPT_FAIL CLEAR_EVENT NO_EVENT WARNING_EVENT ALERT_EVENT
global argv oramsg
global last_report
global output
global cur

# build connect string
set user [lindex $argv 0];
set pwd  [lindex $argv 1];
set alias   $oramsg(oraobject)
set connect "$user/$pwd@$alias"

# don't put passwords in trace file
set logconnect "$user/<PASSWORD>@$alias"

# get the thresholds 
set alert_threshold   [lindex $argv 2];
set warning_threshold [lindex $argv 3];

# if we can't connect to the database, ICM is probably down,
# but since this could be just that our connect string is bad
# we return SCRIPT_FAIL
if {[catch {oralogon $connect} lda]} {
    ORATCL_DEBUG "reqwarns : [oratime] logon failed to $logconnect"
    ORATCL_DEBUG "errortxt $oramsg(errortxt)"
    ORATCL_DEBUG "ocifunc $oramsg(ocifunc)"
    ORATCL_DEBUG "sqlfunc $oramsg(sqlfunc)"
    ORATCL_DEBUG "return code:  $oramsg(rc) "
    if {$last_report == $SCRIPT_FAIL} {
        return $NO_EVENT
    } else {
        set last_report $SCRIPT_FAIL
	set output [format [msgtxt [NETWORK] smamp 6000] "reqwarns"]
	set output [convertout $oramsg(agent_characterset) $output]
        return $SCRIPT_FAIL
    }
}
ORATCL_DEBUG "reqwarns : [oratime] logon success using $logconnect"

# open cursor
if {[catch {oraopen $lda} cur]} {
    ORATCL_DEBUG "reqwarns : [oratime] failed to open cursor"
    ORATCL_DEBUG "errortxt $oramsg(errortxt)"
    ORATCL_DEBUG "ocifunc $oramsg(ocifunc)"
    ORATCL_DEBUG "sqlfunc $oramsg(sqlfunc)"
    ORATCL_DEBUG "return code:  $oramsg(rc) "
    set last_report $SCRIPT_FAIL
    set output [format [msgtxt [NETWORK] smamp 6001] "reqwarns"]
    set output [convertout $oramsg(agent_characterset) $output]
    oralogoff $lda
    return $SCRIPT_FAIL
}
ORATCL_DEBUG "reqwarns : [oratime] opened cursor"

# Compute the Percentage of Concurrent requests 
# in the Warning state 
set plsqlblock { declare 
requests_in_warning	number;
total_requests 		number;
begin
/* OracleOEM */
select  count(*)
into    requests_in_warning
from    fnd_concurrent_requests 
where   status_code = 'G';

select  count(*) 
into    total_requests 
from    fnd_concurrent_requests
where   phase_code = 'C';

if (total_requests != 0) then 
:reqwarnings_pct := requests_in_warning * 100/ total_requests;
else 
:reqwarnings_pct := 0 ;
end if; 
end ;
}

# initialize the return code
set ret_code $CLEAR_EVENT

# The main event checking function
if {[catch {oraplexec $cur $plsqlblock :reqwarnings_pct "" } retlist]} {
    ORATCL_DEBUG "reqwarns : [oratime] plsql failed "
    ORATCL_DEBUG "errortxt $oramsg(errortxt)"
    ORATCL_DEBUG "ocifunc $oramsg(ocifunc)"
    ORATCL_DEBUG "sqlfunc $oramsg(sqlfunc)"
    ORATCL_DEBUG " return code:  $oramsg(rc) "
    ORATCL_DEBUG " return value is: $retlist"
    
    # Close the cursor and logoff
#    oraclose $cur
    oralogoff $lda
    
    set output [format [msgtxt [NETWORK] smamp 6002] "reqwarns"]
    set output [convertout $oramsg(agent_characterset) $output]
    
    if {$last_report == $SCRIPT_FAIL} {
        return $NO_EVENT
    } else {
        set last_report $SCRIPT_FAIL
        return $SCRIPT_FAIL
    }
}

# happy with value ? 
set curr_value [lindex $retlist 0]
ORATCL_DEBUG "reqwarns : [oratime] reqwarns pct is: $curr_value %"
if { $curr_value > $alert_threshold } {
    set output $curr_value 
    lappend output "alert"
    lappend output $alert_threshold
    set ret_code $ALERT_EVENT
} elseif {$curr_value > $warning_threshold } {
    set output $curr_value 
    lappend output "warning"
    lappend output $warning_threshold
    set ret_code $WARNING_EVENT 
}

# Close the cursor and log off
oraclose $cur
oralogoff $lda

# return
if {$last_report == $ret_code} {
    return $NO_EVENT
} else {
    ORATCL_DEBUG "reqwarns: $oramsg(oraobject) : [oratime] : $ret_code"
    set last_report $ret_code
    return $ret_code
}
}
