###############################################################################
# $Header: reqwarnsn.tcl 30-nov-2005.05:40:24 mkiran Exp $
#
# Copyright (c) 1995, 2005, Oracle. All rights reserved.  
#
# NAME:
#
#  reqwarnsn.tcl : Request Warning Rate 
#
# ARGUMENTS:
#
#           argv(0) == db username
#           argv(1) == db passwd
#	    argv(2) == db connect string or alias
#	    argv(3) == alert threshold
#	    argv(4) == warning threshold
#	    argv(5) == Inclusion/Exclusion Indicator
#	    argv(6) == Program list
#	    argv(7) == Placeholder
#
# $Log:  $
# This is part of the Application Management Pak - Advanced Events for
#                                                  Concurrent Manager
# mkiran   11/12/2005 - bug4557548: Comment last_report init setting
# vtummala 08/02/1999
#
#
###############################################################################

# Event definition
oradefine event /oracle/cmanager/fault/reqwarnsn
oraarguments cmuser cmpasswd cmconstr alert warning filterchoice filterlist phold
oravardesc cmuser string
oravardesc cmpasswd string
oravardesc cmconstr string
oravardesc alert int
oravardesc warning int
oravardesc filterchoice int
oravardesc filterlist string
oravardesc phold string
oradefine end

# The output variable is always needed, by the agent
# in it's current state - 01/18/99
set output " "

# bug4557548: CLEAR_EVENT setting for last_report will not give expected
# event evaluation results for all combinations of Agent and cmanager target
# bounces. So, comment this setting.
#set last_report $CLEAR_EVENT

proc EvalEvent {} {
    
# Global Declarations
global SCRIPT_FAIL CLEAR_EVENT NO_EVENT WARNING_EVENT ALERT_EVENT
global argv oramsg
global last_report
global output
global cur
global where_clause_W where_clause_C where_clause_EX
global from_clause excl_oper comb_oper masterlist

# build connect string
set user [lindex $argv 0];
set pwd  [lindex $argv 1];
set constr   [lindex $argv 2];
set alias   $oramsg(oraobject)
set connect "$user/$pwd@$constr"

# don't put passwords in trace file
set logconnect "$user/<PASSWORD>@$constr"

# get the thresholds 
set alert_threshold   [lindex $argv 3];
set warning_threshold [lindex $argv 4];

# get filter inputs
set fchoice [lindex $argv 5];
set flist [lindex $argv 6];

# if we can't connect to the database, ICM is probably down,
# but since this could be just that our connect string is bad
# we return SCRIPT_FAIL
if {[catch {oralogon $connect} lda]} {
    ORATCL_DEBUG "reqwarnsn : [oratime] logon failed to $logconnect"
    ORATCL_DEBUG "errortxt $oramsg(errortxt)"
    ORATCL_DEBUG "ocifunc $oramsg(ocifunc)"
    ORATCL_DEBUG "sqlfunc $oramsg(sqlfunc)"
    ORATCL_DEBUG "return code:  $oramsg(rc) "
    if {$last_report == $SCRIPT_FAIL} {
        return $NO_EVENT
    } else {
        set last_report $SCRIPT_FAIL
	set output [format [msgtxt [NETWORK] smamp 6000] "reqwarnsn"]
	set output [convertout $oramsg(agent_characterset) $output]
        return $SCRIPT_FAIL
    }
}
ORATCL_DEBUG "reqwarnsn : [oratime] logon success using $logconnect"

# open cursor
if {[catch {oraopen $lda} cur]} {
    ORATCL_DEBUG "reqwarnsn : [oratime] failed to open cursor"
    ORATCL_DEBUG "errortxt $oramsg(errortxt)"
    ORATCL_DEBUG "ocifunc $oramsg(ocifunc)"
    ORATCL_DEBUG "sqlfunc $oramsg(sqlfunc)"
    ORATCL_DEBUG "return code:  $oramsg(rc) "
    set last_report $SCRIPT_FAIL
    set output [format [msgtxt [NETWORK] smamp 6001] "reqwarnsn"]
    set output [convertout $oramsg(agent_characterset) $output]
    oralogoff $lda
    return $SCRIPT_FAIL
}
ORATCL_DEBUG "reqwarnsn : [oratime] opened cursor"

# Default PLSQL Query components
set where_clause_W {
where status_code = 'G'; }

set where_clause_C {
where phase_code = 'C'; }

set from_clause {
from fnd_concurrent_requests }

# Defaults to exclusion of items in filter list
set excl_oper " NOT "
set comb_oper " AND "

set where_clause_EX ""

set masterlist {}
if { $fchoice != 0 } {

# Defaults to Apps 11 format
set langvar {userenv('LANG')}

# Query Instance for version number to change langvar
set plsqlblockLANG { declare 
apps_version varchar2(30) ;
begin
/* OracleOEM */
select  product_version
into    :appver
from fnd_product_installations
where application_id = 0;
end;
}

if {[catch {oraplexec $cur $plsqlblockLANG :appver "" } retlist]} {
    ORATCL_DEBUG "reqwarnsn : [oratime] plsql failed "
    ORATCL_DEBUG "errortxt $oramsg(errortxt)"
    ORATCL_DEBUG "ocifunc $oramsg(ocifunc)"
    ORATCL_DEBUG "sqlfunc $oramsg(sqlfunc)"
    ORATCL_DEBUG " return code:  $oramsg(rc) "
    ORATCL_DEBUG " return value is: $retlist"
    
    # Close the cursor and logoff
# If fail, cursor comes back closed: Bug#1093413
#    oraclose $cur
    oralogoff $lda
    
    set output [format [msgtxt [NETWORK] smamp 6002] "reqwarnsn.tcl"] 
    set output [convertout $oramsg(agent_characterset) $output]
    if {$last_report == $SCRIPT_FAIL} {
        return $NO_EVENT
    } else {
        set last_report $SCRIPT_FAIL
        return $SCRIPT_FAIL
    }
}

set apps_ver [lindex $retlist 0]
ORATCL_DEBUG "reqwarnsn: [oratime] apps version number is : $apps_ver " 

set isapps107 [regexp {6\.1\.} $apps_ver]
if { $isapps107 } {
    set langvar {substr(userenv('LANGUAGE'), 1, instr(userenv('LANGUAGE'), '_') -1)}
}

# Builds the list: trims trailing and preceding whitespaces
#     accepts comma delimited program name entries
set filter_list [split $flist "|"]
foreach name_group $filter_list {
    set namepair {}
    set not_blank [regexp (:) $name_group]
    set contains_chars [regexp -nocase {[0-9a-z]+} $name_group]
    if { $not_blank && $contains_chars } {
	set app_prog_set [split $name_group ":"]
	set trimapp_name [string trim [lindex $app_prog_set 0]]
	set prog_name [lindex $app_prog_set 1]
	set multiprog [regexp -nocase (,) $prog_name]
	if { $multiprog } {
	    set progs [split $prog_name ","]
	    foreach prog $progs {
		set namepair {}
		set contains_chars [regexp -nocase {[0-9a-z]+} $prog]
		if { $contains_chars } {
		    set trimprog_name [string trim $prog]
		    lappend namepair $trimapp_name $trimprog_name
		    lappend masterlist $namepair
		}
	    }
	} else {
	    set contains_chars [regexp -nocase {[0-9a-z]+} $prog_name]
	    if { $contains_chars } {
		set trimprog_name [string trim $prog_name]
		lappend namepair $trimapp_name $trimprog_name
		lappend masterlist $namepair
	    }
	}
    }
}

# Change PLSQL to fit the filtered query
set from_clause {
from fnd_concurrent_requests fcr,
     fnd_concurrent_programs_tl fcpt,
     fnd_application_tl fat }
set where_clause_W {
where fcr.status_code = 'G' AND }

set where_clause_C {
where fcr.phase_code = 'C' AND }


# Set for specific progs/inclusion
    if { $fchoice == 2 } {
	set excl_oper ""
	set comb_oper " OR "
    }

set where_clause_EX " 
fcr.program_application_id = fat.application_id AND
fat.application_id = fcpt.application_id AND
fcr.concurrent_program_id = fcpt.concurrent_program_id AND 
fat.language = $langvar AND
fcpt.language = $langvar AND
( "

# Add on App Name and C Prog Name sql
set i 0
    foreach name_group $masterlist {
	if { $i } {
	    append where_clause_EX $comb_oper
	}
	incr i
	set app_name [lindex $name_group 0]
	set prog_name [lindex $name_group 1]
	    
		    append where_clause_EX "
$excl_oper (UPPER(fat.application_name) = UPPER(\'$app_name\') AND
UPPER(fcpt.user_concurrent_program_name) = UPPER(\'$prog_name\')) "

    }

append where_clause_W "$where_clause_EX );"
append where_clause_C "$where_clause_EX );"
}

   # Compute the Percentage of Concurrent requests
   # in the Erroroneous state 
set plsqlblock { declare 
requests_in_warning number ;
total_requests    number ;
begin
/* OracleOEM */
select  count(*)
into    requests_in_warning }
append plsqlblock $from_clause
append plsqlblock $where_clause_W

append plsqlblock {

/* OracleOEM */
select	count(*)
into	total_requests }
append plsqlblock $from_clause
append plsqlblock $where_clause_C

append plsqlblock {
if (total_requests != 0) then 
:reqwarnings_pct := requests_in_warning * 100 /total_requests;
else
:reqwarnings_pct := 0 ;
end if ;
end ;
}

#ORATCL_DEBUG "reqwarnsn: SQL: $plsqlblock"

# initialize the return code
set ret_code $CLEAR_EVENT

# The main event checking function
if {[catch {oraplexec $cur $plsqlblock :reqwarnings_pct "" } retlist]} {
    ORATCL_DEBUG "reqwarnsn : [oratime] plsql failed "
    ORATCL_DEBUG "errortxt $oramsg(errortxt)"
    ORATCL_DEBUG "ocifunc $oramsg(ocifunc)"
    ORATCL_DEBUG "sqlfunc $oramsg(sqlfunc)"
    ORATCL_DEBUG " return code:  $oramsg(rc) "
    ORATCL_DEBUG " return value is: $retlist"
    
    # Close the cursor and logoff
# If fail, cursor comes back closed: Bug#1093413
#    oraclose $cur
    oralogoff $lda
    
    set output [format [msgtxt [NETWORK] smamp 6002] "reqwarnsn"]
    set output [convertout $oramsg(agent_characterset) $output]
    
    if {$last_report == $SCRIPT_FAIL} {
        return $NO_EVENT
    } else {
        set last_report $SCRIPT_FAIL
        return $SCRIPT_FAIL
    }
}

# happy with value ? 
set curr_value [lindex $retlist 0]
ORATCL_DEBUG "reqwarnsn : [oratime] reqwarnsn pct is: $curr_value %"
if { $curr_value > $alert_threshold } {
    set output $curr_value 
    lappend output "alert"
    lappend output $alert_threshold
    set ret_code $ALERT_EVENT
} elseif {$curr_value > $warning_threshold } {
    set output $curr_value 
    lappend output "warning"
    lappend output $warning_threshold
    set ret_code $WARNING_EVENT 
}

# Close the cursor and log off
oraclose $cur
oralogoff $lda

# return
if {$last_report == $ret_code} {
    return $NO_EVENT
} else {
    ORATCL_DEBUG "reqwarnsn: $oramsg(oraobject) : [oratime] : $ret_code"
    set last_report $ret_code
    return $ret_code
}
}
