###############################################################################
# $Header: updownn.tcl 30-nov-2005.05:44:52 mkiran Exp $
#
# Copyright (c) 1995, 2005, Oracle. All rights reserved.  
#
# NAME:
#
#  updownn.tcl : Event script to check status of concurrent manager
#
# ARGUMENTS:
#  
#           argv(0) == db username
#           argv(1) == db passwd
#           argv(2) == db connect string or alias
#	    argv(3) == Placeholder
#  
# $Log:  $
#         mkiran   11/12/2005 - bug4557548: Comment last_report init setting
#         vtummala 08/02/1999
#
#
###############################################################################

# Event definition
oradefine event /oracle/cmanager/fault/updownn 
oraarguments cmuser cmpasswd cmconstr phold
oravardesc cmuser string
oravardesc cmpasswd string
oravardesc cmconstr string
oravardesc phold string
oradefine end

# The output variable is always needed, by the agent 
# in it's current state - 01/18/99
set output " "

# bug4557548: CLEAR_EVENT setting for last_report will not give expected
# event evaluation results for all combinations of Agent and cmanager target
# bounces. So, comment this setting.
#set last_report $CLEAR_EVENT

proc EvalEvent {} {
    
# Global Declarations 
global SCRIPT_FAIL CLEAR_EVENT NO_EVENT WARNING_EVENT ALERT_EVENT
global argv oramsg 
global last_report 
global output 
global cur

# build connect string
set user    [lindex $argv 0];
set pwd     [lindex $argv 1];
set constr  [lindex $argv 2];
set alias   $oramsg(oraobject)
set connect "$user/$pwd@$constr"

# don't put passwords in trace file
set logconnect "$user/<PASSWORD>@$constr"

# Need to define messages to display logon or tns alias problems
# if we can't connect to the database, ICM is probably down,
# but since this could be just that our connect string is bad
# we return SCRIPT_FAIL
# here in the preamble, we shouldn't ever actually find last_report as
# SCRIPT_FAIL, but I'm leaving the test in case things get moved around
if {[catch {oralogon $connect} lda]} {
    ORATCL_DEBUG "cmupdownn : [oratime] logon failed to $logconnect"
    ORATCL_DEBUG "errortxt $oramsg(errortxt)"
    ORATCL_DEBUG "ocifunc $oramsg(ocifunc)"
    ORATCL_DEBUG "sqlfunc $oramsg(sqlfunc)"
    ORATCL_DEBUG "return code:  $oramsg(rc) "
    if {$last_report == $SCRIPT_FAIL} {
	return $NO_EVENT
    } else {
	set last_report $SCRIPT_FAIL
	set output [format [msgtxt [NETWORK] smamp 6000] "cmupdownn"]
	set output [convertout $oramsg(agent_characterset) $output]
	return $SCRIPT_FAIL
    } 
}
ORATCL_DEBUG "cmupdownn : [oratime] logon success using $logconnect" 

# open cursor
if {[catch {oraopen $lda} cur]} {
    ORATCL_DEBUG "cmupdownn : [oratime] failed to open cursor"
    ORATCL_DEBUG "errortxt $oramsg(errortxt)"
    ORATCL_DEBUG "ocifunc $oramsg(ocifunc)"
    ORATCL_DEBUG "sqlfunc $oramsg(sqlfunc)"
    ORATCL_DEBUG "return code:  $oramsg(rc) "
    set last_report $SCRIPT_FAIL
    set output [format [msgtxt [NETWORK] smamp 6001] "cmupdownn"]
    set output [convertout $oramsg(agent_characterset) $output]
    oralogoff $lda
    return $SCRIPT_FAIL
}
ORATCL_DEBUG "cmupdownn : [oratime] opened cursor" 

set plsqlblock {  declare 
target number; 
active number; 
pmon   varchar2(30); 
stat   number; 
begin 
fnd_concurrent.get_manager_status(targetp => target, 
activep => active, 
pmon_method => pmon, 
callstat => stat); 
if (stat = 0 and active > 0) then 
:isup := 'Y'; 
else  
:isup := 'N'; 
end if; 
end; 
}

# initialize the return code
set ret_code $CLEAR_EVENT

# The main event checking function
# get status of ICM. If we can log on, but not find the package
# or otherwise run it sucessfully, it is probably script failure
# but we'll trigger the event the first time through since the
# database is probably hosed to the point that CM is effectively
# down.
if {[catch {oraplexec $cur $plsqlblock :isup "" } retlist]} {
    ORATCL_DEBUG "cmupdownn : [oratime] plsql failed "
    ORATCL_DEBUG "errortxt $oramsg(errortxt)"
    ORATCL_DEBUG "ocifunc $oramsg(ocifunc)"
    ORATCL_DEBUG "sqlfunc $oramsg(sqlfunc)"
    ORATCL_DEBUG " return code:  $oramsg(rc) "
    ORATCL_DEBUG " return value is: $retlist"
    
    # Close the cursor and logoff
# If fail, cursor comes back closed: Bug#1093413
#    oraclose $cur
    oralogoff $lda
    
    set output [format [msgtxt [NETWORK] smamp 6002] "updownn.tcl"]
    set output [convertout $oramsg(agent_characterset) $output]
    
    if {$last_report == $SCRIPT_FAIL} {
	return $NO_EVENT
    } else {
	set last_report $SCRIPT_FAIL
	return $SCRIPT_FAIL
    } 
}

# happy with value?
if { $retlist != "Y" } {
    set output $alias
    set output [convertout $oramsg(agent_characterset) $output]
    ORATCL_DEBUG "cmupdownn: $oramsg(oraobject) : [oratime] : output: $output" 
    set ret_code $ALERT_EVENT
} 

# Close the cursor and log off 
oraclose $cur
oralogoff $lda

# return
if {$last_report == $ret_code} {    
    return $NO_EVENT
} else {
    ORATCL_DEBUG "cmupdownn : $oramsg(oraobject) : [oratime] :  $ret_code"
    set last_report $ret_code
    return $ret_code 
}

}

