###############################################################################
# $Header: inactive.tcl 30-nov-2005.05:46:52 mkiran Exp $
#
# Copyright (c) 1995, 2005, Oracle. All rights reserved.  
#
# NAME:
#
#  inactive.tcl : Inactive request Pending  
#
# DESCRIPTION: 
# 
# This event will check to see if there are any inactive requests 
# pending in the Concurrent request queues.
#
# ARGUMENTS:
#
#           argv(0) == db username
#           argv(1) == db passwd
#
# $Log:  $
# This is part of the Application Management Pak - Advanced Events for
#                                                  Concurrent Manager
# mkiran   11/12/2005 - bug4557548: Comment last_report init setting
#
###############################################################################

# Event definition
oradefine event /oracle/cmanager/perf/inactive
oraarguments cmuser cmpasswd 
oravardesc cmuser string
oravardesc cmpasswd string
oradefine end

# The output variable is always needed, by the agent
# in it's current state - 01/18/99
set output " "

# bug4557548: CLEAR_EVENT setting for last_report will not give expected
# event evaluation results for all combinations of Agent and cmanager target
# bounces. So, comment this setting.
#set last_report $CLEAR_EVENT

proc EvalEvent {} {
    
# Global Declarations
global SCRIPT_FAIL CLEAR_EVENT NO_EVENT WARNING_EVENT ALERT_EVENT
global argv oramsg
global last_report
global output
global cur

# build connect string
set user [lindex $argv 0];
set pwd  [lindex $argv 1];
set alias   $oramsg(oraobject)
set connect "$user/$pwd@$alias"

# don't put passwords in trace file
set logconnect "$user/<PASSWORD>@$alias"

# if we can't connect to the database, ICM is probably down,
# but since this could be just that our connect string is bad
# we return SCRIPT_FAIL
if {[catch {oralogon $connect} lda]} {
    ORATCL_DEBUG "inactive : [oratime] logon failed to $logconnect"
    ORATCL_DEBUG "errortxt $oramsg(errortxt)"
    ORATCL_DEBUG "ocifunc $oramsg(ocifunc)"
    ORATCL_DEBUG "sqlfunc $oramsg(sqlfunc)"
    ORATCL_DEBUG "return code:  $oramsg(rc) "
    if {$last_report == $SCRIPT_FAIL} {
        return $NO_EVENT
    } else {
        set last_report $SCRIPT_FAIL
        set output [format [msgtxt [NETWORK] smamp 6000] "inactive"]
	set output [convertout $oramsg(agent_characterset) $output]
        return $SCRIPT_FAIL
    }
}
ORATCL_DEBUG "inactive : [oratime] logon success using $logconnect"

# open cursor
if {[catch {oraopen $lda} cur]} {
    ORATCL_DEBUG "inactive : [oratime] failed to open cursor"
    ORATCL_DEBUG "errortxt $oramsg(errortxt)"
    ORATCL_DEBUG "ocifunc $oramsg(ocifunc)"
    ORATCL_DEBUG "sqlfunc $oramsg(sqlfunc)"
    ORATCL_DEBUG "return code:  $oramsg(rc) "
    set last_report $SCRIPT_FAIL
    set output [format [msgtxt [NETWORK] smamp 6001] "inactive"]
    set output [convertout $oramsg(agent_characterset) $output]
    oralogoff $lda
    return $SCRIPT_FAIL
}
ORATCL_DEBUG "inactive : [oratime] opened cursor"

# Look at the fnd_concurrent_requests table to find the count 
# of the concurrent_requests which are inactive. 
set plsqlblock { declare
begin
/* OracleOEM */
select  count(*)
into    :invalid_request_count 
from 	fnd_concurrent_requests r
where	status_code in ('I', 'Q')
	and hold_flag != 'Y'  
	and requested_start_date <= SYSDATE
	and request_id not in 
			(select distinct request_id 
	 		from   fnd_concurrent_worker_requests 
                        where status_code in ('I', 'Q')
	 		and hold_flag != 'Y'
	 		and requested_start_date <= SYSDATE
	 		and not (concurrent_queue_id in (1,4) and
		  	queue_application_id = 0) and 
	 		max_processes > 0 );
end ;
}

# initialize the return code
set ret_code $CLEAR_EVENT

# The main event checking function
if {[catch {oraplexec $cur $plsqlblock :invalid_request_count "" } retlist]} {
    ORATCL_DEBUG "inactive : [oratime] plsql failed "
    ORATCL_DEBUG "errortxt $oramsg(errortxt)"
    ORATCL_DEBUG "ocifunc $oramsg(ocifunc)"
    ORATCL_DEBUG "sqlfunc $oramsg(sqlfunc)"
    ORATCL_DEBUG " return code:  $oramsg(rc) "
    ORATCL_DEBUG " return value is: $retlist"
    
    # Close the cursor and logoff
#    oraclose $cur
    oralogoff $lda
    
    set output [format [msgtxt [NETWORK] smamp 6002] "inactive.tcl"]
    set output [convertout $oramsg(agent_characterset) $output]
    if {$last_report == $SCRIPT_FAIL} {
        return $NO_EVENT
    } else {
        set last_report $SCRIPT_FAIL
        return $SCRIPT_FAIL
    }
}
# happy with value?
set curr_value [lindex $retlist 0]
ORATCL_DEBUG "inactive: curr_value $curr_value" 
if { $curr_value > 0 } {
    set output $curr_value
    set ret_code $ALERT_EVENT
}

# Close the cursor and log off
oraclose $cur
oralogoff $lda

# return
if {$last_report == $ret_code} {
    return $NO_EVENT
} else {
    ORATCL_DEBUG "inactive : $oramsg(oraobject) : [oratime] :  $ret_code"
    set last_report $ret_code
    return $ret_code
}
}

