###############################################################################
# $Header: inactiven.tcl 30-nov-2005.05:48:08 mkiran Exp $
#
# Copyright (c) 1995, 2005, Oracle. All rights reserved.  
#
# NAME:
#
#  inactiven.tcl : Inactive request Pending  
#
# DESCRIPTION: 
# 
# This event will check to see if there are any inactiven requests 
# pending in the Concurrent request queues.
#
# ARGUMENTS:
#
#           argv(0) == db username
#           argv(1) == db passwd
#           argv(2) == db connect string or alias
#	    argv(3) == Inclusion/Exclusion Indicator
#	    argv(4) == Program list
#	    argv(5) == Placeholder
#
# $Log:  $
# This is part of the Application Management Pak - Advanced Events for
#                                                  Concurrent Manager
# mkiran   11/12/2005 - bug4557548: Comment last_report init setting
#
###############################################################################

# Event definition
oradefine event /oracle/cmanager/perf/inactiven
oraarguments cmuser cmpasswd cmconstr filterchoice filterlist phold
oravardesc cmuser string
oravardesc cmpasswd string
oravardesc cmconstr string
oravardesc filterchoice int
oravardesc filterlist string
oravardesc phold string
oradefine end

# The output variable is always needed, by the agent
# in it's current state - 01/18/99
set output " "

# bug4557548: CLEAR_EVENT setting for last_report will not give expected
# event evaluation results for all combinations of Agent and cmanager target
# bounces. So, comment this setting.
#set last_report $CLEAR_EVENT

proc EvalEvent {} {
    
# Global Declarations
global SCRIPT_FAIL CLEAR_EVENT NO_EVENT WARNING_EVENT ALERT_EVENT
global argv oramsg
global last_report
global output
global cur
global where_clause where_clause_EX
global from_clause excl_oper comb_oper masterlist

# build connect string
set user [lindex $argv 0];
set pwd  [lindex $argv 1];
set constr  [lindex $argv 2];
set alias   $oramsg(oraobject)
set connect "$user/$pwd@$constr"

# don't put passwords in trace file
set logconnect "$user/<PASSWORD>@$constr"

# get filter inputs
set fchoice [lindex $argv 3];
set flist [lindex $argv 4];

# if we can't connect to the database, ICM is probably down,
# but since this could be just that our connect string is bad
# we return SCRIPT_FAIL
if {[catch {oralogon $connect} lda]} {
    ORATCL_DEBUG "inactiven : [oratime] logon failed to $logconnect"
    ORATCL_DEBUG "errortxt $oramsg(errortxt)"
    ORATCL_DEBUG "ocifunc $oramsg(ocifunc)"
    ORATCL_DEBUG "sqlfunc $oramsg(sqlfunc)"
    ORATCL_DEBUG "return code:  $oramsg(rc) "
    if {$last_report == $SCRIPT_FAIL} {
        return $NO_EVENT
    } else {
        set last_report $SCRIPT_FAIL
        set output [format [msgtxt [NETWORK] smamp 6000] "inactiven"]
	set output [convertout $oramsg(agent_characterset) $output]
        return $SCRIPT_FAIL
    }
}
ORATCL_DEBUG "inactiven : [oratime] logon success using $logconnect"

# open cursor
if {[catch {oraopen $lda} cur]} {
    ORATCL_DEBUG "inactiven : [oratime] failed to open cursor"
    ORATCL_DEBUG "errortxt $oramsg(errortxt)"
    ORATCL_DEBUG "ocifunc $oramsg(ocifunc)"
    ORATCL_DEBUG "sqlfunc $oramsg(sqlfunc)"
    ORATCL_DEBUG "return code:  $oramsg(rc) "
    set last_report $SCRIPT_FAIL
    set output [format [msgtxt [NETWORK] smamp 6001] "inactiven"]
    set output [convertout $oramsg(agent_characterset) $output]
    oralogoff $lda
    return $SCRIPT_FAIL
}
ORATCL_DEBUG "inactiven : [oratime] opened cursor"

###############
# Determine the language variable
###############
# Defaults to Apps 11 format
set langvar {userenv('LANG')}

# Query Instance for version number to change langvar
set plsqlblockLANG { declare 
apps_version varchar2(30) ;
begin
/* OracleOEM */
select  product_version
into    :appver
from fnd_product_installations
where application_id = 0;
end;
}

if {[catch {oraplexec $cur $plsqlblockLANG :appver "" } retlist]} {
    ORATCL_DEBUG "inactiven : [oratime] plsql failed "
    ORATCL_DEBUG "errortxt $oramsg(errortxt)"
    ORATCL_DEBUG "ocifunc $oramsg(ocifunc)"
    ORATCL_DEBUG "sqlfunc $oramsg(sqlfunc)"
    ORATCL_DEBUG " return code:  $oramsg(rc) "
    ORATCL_DEBUG " return value is: $retlist"
    
    # Close the cursor and logoff
# If fail, cursor comes back closed: Bug#1093413
#    oraclose $cur
    oralogoff $lda
    
    set output [format [msgtxt [NETWORK] smamp 6002] "inactiven.tcl"] 
    set output [convertout $oramsg(agent_characterset) $output]
    if {$last_report == $SCRIPT_FAIL} {
        return $NO_EVENT
    } else {
        set last_report $SCRIPT_FAIL
        return $SCRIPT_FAIL
    }
}

set apps_ver [lindex $retlist 0]
ORATCL_DEBUG "inactiven: [oratime] apps version number is : $apps_ver " 

set isapps107 [regexp {6\.1\.} $apps_ver]
if { $isapps107 } {
    set langvar {substr(userenv('LANGUAGE'), 1, instr(userenv('LANGUAGE'), '_') -1)}
}
############
# Default SQL Query components
########
set where_clause " where fcr.status_code in ('I', 'Q') and 
fcr.hold_flag != 'Y' and 
fcr.requested_start_date <= SYSDATE and 
(fcr.request_id not in (select distinct request_id from fnd_concurrent_worker_requests where  status_code in ('I', 'Q') and hold_flag != 'Y' and requested_start_date <= SYSDATE and not (concurrent_queue_id in (1,4) and queue_application_id = 0) and max_processes > 0 )) AND 
fcr.program_application_id = fat.application_id AND 
fat.application_id = fcpt.application_id AND 
fcr.concurrent_program_id = fcpt.concurrent_program_id AND 
fat.language = $langvar AND 
fcpt.language = $langvar "

set from_clause { from fnd_concurrent_requests fcr, fnd_concurrent_programs_tl fcpt, fnd_application_tl fat }

set select_clause { /* OracleOEM */ select fcr.request_id, fcr.requested_by, fat.application_name, fcpt.user_concurrent_program_name, (SYSDATE - fcr.requested_start_date)*24 }
# gives number of hours

# Defaults to exclusion of items in filter list
set excl_oper " NOT "
set comb_oper " AND "

set masterlist {}
if { $fchoice != 0 } {    

    # Builds the list: trims trailing and preceding whitespaces
    #     accepts comma delimited program name entries
set filter_list [split $flist "|"]
foreach name_group $filter_list {
    set namepair {}
    set not_blank [regexp (:) $name_group]
    set contains_chars [regexp -nocase {[0-9a-z]+} $name_group]
    if { $not_blank && $contains_chars } {
	set app_prog_set [split $name_group ":"]
	set trimapp_name [string trim [lindex $app_prog_set 0]]
	set prog_name [lindex $app_prog_set 1]
	set multiprog [regexp -nocase (,) $prog_name]
	if { $multiprog } {
	    set progs [split $prog_name ","]
	    foreach prog $progs {
		set namepair {}
		set contains_chars [regexp -nocase {[0-9a-z]+} $prog]
		if { $contains_chars } {
		    set trimprog_name [string trim $prog]
		    lappend namepair $trimapp_name $trimprog_name
		    lappend masterlist $namepair
		}
	    }
	} else {
	    set contains_chars [regexp -nocase {[0-9a-z]+} $prog_name]
	    if { $contains_chars } {
		set trimprog_name [string trim $prog_name]
		lappend namepair $trimapp_name $trimprog_name
		lappend masterlist $namepair
	    }
	}
    }
}

    # Change PLSQL to fit the filtered query
    set where_clause_EX " AND ( "
    
    # Set for specific progs/inclusion
    if { $fchoice == 2 } {
	set excl_oper ""
	set comb_oper " OR "
    }
    
    # Add on App Name and C Prog Name sql
    set i 0
    foreach name_group $masterlist {
	if { $i } {
	    append where_clause_EX $comb_oper
	}
	incr i
	set app_name [lindex $name_group 0]
	set prog_name [lindex $name_group 1]
	
	append where_clause_EX " 
$excl_oper (UPPER(fat.application_name) = UPPER(\'$app_name\') AND 
UPPER(fcpt.user_concurrent_program_name) = UPPER(\'$prog_name\')) "
    }    
    append where_clause "$where_clause_EX )"
}

# Look at the fnd_concurrent_requests table to find 
# the concurrent requests which are inactive. 

set sqlblock $select_clause
append sqlblock $from_clause
append sqlblock "$where_clause"

ORATCL_DEBUG "inactiven: SQL: $sqlblock"
# initialize the return code
set ret_code $CLEAR_EVENT

# The main event checking function
if {[catch {orasql $cur $sqlblock } retlist]} {
    ORATCL_DEBUG "inactiven : [oratime] sql failed "
    ORATCL_DEBUG "errortxt $oramsg(errortxt)"
    ORATCL_DEBUG "ocifunc $oramsg(ocifunc)"
    ORATCL_DEBUG "sqlfunc $oramsg(sqlfunc)"
    ORATCL_DEBUG " return code:  $oramsg(rc) "
    ORATCL_DEBUG " return value is: $retlist"
    
    # Close the cursor and logoff
# If fail, cursor comes back closed: Bug#1093413
#    oraclose $cur
    oralogoff $lda
    
    set output [format [msgtxt [NETWORK] smamp 6002] "inactiven.tcl"]
    set output [convertout $oramsg(agent_characterset) $output]
    if {$last_report == $SCRIPT_FAIL} {
        return $NO_EVENT
    } else {
        set last_report $SCRIPT_FAIL
        return $SCRIPT_FAIL
    }
}

# happy with value?
if {[catch {set row [orafetch $cur]} err]} {
    ORATCL_DEBUG "inactiven: [oratime] fetch failed"
    oraclose $cur
    oralogoff $lda

    set output [format [msgtxt [NETWORK] smamp 6002] "inactiven.tcl"]
    set output [convertout $oramsg(agent_characterset) $output]
    if {$last_report == $SCRIPT_FAIL} {
        return $NO_EVENT
    } else {
        set last_report $SCRIPT_FAIL
        return $SCRIPT_FAIL
    } 
}

set reqlist {}
lappend lenlist 20 20 45 45 20
set reqlist_formatted [msgtxt [NETWORK] smamp 7001]
while {$row != ""} {
    lappend reqlist $row
    append reqlist_formatted "\n"
    
    for {set i 0} {$i < [llength $row]} {incr i} {
	set tmpvar [lindex $row $i]
	set proj_len [lindex $lenlist $i]
	set t_var $tmpvar
	if { $proj_len > [string length $tmpvar] } {
	    set spaces [expr $proj_len-[string length $tmpvar]]
	    for {set j 0} {$j<$spaces} {incr j} {
		append t_var " "
	    }
	}
	if {$proj_len < [string length $tmpvar]} {
	    set t_var [string range $tmpvar 0 [expr $proj_len-1]]
	}
	append reqlist_formatted "$t_var"
	ORATCL_DEBUG "inactiven: add to list: $t_var"
    }

    if {[catch {set row [orafetch $cur]} err]} {
	ORATCL_DEBUG "inactiven: [oratime] fetch failed"
	oraclose $cur
	oralogoff $lda
	
	set output [format [msgtxt [NETWORK] smamp 6002] "inactiven.tcl"]
	set output [convertout $oramsg(agent_characterset) $output]
	if {$last_report == $SCRIPT_FAIL} {
	    return $NO_EVENT
	} else {
	    set last_report $SCRIPT_FAIL
	    return $SCRIPT_FAIL
	} 
    }
}

if { [llength $reqlist] > 0 } {
    set output [llength $reqlist] 
    lappend output " $reqlist_formatted"
    set ret_code $ALERT_EVENT
}
ORATCL_DEBUG "inactivenn : [oratime] curr_value : [llength $reqlist]"

# Close the cursor and log off
oraclose $cur
oralogoff $lda

# return
if {$last_report == $ret_code} {
    return $NO_EVENT
} else {
    ORATCL_DEBUG "inactiven : $oramsg(oraobject) : [oratime] :  $ret_code"
    set last_report $ret_code
    return $ret_code
}
}

