###############################################################################
# $Header: pendingq.tcl 30-nov-2005.05:49:27 mkiran Exp $
#
# Copyright (c) 1995, 2005, Oracle. All rights reserved.  
#
# NAME:
#
#  pendingq.tcl : Pending Queue Backlog aka Pending Concurrent request Backlog
#
# ARGUMENTS:
#
#           argv(0) == db username
#           argv(1) == db passwd
#	    argv(2) == total jobs pending
#	    argv(3) == time threshold (hrs) for inclusion 
#
# $Log:  $
# This is part of the Application Management Pak - Advanced Events for
#                                                  Concurrent Manager
# mkiran   11/12/2005 - bug4557548: Comment last_report init setting
# vtummala 08/02/99
#
###############################################################################

# Event definition
oradefine event /oracle/cmanager/perf/pendingq
oraarguments cmuser cmpasswd total_jobs_pending time_threshold 
oravardesc cmuser string
oravardesc cmpasswd string
oravardesc total_jobs_pending int
oravardesc time_threshold int
oradefine end

# The output variable is always needed, by the agent
# in it's current state - 01/18/99
set output " "

# bug4557548: CLEAR_EVENT setting for last_report will not give expected
# event evaluation results for all combinations of Agent and cmanager target
# bounces. So, comment this setting.
#set last_report $CLEAR_EVENT

proc EvalEvent {} {

# Global Declarations
global SCRIPT_FAIL CLEAR_EVENT NO_EVENT WARNING_EVENT ALERT_EVENT
global argv oramsg
global last_report
global output
global cur

# build connect string
set user [lindex $argv 0];
set pwd  [lindex $argv 1];
set alias   $oramsg(oraobject)
set connect "$user/$pwd@$alias"

# don't put passwords in trace file
set logconnect "$user/<PASSWORD>@$alias"

# get the thresholds 
set total_jobs_pending   [lindex $argv 2];
set time_threshold [lindex $argv 3];

# if we can't connect to the database, ICM is probably down,
# but since this could be just that our connect string is bad
# we return SCRIPT_FAIL
if {[catch {oralogon $connect} lda]} {
    ORATCL_DEBUG "pendingq : [oratime] logon failed to $logconnect"
    ORATCL_DEBUG "errortxt $oramsg(errortxt)"
    ORATCL_DEBUG "ocifunc $oramsg(ocifunc)"
    ORATCL_DEBUG "sqlfunc $oramsg(sqlfunc)"
    ORATCL_DEBUG "return code:  $oramsg(rc) "
    if {$last_report == $SCRIPT_FAIL} {
        return $NO_EVENT
    } else {
        set last_report $SCRIPT_FAIL
	set output [format [msgtxt [NETWORK] smamp 6000] "pendingq"]
 	set output [convertout $oramsg(agent_characterset) $output]
        return $SCRIPT_FAIL
    }
}
ORATCL_DEBUG "pendingq : [oratime] logon success using $logconnect"

# open cursor
if {[catch {oraopen $lda} cur]} {
    ORATCL_DEBUG "pendingq : [oratime] failed to open cursor"
    ORATCL_DEBUG "errortxt $oramsg(errortxt)"
    ORATCL_DEBUG "ocifunc $oramsg(ocifunc)"
    ORATCL_DEBUG "sqlfunc $oramsg(sqlfunc)"
    ORATCL_DEBUG "return code:  $oramsg(rc) "
    set last_report $SCRIPT_FAIL
    set output [format [msgtxt [NETWORK] smamp 6001] "pendingq"]
    set output [convertout $oramsg(agent_characterset) $output]
    oralogoff $lda
    return $SCRIPT_FAIL
}
ORATCL_DEBUG "pendingq : [oratime] opened cursor"

# compute the jobs pending within the time threshold 
# that the user specifies   
set plsqlblock { declare 
begin
/* OracleOEM */
select  count(*)
into    :pending_job_count 
from 	fnd_concurrent_requests r
where   r.status_code in ('I', 'Q')
	and r.hold_flag != 'Y'  
        and (greatest(r.request_date , r.requested_start_date) <=
	(sysdate - :time_threshold/(24 * 60)) );
end ;
}

# initialize the return code
set ret_code $CLEAR_EVENT

# The main event checking function
if {[catch {oraplexec $cur $plsqlblock :time_threshold $time_threshold :pending_job_count "" } retlist]} {
    ORATCL_DEBUG "pendingq : [oratime] plsql failed "
    ORATCL_DEBUG "errortxt $oramsg(errortxt)"
    ORATCL_DEBUG "ocifunc $oramsg(ocifunc)"
    ORATCL_DEBUG "sqlfunc $oramsg(sqlfunc)"
    ORATCL_DEBUG " return code:  $oramsg(rc) "
    ORATCL_DEBUG " return value is: $retlist"
    
    # Close the cursor and logoff
#    oraclose $cur
    oralogoff $lda
    
    set output [format [msgtxt [NETWORK] smamp 6002] "pendingq.tcl"]
    set output [convertout $oramsg(agent_characterset) $output]
 
    if {$last_report == $SCRIPT_FAIL} {
        return $NO_EVENT
    } else {
        set last_report $SCRIPT_FAIL
        return $SCRIPT_FAIL
    }
}
# happy with value?
set pending_job_count [lindex $retlist 1]
ORATCL_DEBUG "pendingq : [oratime] Pending Job Count - $pending_job_count"
ORATCL_DEBUG "pendingq : [oratime] Time threshold: $time_threshold"
ORATCL_DEBUG "pendingq : [oratime] Total Jobs    : $total_jobs_pending"

if { $pending_job_count > $total_jobs_pending } {
    set output $pending_job_count 
    lappend output $time_threshold
    lappend output $total_jobs_pending
    set ret_code $ALERT_EVENT
}

# Close the cursor and log off
oraclose $cur
oralogoff $lda

# return
if {$last_report == $ret_code} {
    return $NO_EVENT
} else {
    ORATCL_DEBUG "pendingq : $oramsg(oraobject) : [oratime] :  $ret_code"
    set last_report $ret_code
    return $ret_code
}
}
