###############################################################################
# $Header: reqpending.tcl 30-nov-2005.05:51:24 mkiran Exp $
#
# Copyright (c) 1995, 2005, Oracle. All rights reserved.  
#
# NAME:
#
#  reqpending.tcl : Requests Pending  
#
# ARGUMENTS:
#
#           argv(0) == db username
#           argv(1) == db passwd
#	    argv(2) == hours pending
#	    argv(3) == minutes pending
#
# $Log:  $
# This is part of the Application Management Pak - Advanced Events for
#                                                  Concurrent Manager
# mkiran   11/12/2005 - bug4557548: Comment last_report init setting
# vtummala 08/02/99
#
###############################################################################

# Event definition
oradefine event /oracle/cmanager/perf/reqpending
oraarguments cmuser cmpasswd hours minutes 
oravardesc cmuser string
oravardesc cmpasswd string
oravardesc hours int
oravardesc minutes int
oradefine end

# The output variable is always needed, by the agent
# in it's current state - 01/18/99
set output " "

# bug4557548: CLEAR_EVENT setting for last_report will not give expected
# event evaluation results for all combinations of Agent and cmanager target
# bounces. So, comment this setting.
#set last_report $CLEAR_EVENT

proc EvalEvent {} {
    
# Global Declarations
global SCRIPT_FAIL CLEAR_EVENT NO_EVENT WARNING_EVENT ALERT_EVENT
global argv oramsg
global last_report
global output
global cur

# build connect string
set user [lindex $argv 0];
set pwd  [lindex $argv 1];
set alias   $oramsg(oraobject)
set connect "$user/$pwd@$alias"

# don't put passwords in trace file
set logconnect "$user/<PASSWORD>@$alias"

# get the thresholds 
set hours   [lindex $argv 2];
set minutes [lindex $argv 3];

# if we can't connect to the database, ICM is probably down,
# but since this could be just that our connect string is bad
# we return SCRIPT_FAIL
if {[catch {oralogon $connect} lda]} {
    ORATCL_DEBUG "reqpending : [oratime] logon failed to $logconnect"
    ORATCL_DEBUG "errortxt $oramsg(errortxt)"
    ORATCL_DEBUG "ocifunc $oramsg(ocifunc)"
    ORATCL_DEBUG "sqlfunc $oramsg(sqlfunc)"
    ORATCL_DEBUG "return code:  $oramsg(rc) "
    if {$last_report == $SCRIPT_FAIL} {
        return $NO_EVENT
    } else {
        set last_report $SCRIPT_FAIL
	set output [format [msgtxt [NETWORK] smamp 6000] "reqpending"]
 	set output [convertout $oramsg(agent_characterset) $output]
        return $SCRIPT_FAIL
    }
}
ORATCL_DEBUG "reqpending : [oratime] logon success using $logconnect"

# open cursor
if {[catch {oraopen $lda} cur]} {
    ORATCL_DEBUG "reqpending : [oratime] failed to open cursor"
    ORATCL_DEBUG "errortxt $oramsg(errortxt)"
    ORATCL_DEBUG "ocifunc $oramsg(ocifunc)"
    ORATCL_DEBUG "sqlfunc $oramsg(sqlfunc)"
    ORATCL_DEBUG "return code:  $oramsg(rc) "
    set last_report $SCRIPT_FAIL
    set output [format [msgtxt [NETWORK] smamp 6001] "reqpending"]
    set output [convertout $oramsg(agent_characterset) $output]
    oralogoff $lda
    return $SCRIPT_FAIL
}
ORATCL_DEBUG "reqpending : [oratime] opened cursor"

#Compute the number of requests which have been pending 
#for a period of time longer than fenced  
set plsqlblock { declare 
begin
/* OracleOEM */
select  count(*)
into    :pending_request_count 
from    fnd_concurrent_requests r
where   r.status_code in ('I', 'Q') and r.hold_flag != 'Y' 
        and (greatest(r.request_date , r.requested_start_date) < 
        sysdate - ( :hours_waited/24 + :minutes_waited/1440)) ;
end ;
}

# initialize the return code
set ret_code $CLEAR_EVENT

# The main event checking function
if {[catch {oraplexec $cur $plsqlblock :hours_waited $hours :minutes_waited $minutes :pending_request_count "" } retlist]} {
    ORATCL_DEBUG "reqpending : [oratime] plsql failed "
    ORATCL_DEBUG "errortxt $oramsg(errortxt)"
    ORATCL_DEBUG "ocifunc $oramsg(ocifunc)"
    ORATCL_DEBUG "sqlfunc $oramsg(sqlfunc)"
    ORATCL_DEBUG " return code:  $oramsg(rc) "
    ORATCL_DEBUG " return value is: $retlist"
    
    # Close the cursor and logoff
#    oraclose $cur
    oralogoff $lda
    
    set output [format [msgtxt [NETWORK] smamp 6002] "reqpending"]
    set output [convertout $oramsg(agent_characterset) $output]
    
    if {$last_report == $SCRIPT_FAIL} {
        return $NO_EVENT
    } else {
        set last_report $SCRIPT_FAIL
        return $SCRIPT_FAIL
    }
}

# happy with value?
set curr_value [lindex $retlist 2]
ORATCL_DEBUG "pending requests count exceeding threshold: $curr_value" 
if { $curr_value > 0 } {
    set output $curr_value
    lappend output $hours
    lappend output $minutes
    # BugNo:825976 To return Warning Event instead of Alert Event 
    set ret_code $WARNING_EVENT
}

# Close the cursor and log off
oraclose $cur
oralogoff $lda

# return
if {$last_report == $ret_code} {
    return $NO_EVENT
} else {
    ORATCL_DEBUG "reqpending : $oramsg(oraobject) : [oratime] :  $ret_code"
    set last_report $ret_code
    return $ret_code
}
}

