##############################################################################
#
# $Header: startup.tcl 09-apr-01.17:10:11 rzkrishn Exp $
# copyright (c) 1995, 1998 by the Oracle Corporation
#
# NAME:
#  startup.tcl : Script to startup internal concurrent manager
#
#      parses services.ora to find name of NT service to start.
#
#                            ---NT version---
#
# ARGUMENTS:
#  
#           argv(0) == database user
#           argv(1) == database password
#           argv(2) == database connect string or alias
#           argv(3) == gateway userid
#           argv(4) == apps user
#           argv(5) == apps password
#           argv(6) == Queue Size
#           argv(7) == Sleep Time
#           argv(8) == Pmon
#           argv(9) == Restart Flag
#           argv(10) == Diag Flag
#  
# $Log:  $
# vtummala 08/03/99 
##############################################################################

# Job definition
oradefine job /oracle/cmanager/general/startup 
oraarguments dbu dbp dbc gwyuid appsu appsp queues sleept pmon restartf diagf
oravardesc dbu	    string
oravardesc dbp      string
oravardesc dbc      string
oravardesc gwyuid   string
oravardesc appsu    string
oravardesc appsp    string
oravardesc queues   int
oravardesc sleept   int
oravardesc pmon     int
oravardesc restartf string
oravardesc diagf    string
oradefine end

global argv oramsg

set user    [lindex $argv 0];
set pwd     [lindex $argv 1];
set constr  [lindex $argv 2];
set alias   $oramsg(oraobject)
set appsuser [lindex $argv 4];
set connect "$user/$pwd@$constr"
set logconnect $user/<PASSWORD>@$constr
set delay   45

set cmstartargs ""
set sleeptime [lindex $argv 7];
append cmstartargs "sleep=$sleeptime "

# For some reason we made the restart a boolean, so we need to default the time
set restartflag [lindex $argv 9];
set rstart "N"
if { $restartflag == "true" } {
   set rstart "5" 
}
append cmstartargs "restart=$rstart "

set pmon [lindex $argv 8];
append cmstartargs "pmon=$pmon "

set queuesize [lindex $argv 6];
append cmstartargs "quesiz=$queuesize "

set diagflag [lindex $argv 10];
set diag "N"
if { $diagflag == "true" } {
   set diag "Y" 
}
append cmstartargs "diag=$diag "


# don't trace passwords
# ORATCL_DEBUG "cmstartup [oratime] appsuser $appsuser, using $logconnect"

# we'll look in services.ora for target service name in NT services
set servfname services.ora

# target name, to match in parsing services.ora
set targname $oramsg(oraobject)

# discovery file disappeared ?!?
if {! [file exists $servfname]} {
	# ORATCL_DEBUG "aborting cmstartup: file $servfname not found
	set output [format [msgtxt [NETWORK] smamp 8001] $servfname ]
	set output [convertout $oramsg(agent_characterset) $output]
	orafail $output
}

# discovery file not readable??
if { [catch {open $servfname r} servfile] } {
    # ORATCL_DEBUG "aborting cmstartup: file $servfname not readable"
	set output [format [msgtxt [NETWORK] smamp 8002] $servfname ]
	set output [convertout $oramsg(agent_characterset) $output]
	orafail $output
}

# input file is line oriented
set found "false"
while {[gets $servfile line] >= 0} {
    
    # clean out variables so they don't carry data from previous pass
    set myname ""
    set myf2 ""
    set myf3 ""
    set myf4 ""
    set myf5 ""
    
    # grab tokens from line
    set fcnt [scan $line "%s = (%s %s %s %s)" myname myf2 myf3 myf4 myf5]
    
    # skip blank lines
    if {$fcnt == 0} {
	continue;
    }
    
    #match target type, else continue looking 
    #BugNo:887786 
    set target_type_len [string length $myf2 ]
    set target_type     [string range $myf2 0 [expr $target_type_len-2]]
    if {($target_type != "oracle_sysman_cmanager")} {
	continue;
    }

    # match target name, else continue looking
    if {($myname != $targname)} {
	continue;
    }
    set found "true"
    close $servfile
    
    # strip bogus characters from fields
    set IcmNameLen [string length $myf5 ]
    set ICMname [string range $myf5 0 [expr $IcmNameLen-2]]
    # ORATCL_DEBUG "cmstartup: [oratime] will run net start $ICMname"
    
    if { [catch { exec net start $ICMname} outx ] } {
 	# Will need to try again after a fixed interval of time
	# The  delay has to be adjusted
	# ORATCL_DEBUG "Sleeping for : $delay"  
	orasleep $delay 
	if { [catch { exec net start $ICMname} outx ] } {
  	set output [format [msgtxt [NETWORK] smamp 8025] $outx  ]
	set output [convertout $oramsg(agent_characterset) $output]
	orafail $output
	}
    }
  	set  output [format [msgtxt [NETWORK] smamp 8026] $outx  ]
	set output [convertout $oramsg(agent_characterset) $output]
	puts $output
    return
}
# end of while loop, parsing input file

# another "impossible" error: couldn't find target in services.ora
if { $found == "false" } {
    close $servfile;
	set output [format [msgtxt [NETWORK] smamp 8006] $targname 'cmanager' $servfname ]
	set output [convertout $oramsg(agent_characterset) $output]
	orafail $output
}

