##############################################################################
#
# $Header: startupn.tcl 23-jun-2004.11:40:13 xxu Exp $
# Copyright (c) 1995, 2004, Oracle. All rights reserved.  
#
# NAME:
#  startup.tcl : Script to startup internal concurrent manager
#
#      parses services.ora to find name of NT service to start.
#
#                            ---NT version---
#
# ARGUMENTS:
#  
#           argv(0) == database user
#           argv(1) == database password
#           argv(2) == database connect string or alias
#           argv(3) == gateway userid
#           argv(4) == apps user
#           argv(5) == apps password
#           argv(6) == Queue Size
#           argv(7) == Sleep Time
#           argv(8) == Pmon
#           argv(9) == Restart Flag
#           argv(10) == Diag Flag
#           argv(11) == Placeholder
#  
# $Log:  $
# vtummala 08/03/99 
##############################################################################

# Job definition
oradefine job /oracle/cmanager/general/startupn 
oraarguments dbu dbp dbc gwyuid appsu appsp queues sleept pmon restartf diagf phold
oravardesc dbu	    string
oravardesc dbp      string
oravardesc dbc      string
oravardesc gwyuid   string
oravardesc appsu    string
oravardesc appsp    string
oravardesc queues   int
oravardesc sleept   int
oravardesc pmon     int
oravardesc restartf string
oravardesc diagf    string
oravardesc phold    string
oradefine end

global argv oramsg

set user    [lindex $argv 0];
set pwd     [lindex $argv 1];
set constr  [lindex $argv 2];
set alias   $oramsg(oraobject)
set appsuser [lindex $argv 4];
set connect "$user/$pwd@$constr"
set logconnect $user/<PASSWORD>@$constr
set delay   45

set sleeptime1 [lindex $argv 7];
set sleeptime [string trim $sleeptime1];

set restartflag1 [lindex $argv 9];
set restartflag [string trim $restartflag1];
set rstart "0"

#load registry package 
package ifneeded registry 1.1 [list load tclreg11.dll registry]
package require registry

if { [regexp {true} $restartflag] } {
   set rstart "1" 
}

set pmon1 [lindex $argv 8];
set pmon [string trim $pmon1];

set queuesize1 [lindex $argv 6];
set queuesize [string trim $queuesize1];

set diagflag [lindex $argv 10];
set diag "0"
if { [regexp {true} $diagflag] } {
   set diag "1" 
}

# don't trace passwords
 ORATCL_DEBUG "cmstartupn [oratime] appsuser $appsuser, using $logconnect"

# we'll look in services.ora for target service name in NT services
set servfname services.ora

# target name, to match in parsing services.ora
set targname $oramsg(oraobject)

# discovery file disappeared ?!?
if {! [file exists $servfname]} {
	# ORATCL_DEBUG "aborting cmstartup: file $servfname not found
	set output [format [msgtxt [NETWORK] smamp 8001] $servfname ]
	set output [convertout $oramsg(agent_characterset) $output]
	orafail $output
}

# discovery file not readable??
if { [catch {open $servfname r} servfile] } {
    # ORATCL_DEBUG "aborting cmstartup: file $servfname not readable"
	set output [format [msgtxt [NETWORK] smamp 8002] $servfname ]
	set output [convertout $oramsg(agent_characterset) $output]
	orafail $output
}

# input file is line oriented
set found "false"
while {[gets $servfile line] >= 0} {
    
    # clean out variables so they don't carry data from previous pass
    set myname ""
    set myf2 ""
    set myf3 ""
    set myf4 ""
    set myf5 ""
    
    # grab tokens from line
    set fcnt [scan $line "%s = (%s %s %s %s)" myname myf2 myf3 myf4 myf5]
    
    # skip blank lines
    if {$fcnt == 0} {
	continue;
    }
    
    #match target type, else continue looking 
    #BugNo:887786 
    set target_type_len [string length $myf2 ]
    set target_type     [string range $myf2 0 [expr $target_type_len-2]]
    if {($target_type != "oracle_sysman_cmanager")} {
	continue;
    }

    # match target name, else continue looking
    if {($myname != $targname)} {
	continue;
    }
    set found "true"
    close $servfile
    
    # strip bogus characters from fields
    set IcmNameLen [string length $myf5 ]
    set ICMname [string range $myf5 0 [expr $IcmNameLen-2]]
      ORATCL_DEBUG "cmstartupn: [oratime] will run net start $ICMname"
    
    
    # Query Instance for version number to change langvar
    set plsqlver { declare 
    apps_version varchar2(30) ;
    begin
    /* OracleOEM */
    select  product_version
    into    :appver
    from fnd_product_installations
    where application_id = 0;
    end;
}

if {[catch {oraplexec $cur $plsqlver :appver "" } langretlist]} {
    ORATCL_DEBUG "startupn : [oratime] plsql failed "
    ORATCL_DEBUG "errortxt $oramsg(errortxt)"
    ORATCL_DEBUG "ocifunc $oramsg(ocifunc)"
    ORATCL_DEBUG "sqlfunc $oramsg(sqlfunc)"
    ORATCL_DEBUG " return code:  $oramsg(rc) "
    ORATCL_DEBUG " return value is: $retlist"
    
    catch {oralogoff $lda}
    
    set output [format [msgtxt [NETWORK] smamp 6002] "shutdown.tcl"] 
    set output [convertout $oramsg(agent_characterset) $output]
    orafail " "
}

set apps_ver [lindex $langretlist 0]
ORATCL_DEBUG "startupn: [oratime] apps version number is : $apps_ver " 

# v_type will track what we want to put in the file that we run regedit on
# 0 -> 10.7, unpatched 11.0;  1 -> patched 11.0, 11i 
set v_type 0 
set VERSION $apps_ver
if {[regexp {6\.1\.} $apps_ver]} {
    set VERSION "10.7.0"
} elseif {[regexp {11\.} $apps_ver]} {
    set v_type 1
}

set regpath SOFTWARE\\ORACLE\\Applications\\$VERSION
if {[catch {registry get HKEY_LOCAL_MACHINE\\$regpath APPL_CONFIG} reg_value] == 0 } {
    ORATCL_DEBUG "startupn: Found APPL_CONFIG: $reg_value"
    set regpath $regpath\\$reg_value
    ORATCL_DEBUG "startupn new regpath: $regpath"
    
    if {[regexp {11\.0} $VERSION]} {
	# check patch status 
	if {[catch {registry get HKEY_LOCAL_MACHINE\\$regpath CCMCONNSTRING} r_val]} {
	    # No patch set... treat as a 10.7 instance
	    set v_type 0
	}
    }
    
    set fout "REGEDIT4\n"
    append fout "\[HKEY_LOCAL_MACHINE\\$regpath\]\n"
    set fout_bak $fout
    if {$v_type == 0} {
	append fout "\"sleep\"=\"$sleeptime\"\n"
	append fout "\"quesiz\"=\"$queuesize\"\n"
	append fout "\"pmon\"=\"$pmon\"\n"
	append fout "\"diag\"=\"$diag\"\n"
	append fout "\"restart\"=\"$rstart\"\n"
	if {[catch {registry get HKEY_LOCAL_MACHINE\\$regpath sleep} r_val] == 0} {
	    append fout_bak "\"sleep\"=\"$r_val\"\n"
	}
	if {[catch {registry get HKEY_LOCAL_MACHINE\\$regpath quesiz} r_val] == 0} {
	    append fout_bak "\"quesiz\"=\"$r_val\"\n"
	}
	if {[catch {registry get HKEY_LOCAL_MACHINE\\$regpath pmon} r_val] == 0} {
	    append fout_bak "\"pmon\"=\"$r_val\"\n"
	}
	if {[catch {registry get HKEY_LOCAL_MACHINE\\$regpath diag} r_val] == 0} {
	    append fout_bak "\"diag\"=\"$r_val\"\n"
	}
	if {[catch {registry get HKEY_LOCAL_MACHINE\\$regpath restart} r_val] == 0} {
	    append fout_bak "\"restart\"=\"$r_val\"\n"
	}
    } else {
	append fout "\"CCMSLEEP\"=\"$sleeptime\"\n"
	append fout "\"CCMQSIZ\"=\"$queuesiz\"\n"
	append fout "\"CCMRESTART\"=\"$rstart\"\n"
	append fout "\"CCMPMON\"=\"$pmon\"\n"
	append fout "\"CCMDIAGOUTPUT\"=\"$diag\"\n"
	if {[catch {registry get HKEY_LOCAL_MACHINE\\$regpath CCMSLEEP} r_val] == 0} {
	    append fout_bak "\"CCMSLEEP\"=\"$r_val\"\n"
	}
	if {[catch {registry get HKEY_LOCAL_MACHINE\\$regpath CCMQSIZ} r_val] == 0} {
	    append fout_bak "\"CCMQSIZ\"=\"$r_val\"\n"
	}
	if {[catch {registry get HKEY_LOCAL_MACHINE\\$regpath CCMPMON} r_val] == 0} {
	    append fout_bak "\"CCMPMON\"=\"$r_val\"\n"
	}
	if {[catch {registry get HKEY_LOCAL_MACHINE\\$regpath CCMDIAGOUTPUT} r_val] == 0} {
	    append fout_bak "\"CCMDIAGOUTPUT\"=\"$r_val\"\n"
	}
	if {[catch {registry get HKEY_LOCAL_MACHINE\\$regpath CCMRESTART} r_val] == 0} {
	    append fout_bak "\"CCMRESTART\"=\"$r_val\"\n"
	}
    }

    set tf [tempfile tmp]
    set otf [open $tf w]
    puts $otf $fout
    close $otf

    # This is the backup of the old parameters in case the startup fails
    # so we can reset them to their old values.
    set tf_bak [tempfile tp]
    set otfb [open $tf_bak w]
    puts $otfb $fout_bak
    close $otfb
    
    if {[catch {OS_SHELL_EXEC "regedit /s $tf"} outx]} {
	ORATCL_DEBUG "startupn: [oratime] merge of new startup params failed"
    }
    
    catch {rmfile $tf}
    
}

    if { [catch { exec net start $ICMname} outx ] } {
 	# Will need to try again after a fixed interval of time
	# The  delay has to be adjusted
	# ORATCL_DEBUG "Sleeping for : $delay"  
	orasleep $delay 
	if { [catch { exec net start $ICMname} outx ] } {
	    if {[catch {OS_SHELL_EXEC "regedit /s $tf_bak"} outx]} {
		ORATCL_DEBUG "startupn: [oratime] merge of backed up startup params failed"
	    }
	    catch {rmfile $tf_bak}
	    
	    set output [format [msgtxt [NETWORK] smamp 8025] $outx  ]
	    set output [convertout $oramsg(agent_characterset) $output]
	    orafail $output
	}
    }
  	set  output [format [msgtxt [NETWORK] smamp 8026] $outx  ]
	set output [convertout $oramsg(agent_characterset) $output]
	puts $output
    return
}
# end of while loop, parsing input file

# another "impossible" error: couldn't find target in services.ora
if { $found == "false" } {
    close $servfile;
	set output [format [msgtxt [NETWORK] smamp 8006] $targname 'cmanager' $servfname ]
	set output [convertout $oramsg(agent_characterset) $output]
	orafail $output
}

