#
# /agent/config/nmisqlsrv.tcl
#
# Discovery Script for MS SQL Server
#
# kduvvuri 01/05/2001 - create service name using service name and service
#                       type
#
global Parameters ServiceNames UserData ServiceType HostName
set Parameters(oracle_sysman_sqlserver) { ServiceType HostName UserData }

#load registry.dll fro registry calls

package ifneeded registry 1.1 [list load tclreg11.dll registry]
package require registry

#  append getdgstatus [ORACLE_HOME] "\\bin\\vppcntl"
#  set status [catch {exec $getdgstatus "-discover=oracle_sysman_sqlserver"} temp]

set status [catch {registry get HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\MSSQLServer\\MSSQLServer\\CurrentVersion CurrentVersion} sqlServerName]

if {$status == 0} {
  set service SQLSRV_$Host
  set ServiceIndex [list $service oracle_sysman_sqlserver]
  lappend ServiceNames $ServiceIndex
  set ServiceType($ServiceIndex) oracle_sysman_sqlserver
  set HostName($ServiceIndex) $Host
  set UserData($ServiceIndex) $Host
}
