# parray:
# Print the contents of a global array on stdout.
#
# RCS: @(#) $Id: parray.tcl 15-jun-2004.15:27:52 xxu Exp $
#
# Copyright (c) 1991, 2004, Oracle. All rights reserved.  
# Copyright (c) 1994, 2004, Oracle. All rights reserved.  
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#

proc parray {a {pattern *}} {
    upvar 1 $a array
    if {![array exists array]} {
	error "\"$a\" isn't an array"
    }
    set maxl 0
    foreach name [lsort [array names array $pattern]] {
	if {[string length $name] > $maxl} {
	    set maxl [string length $name]
	}
    }
    set maxl [expr {$maxl + [string length $a] + 2}]
    foreach name [lsort [array names array $pattern]] {
	set nameString [format %s(%s) $a $name]
	puts stdout [format "%-*s = %s" $maxl $nameString $array($name)]
    }
}
