// Oracle Connection class -- Ran Wei, Oracle SDO, 9/10/1998
//
// Copyright 1998, Oracle Corp.

#include "stdafx.h"
#include <string.h>
#include <oci.h>
extern "C" {
#include "sdo_oci.h"
}
#include <Connect.h>

// Connection constructor
Connection::Connection() 
{
	connected = FALSE;

	envhp = NULL;
	errhp = NULL;
	srvhp = NULL;
	svchp = NULL;
	usrhp = NULL;
}

// Connect to ORACLE
void Connection::Connect(const char* dblink, 
						 const char* username, const char* password)
{
	sword status;

	TRACE("Entering Connection::Connect\n");

	int mode = OCI_THREADED|OCI_OBJECT;
	SDO_OCIInitialize((ub4)mode, (dvoid *)0, 
				      (dvoid*(*)(dvoid *ctxp, size_t size))0, 
				      (dvoid*(*)(dvoid *ctxp, dvoid *memptr, size_t newsize))0, 
				      (void (*)(dvoid *ctxp, dvoid *memptr))0);

	// Initialize envhp
	SDO_OCIEnvInit(&envhp, (ub4)OCI_DEFAULT, (size_t)0, (dvoid**)0);

	// Initialize errhp and srvhp
	SDO_OCIHandleAlloc((dvoid*)envhp, (dvoid**)&errhp, (ub4)OCI_HTYPE_ERROR,
					   (size_t)0, (dvoid**)0);
	SDO_OCIHandleAlloc((dvoid*)envhp, (dvoid**)&srvhp, (ub4)OCI_HTYPE_SERVER,
					   (size_t)0, (dvoid**)0);
	status = SDO_OCIServerAttach(srvhp, errhp, (text*)dblink, 
								 (sb4)strlen(dblink), (ub4)OCI_DEFAULT);
	if (status != OCI_SUCCESS)
		return;

	// Initialize svchp
	SDO_OCIHandleAlloc((dvoid*)envhp, (dvoid**)&svchp, (ub4)OCI_HTYPE_SVCCTX, 
					   (size_t)0, (dvoid**)0);
	SDO_OCIAttrSet((dvoid*)svchp, (ub4)OCI_HTYPE_SVCCTX, (dvoid*)srvhp, (ub4)0, 
				   (ub4)OCI_ATTR_SERVER, errhp);

	// Initialize usrhp
	SDO_OCIHandleAlloc((dvoid*)envhp, (dvoid**)&usrhp, (ub4)OCI_HTYPE_SESSION, 
					   (size_t)0, (dvoid**)0);
	SDO_OCIAttrSet((dvoid*)usrhp, (ub4)OCI_HTYPE_SESSION, (dvoid*)username, 
				   (ub4)strlen(username), (ub4)OCI_ATTR_USERNAME, errhp);
	SDO_OCIAttrSet((dvoid*)usrhp, (ub4)OCI_HTYPE_SESSION, (dvoid*)password, 
				   (ub4)strlen(password), (ub4)OCI_ATTR_PASSWORD, errhp);
  
	// Session begins
	status = SDO_OCISessionBegin(svchp, errhp, usrhp, OCI_CRED_RDBMS, 
								 OCI_DEFAULT);
	if (status != OCI_SUCCESS)
		return;

	SDO_OCIAttrSet((dvoid*)svchp, (ub4)OCI_HTYPE_SVCCTX, (dvoid*)usrhp, (ub4)0, 
				   (ub4)OCI_ATTR_SESSION, errhp);

	connected = TRUE;
	TRACE("Connected to Oracle\n");
}

// Disconnect from ORACLE
void Connection::Disconnect()
{
	TRACE("Entering Connection::Disconnect\n");

	if (connected)
	{
		// Session ends
		SDO_OCISessionEnd(svchp, errhp, usrhp, (ub4)OCI_DEFAULT);
		SDO_OCIServerDetach(srvhp, errhp, (ub4)OCI_DEFAULT);

		// Finalize svchp, srvhp, and errhp
		SDO_OCIHandleFree((dvoid*)svchp, (ub4)OCI_HTYPE_SVCCTX);
		SDO_OCIHandleFree((dvoid*)srvhp, (ub4)OCI_HTYPE_SERVER);
		SDO_OCIHandleFree((dvoid*)errhp, (ub4)OCI_HTYPE_ERROR);

		connected = FALSE;
		TRACE("Disconnected from Oracle\n");
	}
}

// Check OCI error
void Connection::CheckError(OCIError* errhp, int status)
{
	text errbuf[512];
	sb4 errcode = 0;

	if (status == OCI_ERROR)
	{
		SDO_OCIErrorGet((dvoid*)errhp, (ub4)1, (text*)NULL, &errcode, 
						errbuf, (ub4)sizeof(errbuf), OCI_HTYPE_ERROR);
		TRACE("%.*s\n", 512, errbuf);
		Disconnect();
	}
}

