// Oracle Object Cursor class -- Ran Wei, Oracle SDO, 9/10/1998
//
// Copyright 1998, Oracle Corp.

#include "stdafx.h"
#include <oci.h>
extern "C" {
#include "sdo_oci.h"
}
#include <Connect.h>
#include <ObjectCursor.h>

// ObjectCursor constructor
ObjectCursor::ObjectCursor(Connection* conn) : Cursor(conn)
{
	dschp = NULL;
	// Initiate TDO member
	m_tdo = NULL;
}

// Open the Cursor
void ObjectCursor::Open()
{
	Cursor::Open();
	// Initialize type descriptor handle 
	CheckError(SDO_OCIHandleAlloc(conn->envhp, (dvoid**)&dschp, 
								  (ub4)OCI_HTYPE_DESCRIBE, (size_t)0, 
								  (dvoid**)0));
}

// Close the Cursor
void ObjectCursor::Close()
{
	Cursor::Close();
	// Release TDO
	if (m_tdo != NULL)
	{
		ReleaseObject(m_tdo);
		m_tdo = NULL;
	}

	// Finalize dschp
	//CheckError(SDO_OCIHandleFree((dvoid*)dschp, (ub4)OCI_HTYPE_DESCRIBE));
	SDO_OCIHandleFree((dvoid*)dschp, (ub4)OCI_HTYPE_DESCRIBE);
}

// Bind object
void ObjectCursor::BindObjectByPos(int pos, char* typeName, void** value, 
								   void** indicator)
{
	OCIBind *bindp = NULL;
	OCIType* tdo = NULL;

	GetTDO(typeName, &tdo);
	// keep track of this TDO
	m_tdo = tdo;

	CheckError(SDO_OCIBindByPos(stmthp, &bindp, conn->errhp, pos, (dvoid *)0, 
								(sb4)0, SQLT_NTY, (dvoid *)0, (ub2 *)0, 
								(ub2 *)0, (ub4)0, (ub4 *)0, (ub4)OCI_DEFAULT));

	CheckError(SDO_OCIBindObject(bindp, conn->errhp, tdo, (dvoid **)value, 
								 (ub4 *)0, (dvoid **)indicator, (ub4 *)0));
}

void ObjectCursor::BindObjectByName(char* name, char* typeName, void** value, 
									void** indicator)
{
	OCIBind *bindp = NULL;
	OCIType* tdo = NULL;

	GetTDO(typeName, &tdo);
	// keep track of this TDO
	m_tdo = tdo;

	CheckError(SDO_OCIBindByName(stmthp, &bindp, conn->errhp, (text*)name, 
								 (sb4)-1, (dvoid *)0, (sb4)0, SQLT_NTY, 
								 (dvoid *)0, (ub2 *)0, (ub2 *)0, (ub4)0, 
								 (ub4 *)0, (ub4)OCI_DEFAULT));

	CheckError(SDO_OCIBindObject(bindp, conn->errhp, tdo, (dvoid **)value, 
								 (ub4 *)0, (dvoid **)indicator, (ub4 *)0));
}

// Define object
void ObjectCursor::DefineObjectByPos(int pos, char* typeName, void** value, 
									 void** indicator)
{
	OCIDefine *defnp = NULL;
	OCIType* tdo = NULL;

	GetTDO(typeName, &tdo);
	// keep track of this TDO
	m_tdo = tdo;

	CheckError(SDO_OCIDefineByPos(stmthp, &defnp, conn->errhp, (ub4)pos, 
								  (dvoid *)0, (sb4)0, SQLT_NTY, (dvoid *)0, 
								  (ub2 *)0, (ub2 *)0, (ub4)OCI_DEFAULT));

	CheckError(SDO_OCIDefineObject(defnp, conn->errhp, tdo, (dvoid **)value, 
								   (ub4 *)0, (dvoid **)indicator, (ub4 *)0));
}

// Get Type Descriptor Object
void ObjectCursor::GetTDO(const char* typeName, OCIType** tdo)
{
	OCIParam *paramp = NULL;
	OCIRef *type_ref = NULL;

	CheckError(SDO_OCIDescribeAny(conn->svchp, conn->errhp, (text *)typeName, 
								  (ub4)strlen((char *)typeName), OCI_OTYPE_NAME, 
								  (ub1)1, (ub1)OCI_PTYPE_TYPE, dschp));

	CheckError(SDO_OCIAttrGet((dvoid *)dschp, (ub4)OCI_HTYPE_DESCRIBE,
							  (dvoid *)&paramp, (ub4 *)0, (ub4)OCI_ATTR_PARAM, 
							  conn->errhp));

	CheckError(SDO_OCIAttrGet((dvoid *)paramp, (ub4)OCI_DTYPE_PARAM,
							  (dvoid *)&type_ref, (ub4 *)0, (ub4)OCI_ATTR_REF_TDO, 
							  conn->errhp));

	CheckError(SDO_OCIObjectPin(conn->envhp, conn->errhp, type_ref, 
								(OCIComplexObject *)0, OCI_PIN_ANY, 
								OCI_DURATION_SESSION, OCI_LOCK_NONE, 
								(dvoid **)tdo));
}

// Release Object
void ObjectCursor::ReleaseObject(void* object)
{
	CheckError(SDO_OCIObjectFree(conn->envhp, conn->errhp, (dvoid*)object, 
								 OCI_OBJECTFREE_FORCE));
}

