// Oracle SDO Geometry Metadata Cursor class -- Ran Wei, Oracle SDO, 9/10/1998
//
// Copyright 1998, Oracle Corp.

#include "stdafx.h"
#include <oci.h>
extern "C" {
#include "sdo_oci.h"
}
#include <Connect.h>
#include <SDOMetaCursor.h>

// SDOMetaCursor constructor
SDOMetaCursor::SDOMetaCursor(Connection* conn) : ObjectCursor(conn)
{
}

// Bind object
void SDOMetaCursor::BindMetaByPos(int pos, OCIArray** dArray, 
								  short** dIndicator)
{
	ObjectCursor::BindObjectByPos(pos, SDO_DIM_TYPENAME, 
								  (void**)dArray, (void**)dIndicator);
}

void SDOMetaCursor::BindMetaByName(char* name, OCIArray** dArray, 
								  short** dIndicator)
{
	ObjectCursor::BindObjectByName(name, SDO_DIM_TYPENAME, 
								   (void**)dArray, (void**)dIndicator);
}

// Define object
void SDOMetaCursor::DefineMetaByPos(int pos, OCIArray** dArray, 
								    short** dIndicator)
{
	ObjectCursor::DefineObjectByPos(pos, SDO_DIM_TYPENAME, 
									(void**)dArray, (void**)dIndicator);
}

// Convert SDO dim array to client-side form
BOOL SDOMetaCursor::SDOTypeToClient(OCIArray* dArray, short* dIndicator, 
								    CSDODimArray* dimArray)
{
	long nDim;

	// Initialization
	dimArray->SetSize(0);
	if (*dIndicator == OCI_IND_NULL)
		return TRUE;

	// Get the number of dimensions
	SDO_OCICollSize(conn->envhp, conn->errhp, (OCIColl *)dArray, &nDim);

	// Get information for each dimension
	for (int i = 0; i < nDim; i++)
	{
		sdo_dim_element* dElement;
		boolean exists;
		CSDODimElement dimElement;

		if (SDO_OCICollGetElem(conn->envhp, conn->errhp, 
							   (OCIColl *)(dArray), (sb4)i, (boolean *)&exists, 
							   (dvoid **)&dElement, (dvoid **)0) != OCI_SUCCESS)
			return FALSE;

		dimElement.m_strDimName = 
			(char*) SDO_OCIStringPtr(conn->envhp, dElement->sdo_dimname);

		SDO_OCINumberToReal(conn->errhp, &(dElement->sdo_lb), 
							(uword)sizeof(double), (dvoid *)&(dimElement.m_dLB));
		SDO_OCINumberToReal(conn->errhp, &(dElement->sdo_ub), 
							(uword)sizeof(double), (dvoid *)&(dimElement.m_dUB));
		SDO_OCINumberToReal(conn->errhp, &(dElement->sdo_tolerance), 
							(uword)sizeof(double), 
							(dvoid *)&(dimElement.m_dTolerance));

		dimArray->Add(dimElement);
	}

	return TRUE;
}

