// ChildFrm.cpp : implementation of the CChildFrame class
//

#include "stdafx.h"
#include "VisualSDO.h"
#include "ChildFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CChildFrame

IMPLEMENT_DYNCREATE(CChildFrame, CMDIChildWnd)

BEGIN_MESSAGE_MAP(CChildFrame, CMDIChildWnd)
	//{{AFX_MSG_MAP(CChildFrame)
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CChildFrame construction/destruction

CChildFrame::CChildFrame()
{
	// TODO: add member initialization code here
	m_bFrameCreated = FALSE;
	m_nTextViewHeight = 100;	
}

CChildFrame::~CChildFrame()
{
}

BOOL CChildFrame::OnCreateClient( LPCREATESTRUCT /*lpcs*/,
	CCreateContext* pContext)
{
	//return m_wndSplitter.Create( this,
	//	2, 2,                 // TODO: adjust the number of rows, columns
	//	CSize( 10, 10 ),      // TODO: adjust the minimum pane size
	//	pContext );

	WINDOWPLACEMENT wp;
	GetWindowPlacement(&wp);
	CRect rect(wp.rcNormalPosition);
	int width = int(rect.right - rect.left);
	int height = int(rect.bottom - rect.top);
	VERIFY(m_wndSplitter.CreateStatic(this, 2, 1));
	VERIFY(m_wndSplitter.CreateView(0, 0, RUNTIME_CLASS(CSDOGraphicView),
		CSize(width, height - m_nTextViewHeight), pContext));
	VERIFY(m_wndSplitter.CreateView(1, 0, RUNTIME_CLASS(CSDOTextView),
		CSize(width, m_nTextViewHeight), pContext));
	m_bFrameCreated = TRUE;

	return TRUE;
}

BOOL CChildFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CMDIChildWnd::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CChildFrame diagnostics

#ifdef _DEBUG
void CChildFrame::AssertValid() const
{
	CMDIChildWnd::AssertValid();
}

void CChildFrame::Dump(CDumpContext& dc) const
{
	CMDIChildWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CChildFrame helper functions

CSDOGraphicView* CChildFrame::GetSDOGraphicView()
{
	return (CSDOGraphicView*) m_wndSplitter.GetPane(0, 0);
}

CSDOTextView* CChildFrame::GetSDOTextView()
{
	return (CSDOTextView*) m_wndSplitter.GetPane(1, 0);
}

/////////////////////////////////////////////////////////////////////////////
// CChildFrame message handlers

void CChildFrame::OnSize(UINT nType, int cx, int cy) 
{
	CMDIChildWnd::OnSize(nType, cx, cy);
	if (m_bFrameCreated && nType != SIZE_MINIMIZED)
	{
		int textHeight = m_nTextViewHeight;
		if (textHeight > cy / 6)
			textHeight = cy / 6;
		m_wndSplitter.SetRowInfo(0, cy - textHeight, 0);
		m_wndSplitter.SetRowInfo(1, textHeight, 0);
		m_wndSplitter.RecalcLayout();
	}
}
