// ConnectDlg.cpp : implementation file
// -- Ran Wei, Oracle SDO, 9/10/1998
//
// Copyright 1998, Oracle Corp.

#include <Connect.h>
#include "stdafx.h"
#include "VisualSDO.h"
#include "ConnectDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CConnectDlg dialog


CConnectDlg::CConnectDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CConnectDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CConnectDlg)
	m_strPassword = _T("");
	m_strUsername = _T("");
	m_strDatabase = _T("");
	m_bChecked = FALSE;
	//}}AFX_DATA_INIT

	// Read user profile
	m_strUsername = AfxGetApp()->GetProfileString("Settings", "Username");
	m_bChecked = AfxGetApp()->GetProfileInt("Settings", "Ckecked", 0);
	m_strPassword = AfxGetApp()->GetProfileString("Settings", "Password");
	m_strDatabase = AfxGetApp()->GetProfileString("Settings", "Database");
}


void CConnectDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CConnectDlg)
	DDX_Text(pDX, IDC_PASSWORD, m_strPassword);
	DDX_Text(pDX, IDC_USERNAME, m_strUsername);
	DDX_Text(pDX, IDC_DATABASE, m_strDatabase);
	DDX_Check(pDX, IDC_CHECK, m_bChecked);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CConnectDlg, CDialog)
	//{{AFX_MSG_MAP(CConnectDlg)
	ON_BN_CLICKED(IDC_CONNECT, OnConnect)
	ON_BN_CLICKED(IDC_CLEAR, OnClear)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConnectDlg message handlers

void CConnectDlg::OnConnect() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	BeginWaitCursor();
	conn->Connect(m_strDatabase, m_strUsername, m_strPassword);

	// Save user profile
	AfxGetApp()->WriteProfileString("Settings", "Username", m_strUsername);
	AfxGetApp()->WriteProfileInt("Settings", "Ckecked", m_bChecked);
	if (m_bChecked)
		AfxGetApp()->WriteProfileString("Settings", "Password", m_strPassword);
	else
		AfxGetApp()->WriteProfileString("Settings", "Password", "");
	AfxGetApp()->WriteProfileString("Settings", "Database", m_strDatabase);

	EndWaitCursor();
	CDialog::OnOK();
}

void CConnectDlg::OnClear() 
{
	// TODO: Add your control notification handler code here
	m_strDatabase = m_strUsername = m_strPassword = "";
	UpdateData(FALSE);
}
