// GeomTablesDlg.cpp : implementation file
// -- Ran Wei, Oracle SDO, 9/10/1998
//
// Copyright 1998, Oracle Corp.

#include "stdafx.h"
#include "visualsdo.h"
#include "GeomTablesDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGeomTablesDlg dialog


CGeomTablesDlg::CGeomTablesDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGeomTablesDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGeomTablesDlg)
	m_strKey = _T("");
	m_strValue = _T("");
	//}}AFX_DATA_INIT
}


void CGeomTablesDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGeomTablesDlg)
	DDX_CBString(pDX, IDC_KEY, m_strKey);
	DDX_CBString(pDX, IDC_VALUE, m_strValue);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGeomTablesDlg, CDialog)
	//{{AFX_MSG_MAP(CGeomTablesDlg)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_LIST, OnItemchangedList)
	ON_CBN_SELCHANGE(IDC_KEY, OnSelchangeKey)
	ON_CBN_SELCHANGE(IDC_VALUE, OnSelchangeValue)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGeomTablesDlg helper functions

BOOL CGeomTablesDlg::QueryTableColumns()
{
	Cursor cursor(conn);
	CString tableName = (*m_geomMetaArray)[m_nSelected].m_strTableName;
	char cName[64], dName[64];
	short cIndicator, dIndicator;
	CComboBox* pCombo = (CComboBox*) GetDlgItem(IDC_KEY);

	CString stmt = "SELECT column_name, data_type FROM user_tab_columns "
				   "WHERE table_name = '" + tableName + "' " + 
				   "AND (data_type = 'NUMBER' OR data_type = 'VARCHAR2')";
	TRACE("Statement: " + stmt + "\n");

	// Query for geometry metadata
	try 
	{
		cursor.Open();
		cursor.Prepare(stmt);

		cursor.DefineByPos(1, &cName, sizeof(cName), (void*)&cIndicator, 
						   SQLT_STR);
		cursor.DefineByPos(2, &dName, sizeof(dName), (void*)&dIndicator, 
						   SQLT_STR);
		cursor.Execute(1);

		// Populate geometry metadata into combo box
		pCombo->ResetContent();
		while (TRUE) 
		{
			CString str;
			str.Format("%s (%s)", cName, dName);
			pCombo->AddString(str);	
			try
			{
				cursor.Fetch(1);
			}
			catch (CCursorDataException* e)		// Fetch till no more data 
			{
				e->Delete();
				break;
			}
		}

		cursor.Close();
	}
	catch (CCursorGeneralException* e)
	{
		e->Delete();
		cursor.Close();
		return FALSE;
	}

	pCombo->AddString("ROWID (ROWID)");	
	pCombo->SetCurSel(0);
	return TRUE;
}

BOOL CGeomTablesDlg::QueryKeyValues()
{
	Cursor cursor(conn);
	CString tableName = (*m_geomMetaArray)[m_nSelected].m_strTableName;
	BOOL bIsNumber;
	char tValue[64];
	int nValue;
	short tIndicator, nIndicator;
	CComboBox* pCombo = (CComboBox*) GetDlgItem(IDC_VALUE);

	// Extract column name and type from string like "name (type)"
	int i = m_strKey.Find('(');
	if (i <= 0)
		return FALSE;
	m_strKeyName = m_strKey.Left(i-1);
	int j = m_strKey.Find(')');
	if (j <= 0)
		return FALSE;
	m_strKeyType = m_strKey.Mid(i+1, j-i-1);
	bIsNumber = (m_strKeyType.Compare("NUMBER") == 0);

	CString stmt = "SELECT " + m_strKeyName + " FROM " + tableName;
	TRACE("Statement: " + stmt + "\n");

	// Query for geometry metadata
	try
	{
		cursor.Open();
		cursor.Prepare(stmt);

		if (bIsNumber)
			cursor.DefineByPos(1, &nValue, sizeof(nValue), 
							   (void*)&nIndicator, SQLT_INT);
		else
			cursor.DefineByPos(1, &tValue, sizeof(tValue), 
							   (void*)&tIndicator, SQLT_STR);

		cursor.Execute(1);

		// Populate geometry metadata into combo box
		pCombo->ResetContent();
		while (TRUE) 
		{
			CString str;
			if (bIsNumber)
				str.Format("%d", nValue);
			else
				str = tValue;
			pCombo->AddString(str);	
			try
			{
				cursor.Fetch(1);
			}
			catch (CCursorDataException* e)		// Fetch till no more data 
			{
				e->Delete();
				break;
			}
		}

		cursor.Close();
	}
	catch (CCursorGeneralException* e)
	{
		e->Delete();
		cursor.Close();
		return FALSE;
	}

	pCombo->SetCurSel(0);
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CGeomTablesDlg message handlers

BOOL CGeomTablesDlg::OnInitDialog() 
{
	// TODO: Add extra initialization here
	// Populate the geometry Table:Column list
	HICON hIcon = AfxGetApp()->LoadIcon(IDI_GEOM);
	m_imageList.Create(16, 16, ILC_COLOR, 1, 2);
	m_imageList.Add(hIcon);

	CListCtrl* pList = (CListCtrl*) GetDlgItem(IDC_LIST);
	pList->SetImageList(&m_imageList, LVSIL_SMALL);
	for (int i = 0; i < m_geomMetaArray->GetSize(); i++)
	{
		CSDOGeomMeta geomMeta = (*m_geomMetaArray)[i];
		CString str = geomMeta.m_strTableName + ":" + 
					  geomMeta.m_strColumnName;
		pList->InsertItem(i, str, 0);
		TRACE(str + "\n");
	}

	return CDialog::OnInitDialog();
}

void CGeomTablesDlg::OnItemchangedList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	TRACE("Item %d selected\n", pNMListView->iItem);
	m_nSelected = pNMListView->iItem;

	// Query columns for the selected table
	if (m_nSelected >= 0 && m_nSelected < (*m_geomMetaArray).GetSize())
	{
		BeginWaitCursor();
		QueryTableColumns();
		OnSelchangeKey();
		EndWaitCursor();
	}
	
	*pResult = 0;
}

void CGeomTablesDlg::OnSelchangeKey() 
{
	// Query data in the selected column
	if (m_nSelected >= 0 && m_nSelected < (*m_geomMetaArray).GetSize())
	{
		// Query for key values
		UpdateData(TRUE);
		BeginWaitCursor();
		QueryKeyValues();
		EndWaitCursor();
	}
}

void CGeomTablesDlg::OnSelchangeValue() 
{
	OnOK();
}
