// Oracle Connection class -- Ran Wei, Oracle SDO, 9/10/1998
//
// Copyright 1998, Oracle Corp.

#ifndef CONNECT_H
#define CONNECT_H

#include <oci.h>

// This class represents a Connection to ORACLE database.
class AFX_EXT_CLASS Connection
{
protected:
	BOOL connected;

public:
	OCIEnv* envhp;        // OCI connection handles
	OCIError* errhp;
	OCIServer* srvhp;
	OCISvcCtx* svchp;
	OCISession* usrhp;

public:
	Connection();
	~Connection() { Disconnect(); }
	void Connect(const char* dblink, 
				 const char* username, const char* password);
	void Disconnect();
	BOOL IsConnected() { return connected; }
	void CheckError(OCIError* errhp, int status);
};

#endif // CONNECT_H

		