// Oracle generic Cursor class -- Ran Wei, Oracle SDO, 9/10/1998
//
// Copyright 1998, Oracle Corp.

#ifndef CURSOR_H
#define CURSOR_H

#include <oci.h>
#include <Connect.h>

// General cursor exception
class AFX_EXT_CLASS CCursorGeneralException : public CException
{
	DECLARE_DYNAMIC(CCursorGeneralException)
public:
	CCursorGeneralException(int nError, char* pchMessage)
	{ m_nError = nError;  m_strMessage = pchMessage; }

	~CCursorGeneralException() {}
	virtual BOOL GetErrorMessage(LPTSTR lpstrError, UINT nMaxError,
								 PUINT pnHelpContext = NULL);
private:
	int m_nError;
	CString m_strMessage;
};

// Data exceptions such as NoData, etc.
class AFX_EXT_CLASS CCursorDataException : public CException
{
	DECLARE_DYNAMIC(CCursorDataException)
public:
	CCursorDataException(int nError) 
	{ m_nError = nError; }

	~CCursorDataException() {}
	virtual BOOL GetErrorMessage(LPTSTR lpstrError, UINT nMaxError,
								 PUINT pnHelpContext = NULL);
private:
	int m_nError;
};

// Cursor class 
class AFX_EXT_CLASS Cursor
{
protected:
	Connection* conn;
	OCIStmt* stmthp;				// OCI statement handle

public:
	Cursor(Connection* conn);
	~Cursor() { Close(); }
	void Open();
	void Close();

	// Parse
	void Prepare(char* stmt);
	void Prepare(CString strStmt);

	// Bind
	void BindByPos(int pos, void* value, int size, void* indicator, int type);
	void BindByName(char* name, void* value, int size, void* indicator, int type);

	// Define
	void DefineByPos(int pos, void* value, int size, void* indicator, int type);

	// Execute and Fetch
	void Execute(int times);
	void Fetch(int rows);

protected:
	// Throws exception if error found
	void CheckError(sword status);
};

#endif // CURSOR_H