// Oracle Object Cursor class -- Ran Wei, Oracle SDO, 9/10/1998
//
// Copyright 1998, Oracle Corp.

#ifndef OBJECT_CURSOR_H
#define OBJECT_CURSOR_H

#include <oci.h>
#include <Connect.h>
#include <Cursor.h>

class AFX_EXT_CLASS ObjectCursor : public Cursor
{
protected:
	OCIDescribe* dschp;				// OCI type descriptor handle
	// NOTE: this demo uses a single TDO member for simplicity
	OCIType* m_tdo;

protected:
	// Get Type Descriptor Object
	void GetTDO(const char* typeName, OCIType** tdo);

public:
	ObjectCursor(Connection* conn);
	void Open();
	void Close();

	// Bind object
	void BindObjectByPos(int pos, char* typeName, void** value, 
						 void** indicator);
	void BindObjectByName(char* name, char* typeName, void** value, 
						  void** indicator);

	// Define object
	void DefineObjectByPos(int pos, char* typeName, void** value, 
						   void** indicator);

	void ReleaseObject(void* object);
};

#endif // OBJECT_CURSOR_H