// SDO Server Side Data Types -- Ran Wei, Oracle SDO, 9/10/1998
//
// Copyright 1998, Oracle Corp.
///////////////////////////////////////////////////////////////////////

#ifndef SDO_DATA_TYPES_H
#define SDO_DATA_TYPES_H

#ifndef OCI_ORACLE
#include <oci.h>
#endif

#define SDO_DIM_TYPENAME "mdsys.sdo_dim_array"
#define SDO_GEOM_TYPENAME "mdsys.sdo_geometry"

typedef OCIRef sdo_geometry_ref;
typedef OCIRef sdo_dim_element_ref;
typedef OCIArray sdo_dim_array;
typedef OCIRef sdo_point_type_ref;
typedef OCIArray sdo_elem_info_array;
typedef OCIArray sdo_ordinate_array;

struct sdo_point_type
{
   OCINumber x;
   OCINumber y;
   OCINumber z;
};
typedef struct sdo_point_type sdo_point_type;

struct sdo_point_type_ind
{
   OCIInd _atomic;
   OCIInd x;
   OCIInd y;
   OCIInd z;
};
typedef struct sdo_point_type_ind sdo_point_type_ind;

struct sdo_geometry
{
   OCINumber sdo_gtype;
   OCINumber sdo_srid;
   struct sdo_point_type sdo_point;
   sdo_elem_info_array * sdo_elem_info;
   sdo_ordinate_array * sdo_ordinates;
};
typedef struct sdo_geometry sdo_geometry;

struct sdo_geometry_ind
{
   OCIInd _atomic;
   OCIInd sdo_gtype;
   OCIInd sdo_srid;
   struct sdo_point_type_ind sdo_point;
   OCIInd sdo_elem_info;
   OCIInd sdo_ordinates;
};
typedef struct sdo_geometry_ind sdo_geometry_ind;

struct sdo_dim_element
{
   OCIString * sdo_dimname;
   OCINumber sdo_lb;
   OCINumber sdo_ub;
   OCINumber sdo_tolerance;
};
typedef struct sdo_dim_element sdo_dim_element;

struct sdo_dim_element_ind
{
   OCIInd _atomic;
   OCIInd sdo_dimname;
   OCIInd sdo_lb;
   OCIInd sdo_ub;
   OCIInd sdo_tolerance;
};
typedef struct sdo_dim_element_ind sdo_dim_element_ind;

#endif // SDO_DATA_TYPES_H
