// Oracle SDO Geometry Object Cursor class -- Ran Wei, Oracle SDO, 9/10/1998
//
// Copyright 1998, Oracle Corp.

#ifndef SDO_GEOM_CURSOR_H
#define SDO_GEOM_CURSOR_H

#include <oci.h>
#include <ObjectCursor.h>
#include <SDOClientTypes.h>
#include <SDODataTypes.h>
#include <SDOMirrorTypes.h>

class AFX_EXT_CLASS SDOGeomCursor : public ObjectCursor
{
private:
	CSDODimArray* dimArray;

	BOOL CopyOrdinates(CSDOMirrorGeom* mirrorGeom, int nEIUnits, int startOffset, 
					   int thisIndex, int nextIndex, CSDOElement* elem);
	BOOL CopyItpr(CSDOMirrorGeom* mirrorGeom, int startOffset, int thisIndex, 
				  int nextIndex, CSDOElement* elem);
	BOOL ComputeElemMBR(CSDOElement* elem);
	BOOL ComputeArcMBR(CSDOPoint& pt1, CSDOPoint& pt2, CSDOPoint& pt3, 
					   CSDORect* arcMBR);
	short ThetaInArc(double tp, double t1, double t2, short dir);

public:
	static const double PI;
	static const double TWOPI;

	SDOGeomCursor(Connection* conn);

	// Bind object
	void BindGeomByPos(int pos, sdo_geometry** gObject, 
					   sdo_geometry_ind** gIndicator);
	void BindGeomByName(char* name, sdo_geometry** gObject, 
					    sdo_geometry_ind** gIndicator);

	// Define object
	void DefineGeomByPos(int pos, sdo_geometry** gObject, 
						 sdo_geometry_ind** gIndicator);

	// Convert SDO geometry object to/from client-side form
	// bTag = TRUE: Convert to point-only data;  FALSE: general data
	BOOL SDOTypeToClient(sdo_geometry* gObject, sdo_geometry_ind* gIndicator, 
						 CSDODimArray* dimArray, CSDOGeometry* geom);

	BOOL SDOTypeFromClient(CSDOGeometry* geom, BOOL bTag, CSDODimArray* dimArray, 
						   sdo_geometry** gObject, sdo_geometry_ind** gIndicator);

	// Convert SDO geometry object to/from mirror data format
	// CSDOMirrorGeom is mirror type for SDO geometry, it contains
	// native integer/double data members instead of Oracle Numbers
	BOOL SDOTypeToMirror(sdo_geometry* gObject, sdo_geometry_ind* gIndicator, 
						 CSDODimArray* dimArray, CSDOMirrorGeom* mirrorGeom,
						 CSDOMirrorGeomInd* mgIndicator);

	BOOL SDOTypeFromMirror(CSDOMirrorGeom* mirrorGeom, 
						   CSDOMirrorGeomInd* mgIndicator, 
						   CSDODimArray* dimArray, sdo_geometry** gObject, 
						   sdo_geometry_ind** gIndicator);

	// Convert SDO mirror data to/from client-side form
	// bTag = TRUE: Convert to point-only data;  FALSE: general data
	BOOL SDOMirrorToClient(CSDOMirrorGeom* mirrorGeom, 
						   CSDOMirrorGeomInd* mgIndicator,
						   CSDODimArray* dimArray, CSDOGeometry* geom);

	BOOL SDOMirrorFromClient(CSDOGeometry* geom, BOOL bTag, 
							 CSDODimArray* dimArray, CSDOMirrorGeom* mirrorGeom, 
							 CSDOMirrorGeomInd* mgIndicator);

	// Computational arc functions
	static BOOL ComputeArcCR(CSDOPoint& pt1, CSDOPoint& pt2, CSDOPoint& pt3, 
							 CSDOPoint* center, double* radius);

	static short ComputeArcTheta(CSDOPoint& pt1, CSDOPoint& pt2, CSDOPoint& pt3, 
								 CSDOPoint& center, double* t1, double* t2);
};

#endif // SDO_GEOM_CURSOR_H