// Oracle SDO Geometry Metadata Cursor class -- Ran Wei, Oracle SDO, 9/10/1998
//
// Copyright 1998, Oracle Corp.

#ifndef SDO_META_CURSOR_H
#define SDO_META_CURSOR_H

#include <oci.h>
#include <ObjectCursor.h>
#include <SDOClientTypes.h>
#include <SDODataTypes.h>

class AFX_EXT_CLASS SDOMetaCursor : public ObjectCursor
{
public:
	SDOMetaCursor(Connection* conn);

	// Bind object
	void BindMetaByPos(int pos, OCIArray** dArray, short** dIndicator);
	void BindMetaByName(char* name, OCIArray** dArray, short** dIndicator);

	// Define object
	void DefineMetaByPos(int pos, OCIArray** dArray, short** dIndicator);

	// Convert SDO dim array to client-side form
	BOOL SDOTypeToClient(OCIArray* dArray, short* dIndicator, 
						 CSDODimArray* dimArray);
};

#endif // SDO_META_CURSOR_H