// SDO Data Mirror Types -- Ran Wei, Oracle SDO, 9/10/1998
//
// Copyright 1998, Oracle Corp.
///////////////////////////////////////////////////////////////////////

#ifndef SDO_MIRROR_TYPES_H
#define SDO_MIRROR_TYPES_H

#ifndef OCI_ORACLE
#include <oci.h>
#endif

// CSDOMirrorPoint is mirror type for SDO point, it contains
// native floating-point data members instead of Oracle Numbers
class CSDOMirrorPoint
{
public:
	double x;
	double y;
	double z;

public:
	CSDOMirrorPoint() { x = y = z = 0.0; }

	CSDOMirrorPoint(const CSDOMirrorPoint& mirrorPoint) 
	{ 
		x = mirrorPoint.x;
		y = mirrorPoint.y;
		z = mirrorPoint.z;
	}

	CSDOMirrorPoint& operator =(const CSDOMirrorPoint& mirrorPoint) 
	{ 
		x = mirrorPoint.x;
		y = mirrorPoint.y;
		z = mirrorPoint.z;
		return *this;
	}
};

typedef sdo_point_type_ind CSDOMirrorPointInd;

typedef CArray<int, int> CSDOEInfoArray;
typedef CArray<double, double> CSDOOrdArray;

// CSDOMirrorGeom is mirror type for SDO geometry, it contains
// native floating-point data members instead of Oracle Numbers
class CSDOMirrorGeom
{
public:
	int sdo_gtype;
	int sdo_srid;
	CSDOMirrorPoint sdo_point;
	CSDOEInfoArray sdo_elem_info;
	CSDOOrdArray sdo_ordinates;

public:
	CSDOMirrorGeom() : sdo_point()
	{
		sdo_gtype = sdo_srid = 0;
		sdo_elem_info.SetSize(0);
		sdo_ordinates.SetSize(0);
	}

	CSDOMirrorGeom(const CSDOMirrorGeom& mirrorGeom)
	{
		sdo_gtype = mirrorGeom.sdo_gtype;
		sdo_srid = mirrorGeom.sdo_srid;
		sdo_point = mirrorGeom.sdo_point;
		sdo_elem_info.Copy(mirrorGeom.sdo_elem_info);
		sdo_ordinates.Copy(mirrorGeom.sdo_ordinates);
	}

	CSDOMirrorGeom& operator =(const CSDOMirrorGeom& mirrorGeom)
	{
		sdo_gtype = mirrorGeom.sdo_gtype;
		sdo_srid = mirrorGeom.sdo_srid;
		sdo_point = mirrorGeom.sdo_point;
		sdo_elem_info.Copy(mirrorGeom.sdo_elem_info);
		sdo_ordinates.Copy(mirrorGeom.sdo_ordinates);
		return *this;
	}
};

typedef sdo_geometry_ind CSDOMirrorGeomInd;

#endif // SDO_MIRROR_TYPES_H
