// SDOGraphicView.h : interface of the CSDOGraphicView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_SDOGRAPHIC_VIEW_H__87677D98_48C8_11D2_A083_0000F8BCC249__INCLUDED_)
#define AFX_SDOGRAPHIC_VIEW_H__87677D98_48C8_11D2_A083_0000F8BCC249__INCLUDED_

#include "VisualSDODoc.h"

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class CSDOGraphicView : public CView
{
protected: // create from serialization only
	CSDOGraphicView();
	DECLARE_DYNCREATE(CSDOGraphicView)

// Attributes
public:
	CVisualSDODoc* GetDocument();

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSDOGraphicView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void OnPrepareDC(CDC* pDC, CPrintInfo* pInfo = NULL);
	virtual void OnInitialUpdate();
	protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CSDOGraphicView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CSDOGraphicView)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnViewPan();
	afx_msg void OnUpdateViewPan(CCmdUI* pCmdUI);
	afx_msg void OnViewZoom();
	afx_msg void OnUpdateViewZoom(CCmdUI* pCmdUI);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnViewGotoOrigin();
	afx_msg void OnViewGotoGeometry();
	afx_msg void OnUpdateViewGotoOrigin(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewGotoGeometry(CCmdUI* pCmdUI);
	afx_msg void OnViewPointer();
	afx_msg void OnUpdateViewPointer(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:
	enum CursorType { POINTING = 0, ZOOMING = 1, PANNING = 2 };
	CursorType m_cursorType;
	CSDOPoint m_zoomCenter;
	double m_dZoomRatio, m_dInitialZoomRatio;
	CPoint m_oldMousePoint, m_pointOffset;
	HCURSOR hArrowCursor, hZoomCursor, hPanCursor0, hPanCursor1;

	inline int GetNewX(double x);
	inline int GetNewY(double y);
	void DrawMBR(CDC* pDC, CSDOGeometry& geom);
	void DrawPin(CDC* pDC, CSDOPoint& pt);
	void DrawPoint(CDC* pDC, CSDOPoint& pt);
	void DrawLine(CDC* pDC, CSDOPoint& pt1, CSDOPoint& pt2);
	void DrawArc(CDC* pDC, CSDOPoint& pt1, CSDOPoint& pt2, CSDOPoint& pt3);
	void DrawElement(CDC* pDC, CSDOElement& elem, int nFlag);
	void CSDOGraphicView::PrintPageHeader(CDC * pDC);
	void CSDOGraphicView::PrintPageFooter(CDC * pDC);

public:
	enum { NORMAL_GEOM = 0, HIGHLIGHTED_GEOM = 1 };
	enum { AXIS_COLOR = 0x00CCCCCC, 
		   MBR_COLOR = 0x00CC2222, PIN_COLOR = 0x0022CC22,
		   NORMAL_COLOR = 0x00DDDDCC, HIGHLIGHTED_COLOR = 0x004444DD };
	BOOL IsZooming() { return (m_cursorType == ZOOMING); }
	void DrawGeometry(CDC* pDC, CSDOGeometry& geom, int nFlag);
};

#ifndef _DEBUG  // debug version in SDOGraphicView.cpp
inline CVisualSDODoc* CSDOGraphicView::GetDocument()
   { return (CVisualSDODoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SDOGRAPHIC_VIEW_H__87677D98_48C8_11D2_A083_0000F8BCC249__INCLUDED_)
