// SDOTextView.cpp : implementation of the CSDOTextView class
// -- Ran Wei, Oracle SDO, 9/10/1998
//
// Copyright 1998, Oracle Corp.

#include "stdafx.h"
#include "MainFrm.h"
#include "VisualSDO.h"
#include "SDOGraphicView.h"
#include "SDOTextView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSDOTextView

IMPLEMENT_DYNCREATE(CSDOTextView, CView)

BEGIN_MESSAGE_MAP(CSDOTextView, CView)
	//{{AFX_MSG_MAP(CSDOTextView)
	ON_WM_CREATE()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSDOTextView construction/destruction

CSDOTextView::CSDOTextView()
{
}

CSDOTextView::~CSDOTextView()
{
}

BOOL CSDOTextView::PreCreateWindow(CREATESTRUCT& cs)
{
	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CSDOTextView drawing

void CSDOTextView::OnDraw(CDC* pDC)
{
	CVisualSDODoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here
	CSDOGeomArray* geomArray = pDoc->GetGeomArray();
	CStringArray* strArray = pDoc->GetStringArray();
	int m_nGeomIndex = pDoc->GetGeomIndex();
	if (m_nGeomIndex >= 0 && m_nGeomIndex < geomArray->GetSize())
	{
		// Output geometry description for the high-lighted geometry
		CSDOGeometry* geom = &((*geomArray)[m_nGeomIndex]);
		CString str = (*strArray)[m_nGeomIndex];
		m_rich.SetWindowText(str);

		SDOGeomCursor geomCursor(pDoc->GetConnection());
		CSDOMirrorGeom mirrorGeom;
		CSDOMirrorGeomInd mgIndicator;

		// Open a geometry cursor for conversion
		try
		{
			geomCursor.Open();

			// Convert client-side form into SDO mirror geometry object 
			CSDODimArray* dimArray = &(pDoc->GetSelectedMeta()->m_dimArray);
			if (!geomCursor.SDOMirrorFromClient(geom, FALSE, dimArray, 
												&mirrorGeom, &mgIndicator))
				return;

			str += "\n" + GetMirrorGeomString(mirrorGeom, mgIndicator); 
			m_rich.SetWindowText(str);

			geomCursor.Close();
		}
		catch (CCursorGeneralException* e)
		{
			e->Delete();
			return;
		}
	}
	else
	{
		if (pDoc->GetConnection()->IsConnected())
			m_rich.SetWindowText("No geometry in memory. Press '+' button "
								 "to add geometry.");
		else
			m_rich.SetWindowText("Not connected. Press 'C' button to connect.");
	}
}

/////////////////////////////////////////////////////////////////////////////
// CSDOTextView printing

BOOL CSDOTextView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CSDOTextView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CSDOTextView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CSDOTextView diagnostics

#ifdef _DEBUG
void CSDOTextView::AssertValid() const
{
	CView::AssertValid();
}

void CSDOTextView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CVisualSDODoc* CSDOTextView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CVisualSDODoc)));
	return (CVisualSDODoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSDOTextView helper functions

CString CSDOTextView::GetMirrorGeomString(CSDOMirrorGeom& mirrorGeom,
										  CSDOMirrorGeomInd& mgIndicator)
{
	CString str = "MDSYS.SDO_GEOMETRY(";
	CString tempStr;

	if (mgIndicator._atomic == OCI_IND_NULL)
		return str + ")";

	// Now compose a string for this geometry
	// GTYPE
	if (mgIndicator.sdo_gtype == OCI_IND_NULL)
		tempStr = "NULL";
	else
		tempStr.Format("%d", mirrorGeom.sdo_gtype);
	str += tempStr + ", ";

	// Point data
	if (mgIndicator.sdo_point._atomic == OCI_IND_NULL)
		tempStr = "NULL";
	else
	{
		CString xStr, yStr, zStr;
		if (mgIndicator.sdo_point.x == OCI_IND_NULL)
			xStr = "NULL";
		else
			xStr.Format("%lf", mirrorGeom.sdo_point.x);

		if (mgIndicator.sdo_point.y == OCI_IND_NULL)
			yStr = "NULL";
		else
			yStr.Format("%lf", mirrorGeom.sdo_point.y);

		if (mgIndicator.sdo_point.z == OCI_IND_NULL)
			zStr = "NULL";
		else
			zStr.Format("%lf", mirrorGeom.sdo_point.z);

		tempStr = "MDSYS.SDO_POINT_TYPE(" + xStr + ", " + 
			yStr + ", " + zStr + ")"; 
	}
	str += tempStr + ", ";

	// Element info array
	if (mgIndicator.sdo_elem_info == OCI_IND_NULL)
		tempStr = "NULL";
	else
	{
		CString infoStr;
		tempStr = "MDSYS.SDO_ELEM_INFO_ARRAY(";
		for (int i = 0; i < mirrorGeom.sdo_elem_info.GetSize(); i++)
		{
			infoStr.Format("%d", mirrorGeom.sdo_elem_info[i]);
			if (i == 0)
				tempStr += infoStr;
			else
				tempStr += ", " + infoStr;
		}
		tempStr += ")";
	}
	str += tempStr + ", ";

	// Ordinate array
	if (mgIndicator.sdo_ordinates == OCI_IND_NULL)
		tempStr = "NULL";
	else
	{
		CString ordStr;
		tempStr = "MDSYS.SDO_ORDINATE_ARRAY(";
		for (int i = 0; i < mirrorGeom.sdo_ordinates.GetSize(); i++)
		{
			ordStr.Format("%lf", mirrorGeom.sdo_ordinates[i]);
			if (i == 0)
				tempStr += ordStr;
			else
				tempStr += ", " + ordStr;
		}
		tempStr += ")";
	}
	str += tempStr;

	return str + ")";
}

/////////////////////////////////////////////////////////////////////////////
// CSDOTextView message handlers

void CSDOTextView::OnInitialUpdate() 
{
	CView::OnInitialUpdate();
	
	// TODO: Add your specialized code here and/or call the base class
	CHARFORMAT cf;
	cf.cbSize = 10;
	//cf.dwMask = CFM_COLOR | CFM_FACE | CFM_SIZE;
	cf.dwEffects = 0;
	cf.crTextColor = RGB(40, 40, 190);
	strcpy(cf.szFaceName, "Courier New");
	m_rich.SetDefaultCharFormat(cf);
}

int CSDOTextView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	CRect rect(0, 0, 0, 0);
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;
	m_rich.Create(ES_AUTOVSCROLL | ES_MULTILINE | ES_WANTRETURN |
				  WS_CHILD | WS_VISIBLE | WS_VSCROLL, rect, this, 1);
	return 0;
}

void CSDOTextView::OnSize(UINT nType, int cx, int cy) 
{
	CRect rect;
	CView::OnSize(nType, cx, cy);
	GetClientRect(rect);
	m_rich.SetWindowPos(&wndTop, 0, 0, rect.right - rect.left,
						rect.bottom - rect.top, SWP_SHOWWINDOW);
}
