// SDOTextView.h : interface of the CSDOTextView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_SDOTEXT_VIEW_H__87677D98_48C8_11D2_A083_0000F8BCC249__INCLUDED_)
#define AFX_SDOTEXT_VIEW_H__87677D98_48C8_11D2_A083_0000F8BCC249__INCLUDED_

#include "VisualSDODoc.h"
#include <SDOMirrorTypes.h>

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class CSDOTextView : public CView
{
protected: // create from serialization only
	CSDOTextView();
	DECLARE_DYNCREATE(CSDOTextView)

// Attributes
public:
	CVisualSDODoc* GetDocument();

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSDOTextView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void OnInitialUpdate();
	protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CSDOTextView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CSDOTextView)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

public:
	CRichEditCtrl m_rich;
	CString GetMirrorGeomString(CSDOMirrorGeom& mirrorGeom,
								CSDOMirrorGeomInd& mgIndicator);
};

#ifndef _DEBUG  // debug version in SDOTextView.cpp
inline CVisualSDODoc* CSDOTextView::GetDocument()
   { return (CVisualSDODoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SDOTEXT_VIEW_H__87677D98_48C8_11D2_A083_0000F8BCC249__INCLUDED_)
