// VisualSDODoc.cpp : implementation of the CVisualSDODoc class
// -- Ran Wei, Oracle SDO, 9/10/1998
//
// Copyright 1998, Oracle Corp.

#include "stdafx.h"
#include "VisualSDO.h"
#include "MainFrm.h"
#include "ChildFrm.h"

#include "ConnectDlg.h"
#include "VisualSDODoc.h"
#include "GeomTablesDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CVisualSDODoc

IMPLEMENT_DYNCREATE(CVisualSDODoc, CDocument)

BEGIN_MESSAGE_MAP(CVisualSDODoc, CDocument)
	//{{AFX_MSG_MAP(CVisualSDODoc)
	ON_COMMAND(ID_FILE_CONNECT, OnFileConnect)
	ON_UPDATE_COMMAND_UI(ID_FILE_CONNECT, OnUpdateFileConnect)
	ON_COMMAND(ID_FILE_DISCONNECT, OnFileDisconnect)
	ON_UPDATE_COMMAND_UI(ID_FILE_DISCONNECT, OnUpdateFileDisconnect)
	ON_COMMAND(ID_EDIT_DELETE, OnEditDelete)
	ON_UPDATE_COMMAND_UI(ID_EDIT_DELETE, OnUpdateEditDelete)
	ON_COMMAND(ID_EDIT_FIRST, OnEditFirst)
	ON_UPDATE_COMMAND_UI(ID_EDIT_FIRST, OnUpdateEditFirst)
	ON_COMMAND(ID_EDIT_LAST, OnEditLast)
	ON_UPDATE_COMMAND_UI(ID_EDIT_LAST, OnUpdateEditLast)
	ON_COMMAND(ID_EDIT_NEXT, OnEditNext)
	ON_UPDATE_COMMAND_UI(ID_EDIT_NEXT, OnUpdateEditNext)
	ON_COMMAND(ID_EDIT_PREVIOUS, OnEditPrevious)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PREVIOUS, OnUpdateEditPrevious)
	ON_COMMAND(ID_EDIT_INSERT, OnEditInsert)
	ON_UPDATE_COMMAND_UI(ID_EDIT_INSERT, OnUpdateEditInsert)
	ON_COMMAND(ID_EDIT_DELETE_ALL, OnEditDeleteAll)
	ON_COMMAND(ID_FILE_SAVE, OnFileSave)
	ON_COMMAND(ID_FILE_SAVE_AS, OnFileSaveAs)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	ON_UPDATE_COMMAND_UI(ID_EDIT_COPY, OnUpdateEditCopy)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVisualSDODoc construction/destruction

CVisualSDODoc::CVisualSDODoc()
{
	conn = new Connection;
	m_strTitle = "";
	m_geomMetaArray.SetSize(0);
	m_nSelected = -1;   // No item selected
	m_nGeomIndex = 0;
	OnFileConnect();
}

CVisualSDODoc::~CVisualSDODoc()
{
	delete conn;
}

BOOL CVisualSDODoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CVisualSDODoc serialization

void CVisualSDODoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// CVisualSDODoc diagnostics

#ifdef _DEBUG
void CVisualSDODoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CVisualSDODoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// Helper functions

// Query for SDO geometry metadata
BOOL CVisualSDODoc::QueryMetadata()
{
	SDOMetaCursor metaCursor(conn);
	CString stmt = "SELECT table_name, column_name, diminfo "
				   "FROM sdo_geom_metadata";
	char tName[64], cName[64];
	OCIArray* dArray = NULL;
	short tIndicator, cIndicator;
	short* dIndicator = NULL;

	// Query for geometry metadata
	try 
	{
		metaCursor.Open();
		metaCursor.Prepare(stmt);

		metaCursor.DefineByPos(1, &tName, sizeof(tName), (void*)&tIndicator, 
							   SQLT_STR);
		metaCursor.DefineByPos(2, &cName, sizeof(cName), (void*)&cIndicator, 
							   SQLT_STR);
		metaCursor.DefineMetaByPos(3, &dArray, &dIndicator);

		metaCursor.Execute(1);

		// Store geometry metadata into a local array
		m_geomMetaArray.RemoveAll();
		while (TRUE) 
		{
			// Convert dim array into client-side form
			CSDODimArray dimArray;
			if (!metaCursor.SDOTypeToClient(dArray, dIndicator, &dimArray))
			{
				AfxMessageBox("Unable to convert Dimension Array for client");
				return FALSE;
			}
			m_geomMetaArray.Add(CSDOGeomMeta(tName, cName, dimArray));
			try
			{
				metaCursor.Fetch(1);
			}

			catch (CCursorDataException* e)		// Fetch till no more data 
			{
				e->Delete();
				break;
			}
		}

		metaCursor.Close();
	}
	catch (CCursorGeneralException* e)
	{
		e->Delete();
		metaCursor.Close();
		return FALSE;
	}

	return TRUE;
}

// Query for SDO geometry object
BOOL CVisualSDODoc::QueryGeomObject(CString stmt)
{
	SDOGeomCursor geomCursor(conn);
	sdo_geometry* gObject = NULL;
	sdo_geometry_ind* gIndicator = NULL;

	// Query for geometry metadata
	try 
	{
		geomCursor.Open();
		geomCursor.Prepare(stmt);

		geomCursor.DefineGeomByPos(1, &gObject, &gIndicator);

		geomCursor.Execute(1);

		while (TRUE) 
		{
			CSDOGeometry geom;
			CSDODimArray* dimArray = &(GetSelectedMeta()->m_dimArray);

			// Convert SDO geometry object into client-side form
			if (!geomCursor.SDOTypeToClient(gObject, gIndicator, dimArray, &geom))
			{
				geomCursor.ReleaseObject(gObject);
				return FALSE;
			}

			if (m_geomArray.GetSize() > 0)
				m_nGeomIndex++;
			m_geomArray.InsertAt(m_nGeomIndex, geom);

			geomCursor.ReleaseObject(gObject);
			// Must set gObject to NULL
			gObject = NULL;    
			try
			{
				geomCursor.Fetch(1);
			}
			catch (CCursorDataException* e)		// Fetch till no more data 
			{
				e->Delete();
				break;
			}
		}

		geomCursor.Close();
	}
	catch (CCursorGeneralException* e)
	{
		e->Delete();
		geomCursor.Close();
		return FALSE;
	}

	return TRUE;
}

// Get selected index of table/column name list
int CVisualSDODoc::GetSelectedIndex()
{
	if (m_nSelected < 0 || m_nSelected >= m_geomMetaArray.GetSize())
		return -1;
	else
		return m_nSelected;
}

// Get selected item of table/column name list
CSDOGeomMeta* CVisualSDODoc::GetSelectedMeta()
{
	if (m_nSelected < 0 || m_nSelected >= m_geomMetaArray.GetSize())
		return NULL;
	else
		return &m_geomMetaArray[m_nSelected];
}

// Compose a geometry object query statement
CString CVisualSDODoc::GetGeomQueryStmt()
{
	CString stmt;
	CSDOGeomMeta* geomMeta = GetSelectedMeta();
	BOOL bIsNumber = (m_strKeyType.Compare("NUMBER") == 0);

	if (geomMeta != NULL)
	{
		stmt = "SELECT " + geomMeta->m_strColumnName + 
			   " FROM " + geomMeta->m_strTableName;
		if (!m_strKeyName.IsEmpty() && !m_strKeyValue.IsEmpty())
		{
			stmt += " WHERE " + m_strKeyName + " = ";
			if (bIsNumber)
				stmt += m_strKeyValue;
			else
				stmt += "'" + m_strKeyValue + "'";
		}
	}

	return stmt;
}

/////////////////////////////////////////////////////////////////////////////
// CVisualSDODoc commands

// Connect to Oracle database
void CVisualSDODoc::OnFileConnect() 
{
	CConnectDlg connectDlg;
	connectDlg.SetConnection(conn);
	connectDlg.DoModal();
	if (conn->IsConnected())
	{
		// Set window frame title
		m_strTitle = connectDlg.m_strUsername + "@";
		if (!connectDlg.m_strDatabase.IsEmpty())
			m_strTitle += connectDlg.m_strDatabase;
		else
			m_strTitle += "local host";
		TRACE("Current user: " + m_strTitle + "\n");

		// Query for geometry metadata
		if (!QueryMetadata())
			AfxMessageBox("Geometry metadata missing!");
	}
	else
	{
		AfxMessageBox("Failed to connect.\n"
					  "Please check your network/listener "
					  "configuaration and try again later!");
	}
}

void CVisualSDODoc::OnUpdateFileConnect(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!conn->IsConnected());	
}

// Disconnect from Oracle database
void CVisualSDODoc::OnFileDisconnect() 
{
	conn->Disconnect();
	CDocument::OnCloseDocument();
}

void CVisualSDODoc::OnUpdateFileDisconnect(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(conn->IsConnected());
}

// Set window title
void CVisualSDODoc::SetTitle(LPCTSTR lpszTitle) 
{
	CString strTitle = "DEMO Visualizer for user: " + m_strTitle;
	lpszTitle = strTitle;

	CDocument::SetTitle(lpszTitle);
}

// Insert geometry or geometries
void CVisualSDODoc::OnEditInsert() 
{
	if (m_nGeomIndex < 0)
		return;

	// Get geometry table name, column name and gid, etc.
	CGeomTablesDlg dlg;
	dlg.SetConnection(conn);
	dlg.SetGeomMetaArray(m_geomMetaArray);
	dlg.SetSelectedIndex(m_nSelected);
	if (dlg.DoModal() == IDCANCEL)
		return;

	m_nSelected = dlg.GetSelectedIndex();
	m_strKeyName = dlg.m_strKeyName;
	m_strKeyType = dlg.m_strKeyType;
	m_strKeyValue = dlg.m_strValue;

	CString stmt = GetGeomQueryStmt();
	// Insert geometry and a description string
	BeginWaitCursor();
	if (QueryGeomObject(stmt))
	{
		// Compose a geometry description string
		CString geomDesc;
		CSDOGeomMeta* geomMeta = GetSelectedMeta();
		if (geomMeta != NULL)
		{
			geomDesc = geomMeta->m_strTableName + " : " + geomMeta->m_strColumnName;
			if (!m_strKeyName.IsEmpty() && !m_strKeyValue.IsEmpty())
				geomDesc += " : " + m_strKeyValue;
		}
		m_strArray.InsertAt(m_nGeomIndex, geomDesc);

		UpdateAllViews(NULL);
	}
	else
		AfxMessageBox("Failed to query SDO geometry object");
	EndWaitCursor();
}

void CVisualSDODoc::OnUpdateEditInsert(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(conn->IsConnected());
}

// Delete current geometry in memory
void CVisualSDODoc::OnEditDelete() 
{
	if (m_nGeomIndex >= 0 && m_nGeomIndex < m_geomArray.GetSize())
	{
		m_geomArray.RemoveAt(m_nGeomIndex);
		m_strArray.RemoveAt(m_nGeomIndex);
	}
	if (m_nGeomIndex > 0)
		m_nGeomIndex--;

	UpdateAllViews(NULL);
}

void CVisualSDODoc::OnUpdateEditDelete(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_geomArray.GetSize() > 0);
}

// Delete all geometries in memory
void CVisualSDODoc::OnEditDeleteAll() 
{
	m_geomArray.RemoveAll();
	m_strArray.RemoveAll();
	m_nGeomIndex = 0;

	UpdateAllViews(NULL);
}

// Goto the first geometry
void CVisualSDODoc::OnEditFirst() 
{
	m_nGeomIndex = 0;
	UpdateAllViews(NULL);
}

void CVisualSDODoc::OnUpdateEditFirst(CCmdUI* pCmdUI) 
{
	int count = m_geomArray.GetSize();
	pCmdUI->Enable(count > 0 && m_nGeomIndex > 0);		
}

// Goto the last geometry
void CVisualSDODoc::OnEditLast() 
{
	m_nGeomIndex = m_geomArray.GetUpperBound();
	UpdateAllViews(NULL);
}

void CVisualSDODoc::OnUpdateEditLast(CCmdUI* pCmdUI) 
{
	int count = m_geomArray.GetSize();
	pCmdUI->Enable(count > 0 && m_nGeomIndex < count - 1);	
}

// Goto the next geometry
void CVisualSDODoc::OnEditNext() 
{
	m_nGeomIndex++;
	UpdateAllViews(NULL);
}

void CVisualSDODoc::OnUpdateEditNext(CCmdUI* pCmdUI) 
{
	int count = m_geomArray.GetSize();
	pCmdUI->Enable(count > 0 && m_nGeomIndex < count - 1);		
}

// Goto the previous geometry
void CVisualSDODoc::OnEditPrevious() 
{
	m_nGeomIndex--;
	UpdateAllViews(NULL);
}

void CVisualSDODoc::OnUpdateEditPrevious(CCmdUI* pCmdUI) 
{
	int count = m_geomArray.GetSize();
	pCmdUI->Enable(count > 0 && m_nGeomIndex > 0);		
}

void CVisualSDODoc::OnFileSave() 
{
	AfxMessageBox("Saving not implemented in this demo");
}

void CVisualSDODoc::OnFileSaveAs() 
{
	AfxMessageBox("Saving not implemented in this demo");
}

void CVisualSDODoc::OnFileOpen() 
{
	AfxMessageBox("Loading not implemented in this demo");
}

void CVisualSDODoc::OnEditCopy() 
{
	// Copy SDO geometry string to the clipboard
	CMainFrame* pMain = (CMainFrame*) AfxGetApp()->m_pMainWnd;
	CChildFrame* pChild = (CChildFrame*) pMain->MDIGetActive();
	CSDOTextView* activeView = pChild->GetSDOTextView();
	CRichEditCtrl* richEdit = &(activeView->m_rich);
	richEdit->Copy();
}

void CVisualSDODoc::OnUpdateEditCopy(CCmdUI* pCmdUI) 
{
	long nStart, nEnd;

	CMainFrame* pMain = (CMainFrame*) AfxGetApp()->m_pMainWnd;
	CChildFrame* pChild = (CChildFrame*) pMain->MDIGetActive();
	CSDOTextView* activeView = pChild->GetSDOTextView();
	CRichEditCtrl* richEdit = &(activeView->m_rich);
	richEdit->GetSel(nStart, nEnd);
	TRACE("Selection: %ld -- %ld\n", nStart, nEnd);
	pCmdUI->Enable(nEnd > nStart);
}

