// VisualSDODoc.h : interface of the CVisualSDODoc class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_VISUALSDODOC_H__87677D96_48C8_11D2_A083_0000F8BCC249__INCLUDED_)
#define AFX_VISUALSDODOC_H__87677D96_48C8_11D2_A083_0000F8BCC249__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include <Connect.h>
#include <SDOMetaCursor.h>
#include <SDOGeomCursor.h>
#include <SDOClientTypes.h>
#include <SDODataTypes.h>

class CVisualSDODoc : public CDocument
{
protected: // create from serialization only
	CVisualSDODoc();
	DECLARE_DYNCREATE(CVisualSDODoc)

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CVisualSDODoc)
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	virtual void SetTitle(LPCTSTR lpszTitle);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CVisualSDODoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CVisualSDODoc)
	afx_msg void OnFileConnect();
	afx_msg void OnUpdateFileConnect(CCmdUI* pCmdUI);
	afx_msg void OnFileDisconnect();
	afx_msg void OnUpdateFileDisconnect(CCmdUI* pCmdUI);
	afx_msg void OnEditDelete();
	afx_msg void OnUpdateEditDelete(CCmdUI* pCmdUI);
	afx_msg void OnEditFirst();
	afx_msg void OnUpdateEditFirst(CCmdUI* pCmdUI);
	afx_msg void OnEditLast();
	afx_msg void OnUpdateEditLast(CCmdUI* pCmdUI);
	afx_msg void OnEditNext();
	afx_msg void OnUpdateEditNext(CCmdUI* pCmdUI);
	afx_msg void OnEditPrevious();
	afx_msg void OnUpdateEditPrevious(CCmdUI* pCmdUI);
	afx_msg void OnEditInsert();
	afx_msg void OnUpdateEditInsert(CCmdUI* pCmdUI);
	afx_msg void OnEditDeleteAll();
	afx_msg void OnFileSave();
	afx_msg void OnFileSaveAs();
	afx_msg void OnFileOpen();
	afx_msg void OnEditCopy();
	afx_msg void OnUpdateEditCopy(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:
	Connection* conn;
	CString m_strTitle;
	CSDOGeomMetaArray m_geomMetaArray;
	int m_nSelected;
	CString m_strKeyName, m_strKeyType, m_strKeyValue;
	CSDOGeomArray m_geomArray;			// geometry array
	CStringArray m_strArray;			// geometry string array
	int m_nGeomIndex;

private:
	BOOL QueryMetadata();
	BOOL QueryGeomObject(CString stmt);

public:
	Connection* GetConnection() { return conn; }
	int GetSelectedIndex();
	CSDOGeomMeta* GetSelectedMeta();
	CString GetGeomQueryStmt();
	CSDOGeomArray* GetGeomArray() { return &m_geomArray; }
	CStringArray* GetStringArray() { return &m_strArray; }
	int GetGeomIndex() { return m_nGeomIndex; }
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_VISUALSDODOC_H__87677D96_48C8_11D2_A083_0000F8BCC249__INCLUDED_)
