/* generated by Jasper  from ForEachClass.jsl */

package oracle.jaccelerator.server;

import oracle.aurora.rdbms.ClassHandle;
import oracle.jaccelerator.server.PackageValidateAll;
import java.lang.String;
import oracle.jaccelerator.server.ClassProcessor;
import oracle.aurora.rdbms.Schema;
import oracle.jaccelerator.server.ForEachClass;
import java.sql.Connection;
import oracle.jaccelerator.server.PackageDisableNcomp;
import oracle.aurora.rdbms.Handle;
import java.lang.Exception;

import oracle.sql.*;
import java.io.*;
import oracle.jaccelerator.server.*;
import oracle.jdbc.driver.*;
import java.sql.*;
import java.lang.*;
import java.util.*;


public class ForEachClass {
 
 public static String from_plsql (String processorName,
                                  String packageNamePattern,
                                  String schema)
 {
  ClassProcessor processor = null;
  
  try {
   Class clazz = Class.forName
    ("oracle.jaccelerator.server." + processorName);
   processor =
    ((ClassProcessor)clazz.newInstance()).init(packageNamePattern,
                                               schema);
  } catch (ClassNotFoundException ex) {
   return "class oracle.jaccelerator.server." + processorName + " not found";
  } catch (Exception ex2) {
   return
    "can not instantiate class oracle.jaccelerator.server." + processorName;
  }
  
  int count =
   ForEachClass.inPackage(packageNamePattern, schema).apply(processor);
  return "processed total: " + count + " classes";
 }
 
 public static ForEachClass inPackage (String packageName, String schema)
 {
  return new ForEachClass(packageName, schema);
 }
 Connection connection;
 
 int counter = 0;
 String packageNamePattern;
 String schema;
 
 public ForEachClass (String packageNamePattern, String schema)
 {
  this.packageNamePattern = packageNamePattern.replace('.', '/');
  this.schema = schema;
 }
 
 public int apply (ClassProcessor processor)
 {
  try {
   OracleDriver driver = new OracleDriver();
   connection = driver.defaultConnection();
   doit(processor);
  } catch (Exception e) {
   e.printStackTrace();
  }
  finally {
   if (connection != null)  {
   }
  }
  
  return counter;
 }
 
 void cleanup (Connection connection)
 {
 }
 
 public void doit (ClassProcessor processor)
  throws java.lang.Exception
 {
  cleanup(connection);
  Statement stmt = connection.createStatement();
  
  try {
   String cmd;
   
   cmd =
    "select dbms_java.longname(OBJECT_NAME) " +
    "from user_objects " +
    "where OBJECT_TYPE = 'JAVA CLASS' and " +
    "dbms_java.longname(OBJECT_NAME) like '" +
    packageNamePattern +
    "/%' " +
    "and dbms_java.longname(OBJECT_NAME) not like '" +
    packageNamePattern +
    "/%/%'";
   
   ResultSet rset = stmt.executeQuery(cmd);
   
   while (rset.next()) {
    String className = rset.getString(1);
    processor.execute(className);
    counter++;
   }
  } catch (Exception e) {
   System.out.println(" got error   " + e);
  }
  finally {
   if (stmt != null) stmt.close();
  }
 }
}
