Rem
Rem $Header: ctxpatch.sql 17-may-2006.10:16:51 surman Exp $
Rem
Rem ctxpatch.sql
Rem
Rem Copyright (c) 2002, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ctxpatch.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    surman      05/17/06 - Backport surman_bug-5170265 from st_ctx_9.2.0 
Rem    surman      03/10/06 - Remove INSO output_formatting 
Rem    surman      04/07/05 - 4285926: Fix syntax error 
Rem    evarghes    02/17/05 - keyview html export release 8.0.0 
Rem    surman      10/11/04 - 3881987: Check before insert 
Rem    druthven    09/30/03 - druthven_bug-3156134
Rem    gkaminag    08/15/02 - ctx_version back to dr0plb
Rem    gkaminag    07/16/02 - gkaminag_bug-2437798
Rem    gkaminag    07/16/02 - Created
Rem

SET FEEDBACK OFF

REM The assumption is that this script is run as SYS

REM this statement is needed in case the previous CTX install was
REM done as CTXSYS
REM 5170265: Ignore ORA-942 ora ORA-1031 errors (possible if ctxpatch is 
REM called during upgrades from 8.1.7 or 9.0.1)
begin
  execute immediate
    'update sys.registry$ set invoker#=0 where cid = ''CONTEXT''';
  commit;
exception
  when others then null;
end;
/

ALTER SESSION SET CURRENT_SCHEMA = CTXSYS;
EXECUTE dbms_registry.loading('CONTEXT', 'Oracle Text');

@@dr0pkh.sql
@@dr0plb.sql
@@dr0type.plb
@@dr0typec.plb
@@dr0typer.plb
@@dr0typex.plb

REM attempt to revalidate any invalid CTXSYS objects

declare
  cbody varchar2(10);
  otype varchar2(30);
begin
  for c1 in (select object_type, object_name 
             from dba_objects 
             where status = 'INVALID'
               and owner = 'CTXSYS'
             order by object_type) 
  loop
    otype := c1.object_type;
    cbody := null;

    if (c1.object_type = 'PACKAGE BODY') then
      otype := 'PACKAGE';
      cbody := 'BODY';
    elsif (c1.object_type = 'TYPE BODY') then
      otype := 'TYPE';
      cbody := 'BODY';
    elsif (c1.object_type = 'VIEW') then
      cbody := 'BODY';
    end if;
    
    begin
      execute immediate 
        'alter '||otype||' CTXSYS.'||c1.object_name||' compile '||cbody;
    exception
       when others then null;
    end;
  end loop;
end;
/

REM ========================================================================
REM AUTO_FILTER
REM ========================================================================

REM Trap ORA-00001 error which will be raised when upgrading from
REM or 9.0.1.5+.  AUTO_FILTER might be backported for inclusion in
REM 9.0.1.5.

begin
insert into dr$object values
  (4, 8, 'AUTO_FILTER', 'filter for binary document formats', 'N');

insert into dr$object_attribute values
  (40802, 4, 8, 2,
   'TIMEOUT', 'Polling interval in seconds to terminate by force',
   'N', 'N', 'Y', 'I',
   '120', 0, 42949672, 'N');

insert into dr$object_attribute values
  (40803, 4, 8, 3,
   'TIMEOUT_TYPE', 'Time-out type',
   'N', 'N', 'Y', 'I',
   'HEURISTIC', null, null, 'Y');

insert into dr$object_attribute_lov values
  (40803, 'HEURISTIC', 1, 'Heuristic');

insert into dr$object_attribute_lov values
  (40803, 'FIXED', 2, 'Fixed');

insert into dr$object_attribute values
  (40804, 4, 8, 4, 
   'OUTPUT_FORMATTING', 'formatted output',
   'N', 'N', 'Y', 'B', 
   'TRUE', null, null, 'N');

-- ========================================================================
-- CTXSYS.AUTO_FILTER DEFAULT PREFERENCE
-- ========================================================================

declare
 l_owner# number;
 l_pre_id number;
 l_obj_id number;
 l_cla_id number;
begin
 select user# into l_owner# from sys.user$ where name = 'CTXSYS';
 select dr_id_seq.nextval into l_pre_id from dual;
 select obj_id, obj_cla_id into l_obj_id, l_cla_id from dr$object
  where obj_name = 'AUTO_FILTER';
 insert into dr$preference
   (pre_id, pre_name, pre_owner#, pre_obj_id, pre_cla_id, pre_valid)
    values
   (l_pre_id, 'AUTO_FILTER', l_owner#, l_obj_id, l_cla_id, 'Y');

 commit;
end;

exception
when dup_val_on_index then
  null;
end;
/

commit;

-- Bug 5087879: Remove OUTPUT_FORMATTING attribute for INSO filter
delete from dr$object_attribute
  where oat_id = 40504;

commit;


REM registry to loaded

declare
  ver varchar2(80);
begin
  select ver_dict into ver from ctx_version;
  dbms_registry.loaded('CONTEXT', ver, 
                       'Oracle Text Release '||ver||' - Production');

  -- to do: a validation procedure
  dbms_registry.valid('CONTEXT');
end;
/

declare
  dummy varchar2(1);
begin
  select 'a'
    into dummy
    from dr$object_attribute
    where oat_id = 60121;
exception
  when no_data_found then
    -- 3881987: Only insert if not already present
    insert into dr$object_attribute values
      (60121, 6, 1, 21, 'OVERRIDE_BASE_LETTER',
       'Alternate Spelling override Base Letter for umlauts',
       'N', 'N', 'Y', 'B',
       'FALSE', null, null, 'N');
    commit;
end;
/

ALTER SESSION SET CURRENT_SCHEMA = SYS;
