Rem
Rem $Header: ctxrelod.sql 15-apr-2003.13:55:05 gkaminag Exp $
Rem
Rem ctxrelod.sql
Rem
Rem Copyright (c) 2002, 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      ctxrelod.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gkaminag    04/15/03 - run dr0ulib
Rem    gkaminag    07/16/02 - gkaminag_bug-2437798
Rem    gkaminag    07/16/02 - Created
Rem

SET FEEDBACK OFF

REM The assumption is that this script is run as SYS

REM this statement is needed in case the previous CTX install was
REM done as CTXSYS
update sys.registry$ set invoker#=0 where cid = 'CONTEXT';
commit;

ALTER SESSION SET CURRENT_SCHEMA = CTXSYS;
EXECUTE dbms_registry.loading('CONTEXT', 'Oracle Text');

@@dr0ulib.sql
@@dr0pkh.sql
@@dr0plb.sql
@@dr0type.plb
@@dr0typec.plb
@@dr0typer.plb
@@dr0typex.plb

REM attempt to revalidate any invalid CTXSYS objects

declare
  cbody varchar2(10);
  otype varchar2(30);
begin
  for c1 in (select object_type, object_name 
             from dba_objects 
             where status = 'INVALID'
               and owner = 'CTXSYS'
             order by object_type) 
  loop
    otype := c1.object_type;
    cbody := null;

    if (c1.object_type = 'PACKAGE BODY') then
      otype := 'PACKAGE';
      cbody := 'BODY';
    elsif (c1.object_type = 'TYPE BODY') then
      otype := 'TYPE';
      cbody := 'BODY';
    elsif (c1.object_type = 'VIEW') then
      cbody := 'BODY';
    end if;
    
    begin
      execute immediate 
        'alter '||otype||' CTXSYS.'||c1.object_name||' compile '||cbody;
    exception
       when others then null;
    end;
  end loop;
end;
/

REM registry to loaded

declare
  ver varchar2(80);
begin
  select ver_dict into ver from ctx_version;
  dbms_registry.loaded('CONTEXT', ver, 
                       'Oracle Text Release '||ver||' - Production');

  -- to do: a validation procedure
  dbms_registry.valid('CONTEXT');
end;
/

ALTER SESSION SET CURRENT_SCHEMA = SYS;
