Rem
Rem Copyright (c) 2001, 2002, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      d0801070.sql - downgrade from 9.0.1.0 to 8.1.7.0
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      this takes a valid 9i ctxsys and tries to get it as close as
Rem      possible to 8.1.7.0.
Rem
Rem      IMPORTANT: RUN THIS SCRIPT AS CTXSYS ONLY
Rem
Rem      IMPORTANT: AFTER RUNNING THIS SCRIPT, RUN THE FOLLOWING 
Rem        IN ORDER USING 8.1.7 FILES:
Rem      
Rem        dr0pkh.sql
Rem        dr0plb.sql
Rem        dr0type.plb
Rem        dr0typec.plb
Rem
Rem      IMPORTANT: AFTER DOWNGRADE, IT WILL BE CLOSE TO 8.1.7.0!!!!
Rem        IF YOU PREVIOUSLY HAD 8.1.7.1 OR SOME OTHER PATCHSET VERSION
Rem        YOU MUST RE-UPGRADE
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gkaminag    02/22/02 - component registry!.
Rem    gkaminag    02/15/02 - add implicit call to 9.0.1 downgrade.
Rem    gkaminag    04/13/01 - creation

REM ========================================================================
REM Get to 9.0.1.0 first
REM ========================================================================

@@d0900010.sql

REM ========================================================================
REM Registry to downgrading state
REM ========================================================================

execute dbms_registry.downgrading('CONTEXT');

REM ========================================================================
REM Downgrade context indextype
REM ========================================================================

PROMPT Create dummy implementation type ...
PROMPT

create type TextIndexMethodsTemp authid definer as object
(
   resultor_ctx RAW(4),
   static function ODCIGetInterfaces(ifclist OUT sys.ODCIObjectList)
            return number,
   static function ODCIIndexCreate(ia sys.odciindexinfo, parms varchar2)
            return number,
   static function ODCIIndexAlter(ia sys.odciindexinfo,
                          parms in out varchar2,
                          altopt number)
            return number,
   static function ODCIIndexTruncate(ia sys.odciindexinfo)
            return number,
   static function ODCIIndexDrop(ia sys.odciindexinfo)
             return number,
   static function ODCIIndexInsert(ia sys.odciindexinfo,
                           ridlist sys.odciridlist)
            return number,
   static function ODCIIndexDelete(ia sys.odciindexinfo,
                           ridlist sys.odciridlist)
            return number,
   static function ODCIIndexUpdate(ia sys.odciindexinfo,
                           ridlist sys.odciridlist) 
            return number,
   static function ODCIIndexStart(sctx in out TextIndexMethodsTemp,
                          ia sys.odciindexinfo,
                          op sys.odcipredinfo,
                          qi sys.odciqueryinfo,
                          strt number, stop number, valarg varchar2)
            return number,
   member function ODCIIndexFetch(nrows number,
                          rids OUT sys.odciridlist)
            return number,
   member function ODCIIndexClose
            return number,
   static function ODCIIndexGetMetaData(ia        IN  sys.odciindexinfo, 
                                        version   IN  varchar2,
                                        new_block OUT PLS_INTEGER)
            return varchar2,
   static function ODCIIndexUtilGetTableNames(ia        IN  sys.odciindexinfo,
                                              read_only IN  PLS_INTEGER,
                                              version   IN  varchar2,
                                              context   OUT PLS_INTEGER)
            return varchar2,
   static procedure ODCIIndexUtilCleanup(context IN PLS_INTEGER)
);
/

PROMPT Create dummy implementation type body ...
PROMPT

create or replace type body TextIndexMethodsTemp as

   static function ODCIGetInterfaces(ifclist OUT sys.ODCIObjectList)
            return number is
begin 
  ifclist := sys.ODCIObjectList(sys.ODCIObject('SYS','ODCIINDEX1')); 
  return ODCIConst.Success; 
end ODCIGetInterfaces; 
   static function ODCIIndexCreate(ia sys.odciindexinfo, parms varchar2)
            return number
is begin return sys.odciconst.error; end ODCIIndexCreate;
   static function ODCIIndexAlter(ia sys.odciindexinfo,
                          parms in out varchar2,
                          altopt number)
            return number
is begin return sys.odciconst.error; end ODCIIndexAlter;
   static function ODCIIndexTruncate(ia sys.odciindexinfo)
            return number
is begin return sys.odciconst.error; end ODCIIndexTruncate;
   static function ODCIIndexDrop(ia sys.odciindexinfo)
             return number
is begin return sys.odciconst.error; end ODCIIndexDrop;
   static function ODCIIndexInsert(ia sys.odciindexinfo,
                           ridlist sys.odciridlist)
            return number
is begin return sys.odciconst.error; end ODCIIndexInsert;
   static function ODCIIndexDelete(ia sys.odciindexinfo,
                           ridlist sys.odciridlist)
            return number
is begin return sys.odciconst.error; end ODCIIndexDelete;
   static function ODCIIndexUpdate(ia sys.odciindexinfo,
                           ridlist sys.odciridlist) 
            return number
is begin return sys.odciconst.error; end ODCIIndexUpdate;
   static function ODCIIndexStart(sctx in out TextIndexMethodsTemp,
                          ia sys.odciindexinfo,
                          op sys.odcipredinfo,
                          qi sys.odciqueryinfo,
                          strt number, stop number, valarg varchar2)
            return number
is begin return sys.odciconst.error; end ODCIIndexStart;
   member function ODCIIndexFetch(nrows number,
                          rids OUT sys.odciridlist)
            return number
is begin return sys.odciconst.error; end ODCIIndexFetch;
   member function ODCIIndexClose
            return number
is begin return sys.odciconst.error; end ODCIIndexClose;
   static function ODCIIndexGetMetaData(ia        IN  sys.odciindexinfo, 
                                        version   IN  varchar2,
                                        new_block OUT PLS_INTEGER)
            return varchar2
is begin return null; end ODCIIndexGetMetaData;
   static function ODCIIndexUtilGetTableNames(ia        IN  sys.odciindexinfo,
                                              read_only IN  PLS_INTEGER,
                                              version   IN  varchar2,
                                              context   OUT PLS_INTEGER)
            return varchar2
is begin return sys.odciconst.error; end ODCIIndexUtilGetTableNames;
   static procedure ODCIIndexUtilCleanup(context IN PLS_INTEGER)
is begin null; end ODCIIndexUtilCleanup;

end;
/

PROMPT Create dummy operator package ...
PROMPT

create or replace package ctx_dummyop authid definer as
    function dummyop(Colval in varchar2, 
                             Text in varchar2, ia sys.odciindexctx, 
                             sctx IN OUT TextIndexMethodsTemp,
                             cflg number)
      return number is language C
      name "contains"
      library dr$lib
      with context
      parameters(
        context,
        Colval,
        Colval INDICATOR,
        Text,
        Text INDICATOR,
        Text LENGTH,
        ia,
        ia INDICATOR STRUCT,
        sctx,
        sctx INDICATOR STRUCT,
        cflg,
        cflg INDICATOR,
        return OCINumber
      );
end ctx_dummyop;
/

PROMPT Create dummy operator ...
PROMPT

create or replace operator dummyop binding 
  (varchar2, varchar2) return number 
     with index context, scan context TextIndexMethodsTemp
without column data using ctx_dummyop.dummyop;

PROMPT Remove existing indextype operator bindings ...
PROMPT

alter indextype context add dummyop(varchar2, varchar2);
alter indextype context drop contains(varchar2, varchar2);
alter indextype context drop contains(clob, varchar2);
alter indextype context drop contains(blob, varchar2);
alter indextype context drop contains(bfile, varchar2);
alter indextype context drop contains(sys.XMLType, varchar2);

PROMPT
PROMPT Drop SCORE and CONTAINS operators ...
PROMPT

drop operator score;
drop operator contains;
drop package ctx_contains;
drop package driscore;

PROMPT
PROMPT Shift indextype implementation to dummy implementation type ...
PROMPT

alter indextype context using TextIndexMethodsTemp
without local range partition;

PROMPT
PROMPT Drop 9i TextIndexMethods
PROMPT

drop type textindexmethods;

PROMPT Create 8.1.7.0 version of TextIndexMethods
PROMPT

create type TextIndexMethods authid definer as object
(
   resultor_ctx RAW(4),
   static function ODCIGetInterfaces(ifclist OUT sys.ODCIObjectList)
            return number,
   static function ODCIIndexCreate(ia sys.odciindexinfo, parms varchar2)
            return number,
   static function ODCIIndexAlter(ia sys.odciindexinfo,
                          parms in out varchar2,
                          altopt number)
            return number,
   static function ODCIIndexTruncate(ia sys.odciindexinfo)
            return number,
   static function ODCIIndexDrop(ia sys.odciindexinfo)
             return number,
   static function ODCIIndexInsert(ia sys.odciindexinfo,
                           ridlist sys.odciridlist)
            return number is language C
            name "insert"
            library dr$lib
            with context
            parameters(
               context,
               ia,
               ia INDICATOR STRUCT,
               ridlist,
               ridlist INDICATOR,
               return OCINumber
            ),
   static function ODCIIndexDelete(ia sys.odciindexinfo,
                           ridlist sys.odciridlist)
            return number is language C
            name "delete"
            library dr$lib
            with context
            parameters(
               context,
               ia,
               ia INDICATOR STRUCT,
               ridlist,
               ridlist INDICATOR,
               return OCINumber
            ),
   static function ODCIIndexUpdate(ia sys.odciindexinfo,
                           ridlist sys.odciridlist) 
            return number is language C
            name "update"
            library dr$lib
            with context
            parameters(
               context,
               ia,
               ia INDICATOR STRUCT,
               ridlist,
               ridlist INDICATOR,
               return OCINumber
            ),
   static function ODCIIndexStart(sctx in out TextIndexMethods,
                          ia sys.odciindexinfo,
                          op sys.odcipredinfo,
                          qi sys.odciqueryinfo,
                          strt number, stop number, valarg varchar2)
            return number is language C
            name "start"
            library dr$lib
            with context
            parameters(
               context,
               sctx,
               sctx INDICATOR STRUCT,
               ia,
               ia INDICATOR STRUCT,
               op,
               op INDICATOR STRUCT,
               qi,
               qi INDICATOR STRUCT,
               strt,
               strt INDICATOR,
               stop,
               stop INDICATOR,
               valarg, 
               valarg INDICATOR,
               valarg LENGTH,
               return OCINumber
            ),
   member function ODCIIndexFetch(nrows number,
                          rids OUT sys.odciridlist)
            return number is language C
            name "fetch"
            library dr$lib
            with context
            parameters(
               context,
               self,
               self INDICATOR STRUCT,
               nrows,
               nrows INDICATOR,
               rids,
               rids INDICATOR,
               return OCINumber
            ),
   member function ODCIIndexClose
            return number is language C
            name "close"
            library dr$lib
            with context
            parameters(
               context,
               self,
               self INDICATOR STRUCT,
               return OCINumber
            ),
   static function ODCIIndexGetMetaData(ia        IN  sys.odciindexinfo, 
                                        version   IN  varchar2,
                                        new_block OUT PLS_INTEGER)
            return varchar2,
   static function ODCIIndexUtilGetTableNames(ia        IN  sys.odciindexinfo,
                                              read_only IN  PLS_INTEGER,
                                              version   IN  varchar2,
                                              context   OUT PLS_INTEGER)
            return varchar2,
   static procedure ODCIIndexUtilCleanup(context IN PLS_INTEGER)
);
/

grant execute on TextIndexMethods to public;

PROMPT
PROMPT Create 8.1.7 version of ctx_contains

create package ctx_contains authid definer as
    function Textcontains(Colval in varchar2, 
                             Text in varchar2, ia sys.odciindexctx, 
                             sctx IN OUT TextIndexMethods,
                             cflg number)
      return number is language C
      name "contains"
      library dr$lib
      with context
      parameters(
        context,
        Colval,
        Colval INDICATOR,
        Text,
        Text INDICATOR,
        Text LENGTH,
        ia,
        ia INDICATOR STRUCT,
        sctx,
        sctx INDICATOR STRUCT,
        cflg,
        cflg INDICATOR,
        return OCINumber
      );
    function Textcontains(Colval in clob, 
                                Text in varchar2, ia sys.odciindexctx, 
                                sctx IN OUT TextIndexMethods,
                                cflg number)
      return number is language C
      name "contains"
      library dr$lib
      with context
      parameters(
        context,
        Colval,
        Colval INDICATOR,
        Text,
        Text INDICATOR,
        Text LENGTH,
        ia,
        ia INDICATOR STRUCT,
        sctx,
        sctx INDICATOR STRUCT,
        cflg,
        cflg INDICATOR,
        return OCINumber
      );
    function Textcontains(Colval in blob, 
                                Text in varchar2, ia sys.odciindexctx, 
                                sctx IN OUT TextIndexMethods,
                                cflg number)
      return number is language C
      name "contains"
      library dr$lib
      with context
      parameters(
        context,
        Colval,
        Colval INDICATOR,
        Text,
        Text INDICATOR,
        Text LENGTH,
        ia,
        ia INDICATOR STRUCT,
        sctx,
        sctx INDICATOR STRUCT,
        cflg,
        cflg INDICATOR,
        return OCINumber
      );
    function Textcontains(Colval in bfile, 
                                Text in varchar2, ia sys.odciindexctx, 
                                sctx IN OUT TextIndexMethods,
                                cflg number)
      return number is language C
      name "contains"
      library dr$lib
      with context
      parameters(
        context,
        Colval,
        Colval INDICATOR,
        Text,
        Text INDICATOR,
        Text LENGTH,
        ia,
        ia INDICATOR STRUCT,
        sctx,
        sctx INDICATOR STRUCT,
        cflg,
        cflg INDICATOR,
        return OCINumber
      );
end ctx_contains;
/

grant execute on ctx_contains to public;

PROMPT
PROMPT create 8.1.7 operator contains
PROMPT
create  operator contains binding 
  (varchar2, varchar2) return number 
     with index context, scan context TextIndexMethods 
     compute ancillary data without column data using ctx_contains.Textcontains,
  (clob, varchar2) return number 
     with index context, scan context TextIndexMethods 
     compute ancillary data without column data using ctx_contains.Textcontains,
  (blob, varchar2) return number 
     with index context, scan context TextIndexMethods 
     compute ancillary data without column data using ctx_contains.Textcontains,
  (bfile, varchar2) return number 
     with index context, scan context TextIndexMethods 
     compute ancillary data without column data using ctx_contains.Textcontains;

grant execute on contains to public;

drop public synonym contains;
create public synonym contains for ctxsys.contains;

PROMPT
PROMPT create 8.1.7 package driscore
PROMPT

create package driscore authid definer as
    function TextScore(Colval in varchar2, 
                             Text in varchar2, ia sys.odciindexctx, 
                             sctx IN OUT TextIndexMethods,
                             cflg number)
      return number is language C
      name "contains"
      library dr$lib
      with context
      parameters(
        context,
        Colval,
        Colval INDICATOR,
        Text,
        Text INDICATOR,
        Text LENGTH,
        ia,
        ia INDICATOR STRUCT,
        sctx,
        sctx INDICATOR STRUCT,
        cflg,
        cflg INDICATOR,
        return OCINumber
      );
    function TextScore(Colval in clob, 
                                Text in varchar2, ia sys.odciindexctx, 
                                sctx IN OUT TextIndexMethods,
                                cflg number)
      return number is language C
      name "contains"
      library dr$lib
      with context
      parameters(
        context,
        Colval,
        Colval INDICATOR,
        Text,
        Text INDICATOR,
        Text LENGTH,
        ia,
        ia INDICATOR STRUCT,
        sctx,
        sctx INDICATOR STRUCT,
        cflg,
        cflg INDICATOR,
        return OCINumber
      );
    function TextScore(Colval in blob, 
                                Text in varchar2, ia sys.odciindexctx, 
                                sctx IN OUT TextIndexMethods,
                                cflg number)
      return number is language C
      name "contains"
      library dr$lib
      with context
      parameters(
        context,
        Colval,
        Colval INDICATOR,
        Text,
        Text INDICATOR,
        Text LENGTH,
        ia,
        ia INDICATOR STRUCT,
        sctx,
        sctx INDICATOR STRUCT,
        cflg,
        cflg INDICATOR,
        return OCINumber
      );
    function TextScore(Colval in bfile, 
                                Text in varchar2, ia sys.odciindexctx, 
                                sctx IN OUT TextIndexMethods,
                                cflg number)
      return number is language C
      name "contains"
      library dr$lib
      with context
      parameters(
        context,
        Colval,
        Colval INDICATOR,
        Text,
        Text INDICATOR,
        Text LENGTH,
        ia,
        ia INDICATOR STRUCT,
        sctx,
        sctx INDICATOR STRUCT,
        cflg,
        cflg INDICATOR,
        return OCINumber
      );
end driscore;
/

grant execute on driscore to public;

PROMPT
PROMPT create 8.1.7 operator score
PROMPT

create  operator score binding 
   (number) return number
     ancillary to contains(varchar2, varchar2),
                  contains(clob, varchar2), 
                  contains(blob, varchar2), 
                  contains(bfile, varchar2) 
     without column data using driscore.TextScore;

grant execute on score to public;

drop public synonym score;
create public synonym score for ctxsys.score;

PROMPT
PROMPT create 8.1.7 TextOptStats
PROMPT

create or replace type TextOptStats authid definer as object
(
   stats_ctx RAW(4),
   static function ODCIGetInterfaces(ifclist OUT sys.ODCIObjectList)  
       return number,
   static function ODCIStatsCollect(idx sys.ODCIIndexInfo, 
                                    options sys.ODCIStatsOptions,
                                    statistics OUT RAW)
            return number is language C
            name "st_coll"
            library dr$lib
            with context
            parameters(
               context,
               idx, 
               idx INDICATOR STRUCT,
               options,
               options INDICATOR STRUCT,
               statistics,
               statistics INDICATOR,
               statistics LENGTH,
               return OCINumber
             ),
  
   static function ODCIStatsDelete(idx sys.ODCIIndexInfo)
            return number is language C
            name "st_del"
            library dr$lib
            with context
            parameters(
               context,
               idx,
               idx INDICATOR STRUCT,
               return OCINumber
            ),

   static function ODCIStatsSelectivity(pred sys.ODCIPredInfo, 
                                        sel  OUT NUMBER,
                                        args sys.ODCIArgDescList,
                                        strt NUMBER, 
                                        stop NUMBER, 
                                        colval varchar2,
                                        valarg varchar2)
            return number is language C
            name "st_sel"
            library dr$lib
            with context
            parameters(
               context,
               pred,
               pred INDICATOR STRUCT,
               sel, 
               sel INDICATOR,
               args,
               args INDICATOR,
               strt,
               strt INDICATOR,
               stop,
               stop INDICATOR,
               colval, 
               colval INDICATOR,
               valarg, 
               valarg INDICATOR,
               return OCINumber
             ),
  
   static function ODCIStatsFunctionCost(func sys.ODCIFuncinfo, 
                                         cost IN OUT sys.ODCICost,
                                         args sys.ODCIArgDescList,
                                         colval varchar2,
                                         valarg varchar2)
            return number is language C
            name "st_fcost"
            library dr$lib
            with context
            parameters(
               context,
               func,
               func INDICATOR STRUCT,
               cost,
               cost INDICATOR STRUCT,
               args,
               args INDICATOR,
               colval, 
               colval INDICATOR,
               valarg, 
               valarg INDICATOR,
               return OCINumber
             ),

   static function ODCIStatsIndexCost(idx sys.ODCIIndexInfo, 
                                      sel NUMBER,
                                      cost IN OUT sys.ODCICost,
                                      qi sys.ODCIQueryInfo,
                                      pred sys.ODCIPredInfo,
                                      args sys.ODCIArgDescList, 
                                      strt NUMBER,
                                      stop NUMBER,
                                      valarg varchar2)
            return number is language C
            name "st_icost"
            library dr$lib
            with context
            parameters(
               context,
               idx,
               idx INDICATOR STRUCT,
               sel,
               sel INDICATOR,
               cost,
               cost INDICATOR STRUCT,
               qi,
               qi INDICATOR STRUCT,
               pred,
               pred INDICATOR STRUCT,
               args,
               args INDICATOR,
               strt,
               strt INDICATOR,
               stop,
               stop INDICATOR,
               valarg, 
               valarg INDICATOR,
               return OCINumber
             ),
  
  pragma restrict_references(ODCIStatsSelectivity, WNDS, WNPS), 
  pragma restrict_references(ODCIStatsFunctionCost, WNDS, WNPS), 
  pragma restrict_references(ODCIStatsIndexCost, WNDS, WNPS) 
);
/

grant execute on TextOptStats to public;

PROMPT
PROMPT create dummy TextIndexMethods type body
PROMPT

create or replace type body TextIndexMethods as

   static function ODCIGetInterfaces(ifclist OUT sys.ODCIObjectList)
            return number is
begin 
  ifclist := sys.ODCIObjectList(sys.ODCIObject('SYS','ODCIINDEX1')); 
  return ODCIConst.Success; 
end ODCIGetInterfaces; 
   static function ODCIIndexCreate(ia sys.odciindexinfo, parms varchar2)
            return number
is begin return sys.odciconst.error; end ODCIIndexCreate;
   static function ODCIIndexAlter(ia sys.odciindexinfo,
                          parms in out varchar2,
                          altopt number)
            return number
is begin return sys.odciconst.error; end ODCIIndexAlter;
   static function ODCIIndexTruncate(ia sys.odciindexinfo)
            return number
is begin return sys.odciconst.error; end ODCIIndexTruncate;
   static function ODCIIndexDrop(ia sys.odciindexinfo)
             return number
is begin return sys.odciconst.error; end ODCIIndexDrop;
   static function ODCIIndexGetMetaData(ia        IN  sys.odciindexinfo, 
                                        version   IN  varchar2,
                                        new_block OUT PLS_INTEGER)
            return varchar2
is begin return null; end ODCIIndexGetMetaData;
   static function ODCIIndexUtilGetTableNames(ia        IN  sys.odciindexinfo,
                                              read_only IN  PLS_INTEGER,
                                              version   IN  varchar2,
                                              context   OUT PLS_INTEGER)
            return varchar2
is begin return sys.odciconst.error; end ODCIIndexUtilGetTableNames;
   static procedure ODCIIndexUtilCleanup(context IN PLS_INTEGER)
is begin null; end ODCIIndexUtilCleanup;

end;
/

PROMPT
PROMPT shift indextype implementation to TextIndexMethods
PROMPT

alter indextype context using TextIndexMethods;

PROMPT Re-bind operators to indextype  ...
PROMPT

alter indextype context add contains(varchar2, varchar2);
alter indextype context add contains(clob, varchar2);
alter indextype context add contains(blob, varchar2);
alter indextype context add contains(bfile, varchar2);

PROMPT Remove dummy operator and dummy implementation type ...
PROMPT

alter indextype context drop dummyop(varchar2, varchar2);
drop operator dummyop;
drop package ctx_dummyop;
drop type TextIndexMethodsTemp;

PROMPT Re-associate statistics with the new implementation type.
PROMPT
ASSOCIATE STATISTICS WITH INDEXTYPES ConText USING TextOptStats FORCE;
ASSOCIATE STATISTICS WITH PACKAGES ctx_contains USING TextOptStats FORCE;

PROMPT Re-create syncrn ...
PROMPT

create or replace procedure syncrn (
  idxid IN binary_integer,
  ixpid IN binary_integer,
  rtabnm IN varchar2
)
  as external
  name "comt_cb"
  library dr$lib
  with context
  parameters(
    context,
    idxid  ub4,
    ixpid  ub4,
    rtabnm OCISTRING
);
/

REM ========================================================================
REM Downgrade ctxcat indextype
REM ========================================================================

PROMPT Create dummy implementation type ...
PROMPT

create type CatIndexMethodsTemp authid definer as object
(
   resultor_ctx RAW(4),
   static function ODCIGetInterfaces(ifclist OUT sys.ODCIObjectList)
            return number,
   static function ODCIIndexCreate(ia sys.odciindexinfo, parms varchar2)
            return number,
   static function ODCIIndexAlter(ia sys.odciindexinfo,
                          parms in out varchar2,
                          altopt number)
            return number,
   static function ODCIIndexTruncate(ia sys.odciindexinfo)
            return number,
   static function ODCIIndexDrop(ia sys.odciindexinfo)
             return number,
   static function ODCIIndexInsert(ia sys.odciindexinfo,
                           ridlist sys.odciridlist)
            return number,
   static function ODCIIndexDelete(ia sys.odciindexinfo,
                           ridlist sys.odciridlist)
            return number,
   static function ODCIIndexUpdate(ia sys.odciindexinfo,
                           ridlist sys.odciridlist) 
            return number,
   static function ODCIIndexStart(sctx in out CatIndexMethodsTemp,
                          ia sys.odciindexinfo,
                          op sys.odcipredinfo,
                          qi sys.odciqueryinfo,
                          strt number, stop number, valarg varchar2)
            return number,
   member function ODCIIndexFetch(nrows number,
                          rids OUT sys.odciridlist)
            return number,
   member function ODCIIndexClose
            return number,
   static function ODCIIndexGetMetaData(ia        IN  sys.odciindexinfo, 
                                        version   IN  varchar2,
                                        new_block OUT PLS_INTEGER)
            return varchar2,
   static function ODCIIndexUtilGetTableNames(ia        IN  sys.odciindexinfo,
                                              read_only IN  PLS_INTEGER,
                                              version   IN  varchar2,
                                              context   OUT PLS_INTEGER)
            return varchar2,
   static procedure ODCIIndexUtilCleanup(context IN PLS_INTEGER)
);
/

PROMPT Create dummy implementation type body ...
PROMPT

create or replace type body CatIndexMethodsTemp as

   static function ODCIGetInterfaces(ifclist OUT sys.ODCIObjectList)
            return number is
begin 
  ifclist := sys.ODCIObjectList(sys.ODCIObject('SYS','ODCIINDEX1')); 
  return ODCIConst.Success; 
end ODCIGetInterfaces; 
   static function ODCIIndexCreate(ia sys.odciindexinfo, parms varchar2)
            return number
is begin return sys.odciconst.error; end ODCIIndexCreate;
   static function ODCIIndexAlter(ia sys.odciindexinfo,
                          parms in out varchar2,
                          altopt number)
            return number
is begin return sys.odciconst.error; end ODCIIndexAlter;
   static function ODCIIndexTruncate(ia sys.odciindexinfo)
            return number
is begin return sys.odciconst.error; end ODCIIndexTruncate;
   static function ODCIIndexDrop(ia sys.odciindexinfo)
             return number
is begin return sys.odciconst.error; end ODCIIndexDrop;
   static function ODCIIndexInsert(ia sys.odciindexinfo,
                           ridlist sys.odciridlist)
            return number
is begin return sys.odciconst.error; end ODCIIndexInsert;
   static function ODCIIndexDelete(ia sys.odciindexinfo,
                           ridlist sys.odciridlist)
            return number
is begin return sys.odciconst.error; end ODCIIndexDelete;
   static function ODCIIndexUpdate(ia sys.odciindexinfo,
                           ridlist sys.odciridlist) 
            return number
is begin return sys.odciconst.error; end ODCIIndexUpdate;
   static function ODCIIndexStart(sctx in out CatIndexMethodsTemp,
                          ia sys.odciindexinfo,
                          op sys.odcipredinfo,
                          qi sys.odciqueryinfo,
                          strt number, stop number, valarg varchar2)
            return number
is begin return sys.odciconst.error; end ODCIIndexStart;
   member function ODCIIndexFetch(nrows number,
                          rids OUT sys.odciridlist)
            return number
is begin return sys.odciconst.error; end ODCIIndexFetch;
   member function ODCIIndexClose
            return number
is begin return sys.odciconst.error; end ODCIIndexClose;
   static function ODCIIndexGetMetaData(ia        IN  sys.odciindexinfo, 
                                        version   IN  varchar2,
                                        new_block OUT PLS_INTEGER)
            return varchar2
is begin return null; end ODCIIndexGetMetaData;
   static function ODCIIndexUtilGetTableNames(ia        IN  sys.odciindexinfo,
                                              read_only IN  PLS_INTEGER,
                                              version   IN  varchar2,
                                              context   OUT PLS_INTEGER)
            return varchar2
is begin return sys.odciconst.error; end ODCIIndexUtilGetTableNames;
   static procedure ODCIIndexUtilCleanup(context IN PLS_INTEGER)
is begin null; end ODCIIndexUtilCleanup;

end;
/

PROMPT Create dummy operator package ...
PROMPT

create or replace package ctx_catdummy authid definer as
 function dummyop(
  Colval  in     varchar2, 
  Text    in     varchar2, 
  condcls in     varchar2,
  ia      in     sys.odciindexctx, 
  sctx    in out CatIndexMethodsTemp,
  cflg    in     number
)
  return number is language C
  name "catsearch"
  library dr$lib
  with context
  parameters(
        context,
        Colval,
        Colval INDICATOR,
        Text,
        Text INDICATOR,
        Text LENGTH,
        condcls,
        condcls INDICATOR,
        condcls LENGTH,
        ia,
        ia INDICATOR STRUCT,
        sctx,
        sctx INDICATOR STRUCT,
        cflg,
        cflg INDICATOR,
        return OCINumber
      );
end ctx_catdummy;
/

PROMPT Create dummy operator ...
PROMPT

create or replace operator catdummyop binding 
  (varchar2, varchar2, varchar2) return number 
     with index context, scan context CatIndexMethodsTemp 
     without column data using ctx_catdummy.dummyop
;

PROMPT Remove existing indextype operator bindings ...
PROMPT

alter indextype ctxcat add catdummyop(varchar2, varchar2, varchar2);
alter indextype ctxcat drop catsearch(varchar2, varchar2, varchar2);
alter indextype ctxcat drop catsearch(clob, varchar2, varchar2);

PROMPT Drop CATSEARCH operators ...
PROMPT

drop operator catsearch;
drop package ctx_catsearch;

PROMPT Shift indextype implementation to dummy implementation type ...
PROMPT

alter indextype ctxcat using CatIndexMethodsTemp;

PROMPT Drop 9i CatIndexMethods
PROMPT

drop type CatIndexMethods;

PROMPT Create 8.1.7.0 version of CatIndexMethods
PROMPT

create type CatIndexMethods authid definer as object
(
   resultor_ctx RAW(4),
   static function ODCIGetInterfaces(ifclist OUT sys.ODCIObjectList)
            return number,
   static function ODCIIndexCreate(ia sys.odciindexinfo, parms varchar2)
            return number,
   static function ODCIIndexAlter(ia sys.odciindexinfo,
                          parms in out varchar2,
                          altopt number)
            return number,
   static function ODCIIndexTruncate(ia sys.odciindexinfo)
            return number,
   static function ODCIIndexDrop(ia sys.odciindexinfo)
             return number,
   static function ODCIIndexInsert(ia sys.odciindexinfo,
                           ridlist sys.odciridlist) 
             return number,
   static function ODCIIndexDelete(ia sys.odciindexinfo,
                           ridlist sys.odciridlist)
            return number,
   static function ODCIIndexUpdate(ia sys.odciindexinfo,
                           ridlist sys.odciridlist)
            return number,
   static function ODCIIndexStart(sctx in out CatIndexMethods,
                          ia sys.odciindexinfo,
                          op sys.odcipredinfo,
                          qi sys.odciqueryinfo,
                          strt number, stop number, valarg varchar2, valarg2 varchar2)
            return number is language C
        name "catstart"
        library dr$lib
        with context
        parameters(
               context,
               sctx,
               sctx INDICATOR STRUCT,
               ia,
               ia INDICATOR STRUCT,
               op,
               op INDICATOR STRUCT,
               qi,
               qi INDICATOR STRUCT,
               strt,
               strt INDICATOR,
               stop,
               stop INDICATOR,
               valarg, 
               valarg INDICATOR,
               valarg LENGTH,          
               valarg2, 
               valarg2 INDICATOR,
               valarg2 LENGTH,
               return OCINumber
            ),
   member function ODCIIndexFetch(nrows number,
                          rids OUT sys.odciridlist)
            return number is language C
            name "catfetch"
            library dr$lib
            with context
            parameters(
               context,
               self,
               self INDICATOR STRUCT,
               nrows,
               nrows INDICATOR,
               rids,
               rids INDICATOR,
               return OCINumber
            ),
   member function ODCIIndexClose
            return number is language C
            name "catclose"
            library dr$lib
            with context
            parameters(
               context,
               self,
               self INDICATOR STRUCT,
               return OCINumber
            ),
   static function ODCIIndexGetMetaData(ia        IN  sys.odciindexinfo, 
                                        version   IN  varchar2,
                                        new_block OUT PLS_INTEGER)
            return varchar2,
   static function ODCIIndexUtilGetTableNames(ia        IN  sys.odciindexinfo,
                                              read_only IN  PLS_INTEGER,
                                              version   IN  varchar2,
                                              context   OUT PLS_INTEGER)
            return varchar2,
   static procedure ODCIIndexUtilCleanup(context IN PLS_INTEGER)
);
/

grant execute on CatIndexMethods to public;

PROMPT
PROMPT Create 8.1.7 version of ctx_catsearch

create package ctx_catsearch authid definer as
    
function catsearch(
  Colval  in     varchar2, 
  Text    in     varchar2, 
  condcls in     varchar2,
  ia      in     sys.odciindexctx, 
  sctx    in out CatIndexMethods,
  cflg    in     number
)
  return number is language C
  name "catsearch"
  library dr$lib
  with context
  parameters(
        context,
        Colval,
        Colval INDICATOR,
        Text,
        Text INDICATOR,
        Text LENGTH,
        condcls,
        condcls INDICATOR,
        condcls LENGTH,
        ia,
        ia INDICATOR STRUCT,
        sctx,
        sctx INDICATOR STRUCT,
        cflg,
        cflg INDICATOR,
        return OCINumber
      );

function catsearch(
  Colval  in     clob, 
  Text    in     varchar2, 
  condcls in     varchar2,
  ia      in     sys.odciindexctx, 
  sctx    in out CatIndexMethods,
  cflg    in     number
)
  return number is language C
  name "catsearch"
  library dr$lib
  with context
  parameters(
        context,
        Colval,
        Colval INDICATOR,
        Text,
        Text INDICATOR,
        Text LENGTH,
        condcls,
        condcls INDICATOR,
        condcls LENGTH,
        ia,
        ia INDICATOR STRUCT,
        sctx,
        sctx INDICATOR STRUCT,
        cflg,
        cflg INDICATOR,
        return OCINumber
      );
end ctx_catsearch;
/
grant execute on ctx_catsearch to public;

PROMPT
PROMPT create 8.1.7 operator catsearch
PROMPT

create  operator catsearch binding 
  (varchar2, varchar2, varchar2) return number 
     with index context, scan context CatIndexMethods 
     without column data using ctx_catsearch.catsearch,
  (clob, varchar2, varchar2) return number 
     with index context, scan context CatIndexMethods 
     without column data using ctx_catsearch.catsearch
;

grant execute on catsearch to public;

drop public synonym catsearch;
create public synonym catsearch for ctxsys.catsearch;

PROMPT
PROMPT create dummy CatIndexMethods type body
PROMPT

create or replace type body CatIndexMethods as

   static function ODCIGetInterfaces(ifclist OUT sys.ODCIObjectList)
            return number is
begin 
  ifclist := sys.ODCIObjectList(sys.ODCIObject('SYS','ODCIINDEX1')); 
  return ODCIConst.Success; 
end ODCIGetInterfaces; 
   static function ODCIIndexCreate(ia sys.odciindexinfo, parms varchar2)
            return number
is begin return sys.odciconst.error; end ODCIIndexCreate;
   static function ODCIIndexAlter(ia sys.odciindexinfo,
                          parms in out varchar2,
                          altopt number)
            return number
is begin return sys.odciconst.error; end ODCIIndexAlter;
   static function ODCIIndexTruncate(ia sys.odciindexinfo)
            return number
is begin return sys.odciconst.error; end ODCIIndexTruncate;
   static function ODCIIndexDrop(ia sys.odciindexinfo)
             return number
is begin return sys.odciconst.error; end ODCIIndexDrop;
   static function ODCIIndexInsert(ia sys.odciindexinfo,
                           ridlist sys.odciridlist)
            return number
is begin return sys.odciconst.error; end ODCIIndexInsert;
   static function ODCIIndexDelete(ia sys.odciindexinfo,
                           ridlist sys.odciridlist)
            return number
is begin return sys.odciconst.error; end ODCIIndexDelete;
   static function ODCIIndexUpdate(ia sys.odciindexinfo,
                           ridlist sys.odciridlist) 
            return number
is begin return sys.odciconst.error; end ODCIIndexUpdate;
   static function ODCIIndexGetMetaData(ia        IN  sys.odciindexinfo, 
                                        version   IN  varchar2,
                                        new_block OUT PLS_INTEGER)
            return varchar2
is begin return null; end ODCIIndexGetMetaData;
   static function ODCIIndexUtilGetTableNames(ia        IN  sys.odciindexinfo,
                                              read_only IN  PLS_INTEGER,
                                              version   IN  varchar2,
                                              context   OUT PLS_INTEGER)
            return varchar2
is begin return sys.odciconst.error; end ODCIIndexUtilGetTableNames;
   static procedure ODCIIndexUtilCleanup(context IN PLS_INTEGER)
is begin null; end ODCIIndexUtilCleanup;

end;
/

PROMPT
PROMPT shift indextype implementation to CatIndexMethods
PROMPT

alter indextype ctxcat using CatIndexMethods;

PROMPT Re-bind operators to indextype  ...
PROMPT

alter indextype ctxcat add catsearch(varchar2, varchar2, varchar2);
alter indextype ctxcat add catsearch(clob, varchar2, varchar2);

PROMPT Remove dummy operator and dummy implementation type ...
PROMPT

alter indextype ctxcat drop catdummyop(varchar2, varchar2, varchar2);
drop operator catdummyop;
drop package ctx_catdummy;
drop type CatIndexMethodsTemp;

alter package ctx_catsearch compile;
alter operator catsearch compile;
alter indextype ctxcat compile;

REM ========================================================================
REM Downgrade ctxrule indextype
REM ========================================================================

drop public synonym ctxrule;
drop indextype ctxrule;
drop public synonym matches;
drop operator matches;
drop package ctx_matches;
drop type RuleIndexMethods;

REM ========================================================================
REM Drop All Packages
REM ========================================================================

drop package CTX_ADM;
drop package CTX_DDL;
drop package CTX_DOC;
drop package CTX_OUTPUT;
drop package CTX_QUERY;
drop package CTX_THES;
drop package DRIACC;
drop package DRIADM;
drop package DRICON;
drop package DRIDDL;
drop package DRIDDLC;
drop package DRIDDLR;
drop package DRIDISP;
drop package DRIDML;
drop package DRIDOC;
drop package DRIEXP;
drop package DRIG;
drop package DRIIMP;
drop package DRILIST;
drop package DRILOAD;
drop package DRIOBJ;
drop package DRIOPT;
drop package DRIPARSE;
drop package DRIPIPE;
drop package DRIPREF;
drop package DRIREC;
drop package DRITHS;
drop package DRITHSC;
drop package DRITHSD;
drop package DRITHSL;
drop package DRITHSX;
drop package DRIUTL;
drop package DRIVAL;
drop package DRIXTAB;
drop package DRIXTABC;
drop package DRIXTABR;
drop package DRUE;
drop package DR_DEF;


REM ========================================================================
REM Restore CTX_VERSION view
REM ========================================================================

CREATE OR REPLACE VIEW ctx_version AS
select '8.1.7' ver_dict from dual;

REM ========================================================================
REM Remove CTXRULE system parameters
REM ========================================================================

delete from dr$parameter where par_name like 'DEFAULT_CTXRULE%';
commit;

REM ========================================================================
REM Remove BLOB_LOC, CLOB_LOC USER_DATASTORE OUTPUT_TYPE
REM ========================================================================

delete from dr$object_attribute_lov
where oal_oat_id = 10502
and oal_label = 'BLOB_LOC';
delete from dr$object_attribute_lov
where oal_oat_id = 10502
and oal_label = 'CLOB_LOC';
commit;

REM ========================================================================
REM Remove Partitioning Support
REM ========================================================================

drop table dr$part_stats;
drop table dr$delete;

create table dr$delete (
  del_idx_id    number,
  del_docid     number,
  constraint drc$del_key primary key (del_idx_id, del_docid)
)
organization index;

delete from dr$object_attribute 
where oat_id = 90108;
commit;

drop table dr$index_partition;
drop view ctx_index_partitions;
drop view ctx_user_index_partitions;

begin
  execute immediate 
    'create table dr$pending_backup as '||
    'select * from dr$pending p';
  execute immediate
    'drop table dr$pending';
  execute immediate
    'create table dr$pending ( '||
    'pnd_cid       number, '||
    'pnd_rowid     rowid, '||
    'pnd_timestamp date, '||
    'primary key (pnd_cid, pnd_rowid) '||
    ') '||
    'organization index '||
    'storage (freelists 10) ';
  execute immediate
    'insert into dr$pending '||
    'select pnd_cid, pnd_rowid, pnd_timestamp '||
    'from dr$pending_backup';
  execute immediate
    'drop table dr$pending_backup';
end;
/
CREATE OR REPLACE VIEW ctx_pending AS
select u.name      pnd_index_owner,
       idx_name    pnd_index_name,
       pnd_rowid,
       pnd_timestamp
  from dr$pending, dr$index, sys.user$ u
 where pnd_cid = idx_id
   and idx_owner# = u.user#
/

CREATE OR REPLACE VIEW ctx_user_pending AS
select idx_name  pnd_index_name,
       pnd_rowid,
       pnd_timestamp
  from dr$pending, dr$index
 where pnd_cid = idx_id
   and idx_owner# = userenv('SCHEMAID')
/

create public synonym CTX_USER_PENDING for CTXSYS.CTX_USER_PENDING;
grant select on CTX_USER_PENDING to PUBLIC;

REM ========================================================================
REM Remove Index Sub Lexer Views
REM ========================================================================

drop public synonym ctx_user_index_sub_lexer_vals;
drop view ctx_user_index_sub_lexer_vals;
drop view ctx_index_sub_lexer_values;
drop public synonym ctx_user_index_sub_lexers;
drop view ctx_user_index_sub_lexers;
drop view ctx_index_sub_lexers;
drop function dri_sublxv_lang;

REM ========================================================================
REM Remove INSO Filter timeout
REM ========================================================================

delete from dr$object_attribute
where oat_id = 40502;
commit;

REM ========================================================================
REM Remove Japanese (Lexical) Lexer
REM ========================================================================

delete from dr$object
where obj_cla_id = 6
  and obj_id = 8;
commit;

REM ========================================================================
REM Remove Korean Morphological Lexer
REM ========================================================================

delete from dr$object_attribute_lov
where oal_oat_id between 60700 and 60799;

delete from dr$object_attribute
where oat_id between 60700 and 60799;

delete from dr$object 
 where obj_cla_id = 6
   and obj_id = 7;
commit;

REM ========================================================================
REM Remove language-specific base letter, theme proving control
REM ========================================================================

delete from dr$object_attribute_lov
 where oal_oat_id = 60119;
delete from dr$object_attribute
 where oat_id = 60118;
delete from dr$object_attribute
 where oat_id = 60119;
commit;

REM ========================================================================
REM remove path sectioner
REM ========================================================================

delete from dr$section_group where sgp_obj_id = 8;
delete from dr$object 
 where obj_cla_id = 5
   and obj_id = 8;
commit;

REM ========================================================================
REM Remove XMLType Support
REM ========================================================================

delete from dr$preference
 where pre_cla_id = 2
   and pre_obj_id = 5;
delete from dr$parameter where par_name = 'DEFAULT_SECTION_XML';
delete from dr$object
 where obj_cla_id = 2
   and obj_id = 5;
commit;

REM ========================================================================
REM Misc
REM ========================================================================

drop function dri_version;

REM ========================================================================
REM Registry to downgraded state
REM ========================================================================

execute dbms_registry.downgraded('CONTEXT','8.1.7.0.0');
