Rem
Rem u0902000.sql
Rem
Rem Copyright (c) 2001, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      u0902000.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      upgrade ctxsys from 9.0.1 to 9.2.0
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    surman      02/10/06 - 4472797: Call ctxpatch 
Rem    gkaminag    02/15/02 - version to 9.2.0.1  .
Rem    gkaminag    02/19/02 - bug 2232407.
Rem    mfaisal     02/03/02 - inso_filter timeout_type
Rem    daliao      01/31/02 - add classification update
Rem    gkaminag    01/17/02 - update
Rem    gkaminag    01/08/02 - call dbms_registry.valid.
Rem    yucheng     01/11/02 - create online pending table
Rem    gkaminag    12/17/01 - bug 2154029.
Rem    gkaminag    12/05/01 - change name in upgrading....
Rem    salpha      11/20/01 - need to change default theme lexer for ctxcat
Rem    gkaminag    11/20/01 - policy name to default_policy_oracontains.
Rem    mfaisal     10/24/01 - user-defined lexer
Rem    gshank      10/22/01 - Stem Indexing
Rem    gkaminag    10/23/01 - policy.
Rem    wclin       09/25/01 - ctxxpath
Rem    gkaminag    10/08/01 - component registry.
Rem    ehuang      09/29/01 - URITypeIndexing.
Rem    gkaminag    08/08/01 - creation

REM ========================================================================
REM Registry to upgrading state
REM ========================================================================

execute dbms_registry.upgrading('CONTEXT', new_name=>'Oracle Text');

REM ========================================================================
REM all existing ctxcat index created with default/theme lexer, need to set
REM index_themes=no
REM ========================================================================

update dr$index_value
  set ixv_value = '0'
where (ixv_oat_id = 60113
       or ixv_sub_oat_id=60113)
  and ixv_idx_id in
      (select idx_id from
         dr$index
         where idx_type=1);   


REM ========================================================================
REM temporary versions of ctx_ddl routines
REM ========================================================================

create or replace procedure dr$temp_crepref(
  p_pre_name in varchar2,
  p_obj_name in varchar2
) is
 l_owner# number;
 l_pre_id number;
 l_obj_id number;
 l_cla_id number;
begin
 select user# into l_owner# from sys.user$ where name = 'CTXSYS';
 select dr_id_seq.nextval into l_pre_id from dual;
 select obj_id, obj_cla_id into l_obj_id, l_cla_id from dr$object
  where obj_name = p_obj_name;
 insert into dr$preference 
   (pre_id, pre_name, pre_owner#, pre_obj_id, pre_cla_id, pre_valid) 
    values 
   (l_pre_id, p_pre_name, l_owner#, l_obj_id, l_cla_id, 'Y');
    
 commit;
end;
/
create or replace procedure dr$temp_cresg(
  p_pre_name in varchar2,
  p_obj_name in varchar2
) is
 l_owner# number;
 l_pre_id number;
 l_obj_id number;
 l_cla_id number;
begin
 select user# into l_owner# from sys.user$ where name = 'CTXSYS';
 select dr_id_seq.nextval into l_pre_id from dual;
 select obj_id into l_obj_id from dr$object where obj_name = p_obj_name;
 insert into dr$section_group(sgp_id, sgp_owner#, sgp_name, sgp_obj_id) 
 values                      (l_pre_id, l_owner#, p_pre_name, l_obj_id);
 commit;
end;
/

REM ========================================================================
REM  dr$unindexed
REM ========================================================================

PROMPT ... creating table dr$unindexed

create table dr$unindexed (
  unx_idx_id    number,
  unx_ixp_id    number,
  unx_rowid     rowid,
  constraint drc$unx_key primary key (unx_idx_id, unx_ixp_id, unx_rowid)
)
organization index;

REM ========================================================================
REM dr$pending
REM ========================================================================

alter table dr$pending add (pnd_lock_failed char(1));
update dr$pending set pnd_lock_failed = 'N';
commit;

REM ========================================================================
REM new view definitions
REM ========================================================================

create or replace view ctx_section_groups as
select
   u.name      sgp_owner,
   sgp_name,
   obj_name    sgp_type
from dr$section_group, dr$object, dr$class, sys.user$ u
where sgp_obj_id = obj_id
  and obj_system = 'N'
  and obj_cla_id = cla_id
  and cla_name = 'SECTION_GROUP'
  and sgp_owner# = u.user#
/

create or replace view ctx_user_section_groups as
select
   sgp_name,
   obj_name    sgp_type
from dr$section_group, dr$object, dr$class
where sgp_obj_id = obj_id
  and obj_system = 'N'
  and obj_cla_id = cla_id
  and cla_name = 'SECTION_GROUP'
  and sgp_owner# = userenv('SCHEMAID')
/

REM ========================================================================
REM BASIC LEXER - INDEX STEM
REM ========================================================================

delete from dr$object_attribute where oat_id = 60120;
delete from dr$object_attribute_lov where oal_oat_id = 60120;

insert into dr$object_attribute values
  (60120, 6, 1, 20, 
   'INDEX_STEMS', 'Language for indexing stemmer',
   'N', 'N', 'Y', 'I', 
   'NONE', null, null, 'Y');

insert into dr$object_attribute_lov values
  (60120, 'NONE', 0, 'Do not index stems');

insert into dr$object_attribute_lov values
  (60120, 'ENGLISH', 1, 'English (inflectional)');

insert into dr$object_attribute_lov values
  (60120, 'DERIVATIONAL', 2, 'English (derivational)');

insert into dr$object_attribute_lov values
  (60120, 'DUTCH', 3, 'Dutch');

insert into dr$object_attribute_lov values
  (60120, 'FRENCH', 4, 'French');

insert into dr$object_attribute_lov values
  (60120, 'GERMAN', 5, 'German');

insert into dr$object_attribute_lov values
  (60120, 'ITALIAN', 6, 'Italian');

insert into dr$object_attribute_lov values
  (60120, 'SPANISH', 7, 'Spanish');

commit;

REM ========================================================================
REM USER LEXER
REM ========================================================================

delete from dr$object where obj_cla_id = 6 and obj_id = 10;
delete from dr$object_attribute where oat_id = 61001;
delete from dr$object_attribute where oat_id = 61002;
delete from dr$object_attribute_lov where oal_oat_id = 61002;
delete from dr$object_attribute where oat_id = 61003;

insert into dr$object values
  (6, 10, 'USER_LEXER', 'user-defined lexer', 'N');

insert into dr$object_attribute values
  (61001, 6, 10, 1, 
   'INDEX_PROCEDURE', 'name of the indexing stored procedure',
   'Y', 'N', 'Y', 'S', 
   'REQUIRED', null, null, 'N');

insert into dr$object_attribute values
  (61002, 6, 10, 2, 
   'INPUT_TYPE', 'datatype of the input arguments of indexing stored procedure',
   'N', 'N', 'Y', 'I', 
   'CLOB', null, null, 'Y');

insert into dr$object_attribute_lov values
  (61002, 'CLOB', 1, 'CLOB');

insert into dr$object_attribute_lov values
  (61002, 'VARCHAR2', 2, 'VARCHAR2');

insert into dr$object_attribute values
  (61003, 6, 10, 3, 
   'QUERY_PROCEDURE', 'name of the query stored procedure',
   'Y', 'N', 'Y', 'S', 
   'REQUIRED', null, null, 'N');

commit;

REM ========================================================================
REM NULL LEXER
REM ========================================================================

delete from dr$object where obj_cla_id = 6 and obj_id = 9;
delete from dr$preference where pre_cla_id = 6 and pre_obj_id = 9;

insert into dr$object values
  (6, 9, 'NULL_LEXER', 'special lexer for use in ctxxpath indexes only', 'Y');

begin
  dr$temp_crepref('NULL_LEXER','NULL_LEXER');
end;
/

REM ========================================================================
REM CTXXPATH_SECTION_GROUP
REM ========================================================================

delete from dr$object where obj_cla_id = 5 and obj_id = 9;
delete from dr$section_group where sgp_obj_id = 9;
delete from dr$parameter where par_name = 'DEFAULT_CTXXPATH_STORAGE';

insert into dr$object values
  (5, 9, 'CTXXPATH_SECTION_GROUP', 
'special section group for ctxxpath indexes only', 'Y');

begin
  dr$temp_cresg('CTXXPATH_SECTION_GROUP','CTXXPATH_SECTION_GROUP');
end;
/

insert into dr$parameter (par_name, par_value)
values ('DEFAULT_CTXXPATH_STORAGE',     'CTXSYS.DEFAULT_STORAGE');

commit;

REM ========================================================================
REM BASIC_WORDLIST preference
REM ========================================================================

begin
  dr$temp_crepref('BASIC_WORDLIST','BASIC_WORDLIST');
end;
/

REM ========================================================================
REM URITYPE DATATYPE
REM ========================================================================

delete from dr$object where obj_cla_id = 2 and obj_id = 6;
delete from dr$preference where pre_cla_id = 2 and pre_obj_id = 6;

insert into dr$object values
  (2, 6, 'URITYPE_DATATYPE', '', 'Y');

begin
  dr$temp_crepref('URITYPE_DATATYPE','URITYPE_DATATYPE');
end;
/

REM ========================================================================
REM INSO FILTER
REM ========================================================================

delete from dr$object_attribute where oat_id = 40503;
delete from dr$object_attribute_lov where oal_oat_id = 40503;

insert into dr$object_attribute values
  (40503, 4, 5, 3, 
   'TIMEOUT_TYPE', 'Time-out type',
   'N', 'N', 'Y', 'I', 
   'HEURISTIC', null, null, 'Y');

insert into dr$object_attribute_lov values
  (40503, 'HEURISTIC', 1, 'Heuristic');

insert into dr$object_attribute_lov values
  (40503, 'FIXED', 2, 'Fixed');

commit;

REM ========================================================================
REM DR$POLICY_TAB
REM ========================================================================

CREATE TABLE dr$policy_tab
(
 plt_policy               CHAR(1),
 plt_langcol              CHAR(1)
);

GRANT select ON dr$policy_tab to public;

commit;

REM ========================================================================
REM dr$online_pending
REM ========================================================================

create table dr$online_pending (
  onl_cid             number not null,
  onl_rowid           varchar(18) not null,
  onl_indexpartition  varchar(30) default null,
  primary key (onl_cid, onl_rowid)
)
organization index
storage (freelists 10);


REM ========================================================================
REM CTX_VERSION
REM ========================================================================

REM this actually no longer needed since dr0plb.sql will recreate the 
REM version view.

REM ========================================================================
REM Recompile shared library 
REM ========================================================================

PROMPT STARTING DR0ULIB.SQL
@@dr0ulib.sql

REM ========================================================================
REM Recompile Packages
REM ========================================================================

PROMPT STARTING DR0PKH.SQL
@@dr0pkh.sql

REM due to bug 2154029, need ctxxpath type before running dridml.pkb
PROMPT installing ctxxpath type
@@dr0typex.pkh

PROMPT STARTING DR0PLB.SQL
@@dr0plb.sql

REM ========================================================================
REM classification
REM ========================================================================

insert into dr$class values
  (99, 'CLASSIFIER', 'classification preferences', 'N');

insert into dr$object values
  (99, 1, 'RULE_CLASSIFIER', 'rule based classifier', 'N');

insert into dr$object_attribute values
  (990101, 99, 1, 1, 
   'THRESHOLD', 'Minimum confidence level (in percentage) for rule generation for all classes',
   'N', 'N', 'Y', 'I', 
   '50', 1, 100, 'N');

insert into dr$object_attribute values
  (990102, 99, 1, 2, 
   'MAX_TERMS', 'Maximum number of terms in one class',
   'N', 'N', 'Y', 'I', 
   '100', 20, 2000, 'N');

insert into dr$object_attribute values
  (990103, 99, 1, 3, 
   'MEMORY_SIZE', 'Typical memory size in MB',
   'N', 'N', 'Y', 'I', 
   '500', 10, 2000000, 'N');

insert into dr$object_attribute values
  (990104, 99, 1, 4, 
   'NT_THRESHOLD', 'minimum term occurring frequency (in the fraction of total number of do cuments)',
   'N', 'N', 'Y', 'F', 
   '0.001', 0, 0.90, 'N');

insert into dr$object_attribute values
  (990105, 99, 1, 5, 
   'TERM_THRESHOLD', 'Threshold value (in percentage) for term selection in one class',
   'N', 'N', 'Y', 'I', 
   '10', 0, 100, 'N');

insert into dr$object_attribute values
  (990106, 99, 1, 6, 
   'TREENUM', 'Number of trees built for one class',
   'N', 'N', 'Y', 'I', 
   '1', 1, 10, 'N');

exec CTX_DDL.create_preference('DEFAULT_CLASSIFIER', 'RULE_CLASSIFIER');
insert into dr$parameter (par_name, par_value)
	 values ('DEFAULT_CLASSIFIER',     'CTXSYS.DEFAULT_CLASSIFIER');

PROMPT ... loading dr0cls.pkh
@@dr0cls.pkh
show errors
PROMPT ... loading dr0cls.plb
@@dr0cls.plb
show errors

create public synonym ctx_cls for ctxsys.ctx_cls;
grant execute on ctx_cls to ctxapp;


REM ========================================================================
REM default policy
REM ========================================================================

PROMPT creating default policy for ora:contains
begin
  CTX_DDL.create_policy('DEFAULT_POLICY_ORACONTAINS',
    filter        => 'CTXSYS.NULL_FILTER',
    section_group => 'CTXSYS.NULL_SECTION_GROUP',
    lexer         => 'CTXSYS.DEFAULT_LEXER',
    stoplist      => 'CTXSYS.DEFAULT_STOPLIST',
    wordlist      => 'CTXSYS.DEFAULT_WORDLIST'
);
end;
/

REM ========================================================================
REM Upgrade indextypes
REM ========================================================================

PROMPT ... running t0902000.sql to upgrade types
@@t0902000.sql

REM ========================================================================
REM Recompile errant objects
REM ========================================================================

declare
  cbody varchar2(10);
  otype varchar2(30);
begin
  for c1 in (select object_type, object_name 
             from user_objects 
             where status = 'INVALID'
             order by object_type) 
  loop
    otype := c1.object_type;
    cbody := null;

    if (c1.object_type = 'PACKAGE BODY') then
      otype := 'PACKAGE';
      cbody := 'BODY';
    elsif (c1.object_type = 'TYPE BODY') then
      otype := 'TYPE';
      cbody := 'BODY';
    elsif (c1.object_type = 'VIEW') then
      cbody := 'BODY';
    end if;
    
    begin
      execute immediate 
        'alter '||otype||' '||c1.object_name||' compile '||cbody;
    exception
       when others then null;
    end;
  end loop;
end;
/

REM ========================================================================
REM drop temporary versions of ctx_ddl calls
REM ========================================================================

drop procedure dr$temp_crepref;
drop procedure dr$temp_cresg;

REM ========================================================================
REM Registry to upgraded state
REM ========================================================================

declare
  ver varchar2(80);
begin
  select ver_dict into ver from ctx_version;
  dbms_registry.loaded('CONTEXT', ver, 
                       'Oracle Text Release '||ver||' - Production');

  -- we do not have a validation procedure at this time
  dbms_registry.valid('CONTEXT');
end;
/

REM ========================================================================
REM 4472797: Call ctxpatch to upgrade to latest patch set
REM ======================-=================================================
PROMPT ... calling ctxpatch.sql
@@ctxpatch.sql
