DROP TYPE dip_emd_odi_inst_array_type;
DROP TYPE dip_emd_odi_instances_type;

CREATE OR REPLACE TYPE dip_emd_odi_instances_type AS Object (
  instanceNum varchar2(16),
  odihost varchar2(256),
  ldapurl varchar2(256),
  starttm varchar2(32),
  retrycount varchar2(16));

/

CREATE OR REPLACE TYPE dip_emd_odi_inst_array_type AS TABLE OF dip_emd_odi_instances_type;
/

DROP TYPE dip_emd_profile_array_type;
DROP TYPE dip_emd_profile_type;

CREATE OR REPLACE TYPE dip_emd_profile_type AS Object (
    Name VARCHAR2(256),
    profileType  VARCHAR2(32),
    profileState  VARCHAR2(32),
    lastExecutionTime VARCHAR2(32),
    OIDlastChangeNum VARCHAR2(32),
    syncInterval VARCHAR2(32),
    profileStatus  VARCHAR2(256),
    lastErrors VARCHAR2(2048));

/

CREATE OR REPLACE TYPE dip_emd_profile_array_type AS TABLE OF dip_emd_profile_type;
/

CREATE OR REPLACE PACKAGE ODIGetDIPInfo IS

    PROCEDURE GetRunningInstances(outArray OUT dip_emd_odi_inst_array_type);




    PROCEDURE GetProfileInfo(outArray OUT dip_emd_profile_array_type);

    PROCEDURE GetInstanceProfileInfo(instance NUMBER, 
                                  outArray OUT dip_emd_profile_array_type);

    PROCEDURE GetSyncProfileInfo(instance NUMBER, 
                                  outArray IN OUT dip_emd_profile_array_type);

    PROCEDURE GetProvProfileInfo(instance NUMBER, 
                                  outArray IN OUT dip_emd_profile_array_type);

    PROCEDURE GetConfigSetFromInstance(instanceNum IN NUMBER,config OUT NUMBER);

    PROCEDURE profileExistInConfig(profileName IN VARCHAR2,
                                                 configSet IN NUMBER,
                                                 existing OUT NUMBER);

END ODIGetDIPInfo;
/

CREATE OR REPLACE PACKAGE BODY ODIGetDIPInfo AS

    profileCount NUMBER  ;

-- ---------------------------------------------------------------------------

    PROCEDURE GetRunningInstances(outArray OUT dip_emd_odi_inst_array_type) IS 

      varINSTANCE     VARCHAR2(32);
      varHOSTNAME     VARCHAR2(32);
      varLDAPHost     VARCHAR2(32);
      varLDAPPort     VARCHAR2(32);
      varCONFIGSET    VARCHAR2(32);
      varLASTWAKETIME VARCHAR2(32);
      varRETRYCOUNT   VARCHAR2(32);
      varFLAGS        VARCHAR2(256);
      varLDAPURL      VARCHAR2(256);
      testStr         VARCHAR2(256);

      instanceCount NUMBER;

      regHostName VARCHAR2(32);
      rdn         VARCHAR2(256);

      pos1 NUMBER;
      pos2 NUMBER;
      pos3 NUMBER;

      found NUMBER;

      CURSOR c_ODIREG IS SELECT rdn 
                         FROM ct_dn 
                WHERE 
                     rdn like '%orclhostname=%' 
                AND  parentdn like 'cn=oracle internet directory,cn=odi,%' 
                ORDER BY rdn ;

      CURSOR c_PROCESS (varhostName VARCHAR2) IS SELECT 
                    TO_CHAR(INSTANCE), 
                    HOSTNAME, 
                    TO_CHAR(CONFIGSET),
                    TO_CHAR(LASTWAKETIME,'DD-MON-YYYY HH24:MI:SS'),
                    TO_CHAR(RETRYCOUNT),
                    FLAGS
            FROM ods_process 
            WHERE 
              SERVERID = (SELECT SERVERID FROM ODS_SERVERS 
                          WHERE SERVERNAME='ODISRV')
              AND HOSTNAME = varhostName 
            ORDER BY INSTANCE ;

    BEGIN

      outArray := dip_emd_odi_inst_array_type();

      instanceCount := 0 ;
      found := 0 ;

      OPEN c_ODIREG ;
      LOOP
        FETCH c_ODIREG INTO rdn ;

        EXIT WHEN c_ODIREG%NOTFOUND;

        pos1 := INSTR(rdn,'orclhostname=',1,1) ;
        pos1 := INSTR(rdn,'=',pos1,1) ;
        regHostName :=  SUBSTR(rdn,pos1+1);

        IF ( INSTR(regHostName,'.',1,1) > 0)
        THEN
          pos1 := INSTR(regHostName,'.',1,1);
          regHostName := SUBSTR(regHostName,1,pos1-1);

        END IF;

        found := 0;

        DBMS_OUTPUT.PUT_LINE('Looking For Servers Running On Host :'|| 
                                                                 regHostName );

        OPEN c_PROCESS(regHostName) ;

        LOOP

          FETCH c_PROCESS INTO varINSTANCE,
                               varHOSTNAME,
                               varCONFIGSET,
                               varLASTWAKETIME,
                               varRETRYCOUNT,
                               varFLAGS ;

          EXIT WHEN c_PROCESS%NOTFOUND;
        
          found := 1 ;

          DBMS_OUTPUT.PUT_LINE('Found instance :'|| varINSTANCE );
  
          IF ( INSTR(varFLAGS, 'host=',1,1) <= 0 )
          THEN
            varLDAPHost := varHOSTNAME ;
          ELSE
            pos1 := INSTR(varFLAGS,'host=',1,1) ;
            pos2 := INSTR(varFLAGS,' ',pos1+5,1) ;
            varLDAPHost :=  SUBSTR(varFLAGS,pos1+5,pos2-(pos1+5));
          END IF ;

          DBMS_OUTPUT.PUT_LINE('FLAGS : ' || varFLAGS );

          IF ( INSTR(varFLAGS, 'port=',1,1) <= 0 )
          THEN
            varLDAPPort := '389' ;
          ELSE
            pos1 := INSTR(varFLAGS, 'port=',1,1) ;
            pos2 := INSTR(varFLAGS, ' ',pos1,1) ;

            IF (pos2 > 0)
            THEN
              varLDAPPort :=  SUBSTR(varFLAGS,pos1+5,pos2-(pos1+5));
            ELSE
              varLDAPPort :=  SUBSTR(varFLAGS,pos1+5);
            END IF;

          END IF ;

          outArray.extend;

          varLDAPURL := varLDAPHost || ':' || varLDAPPort ;

          outArray(instanceCount+1) := dip_emd_odi_instances_type(varINSTANCE,
                                                               varHOSTNAME,
                                                               varLDAPURL,
                                                               varLASTWAKETIME,
                                                               varRETRYCOUNT);

          instanceCount := instanceCount + 1;

        END LOOP;
        CLOSE c_PROCESS;

        IF (found = 0) 
        THEN
          -- INSERT SERVER DOWN ENTRY HERE
          outArray.extend;
          outArray(instanceCount+1) := dip_emd_odi_instances_type('0',
                                                               regHostName,
                                                               'N/A',
                                                               'DOWN',
                                                               'N/A');

          instanceCount := instanceCount + 1;
        END IF ;

      END LOOP;
      CLOSE c_ODIREG;

    END GetRunningInstances;


-- ---------------------------------------------------------------------------

    PROCEDURE GetConfigSetFromInstance(instanceNum IN NUMBER,
                                       config OUT NUMBER) IS
      CURSOR c_ODSPROCESS IS 
                        SELECT 
                            configset
                        FROM ODS_PROCESS 
                        WHERE 
                          SERVERID = (SELECT SERVERID FROM ODS_SERVERS 
                                      WHERE SERVERNAME='ODISRV')
                      AND INSTANCE = instanceNum  ;

    BEGIN

      config := -1 ;

      OPEN c_ODSPROCESS ;
      LOOP
        FETCH c_ODSPROCESS INTO config;
        EXIT;
      END LOOP ;
      CLOSE c_ODSPROCESS;

      --DBMS_OUTPUT.PUT_LINE('Retrieved ConfigSet From Instance ' || 
                                   --instanceNum || ' : ' || config );

    END GetConfigSetFromInstance ;

-- ---------------------------------------------------------------------------

    PROCEDURE profileExistInConfig(profileName IN VARCHAR2,
                                   configSet IN NUMBER,
                                   existing OUT NUMBER)  IS

      EntryIdentifier NUMBER;
      configRDN VARCHAR2(32);
      profileDN VARCHAR2(256);
      profileRDN VARCHAR2(256);

      pos  NUMBER;

      CURSOR c_DNCatalog(configsetRDN IN VARCHAR2) IS 
                        SELECT 
                            entryid
                        FROM ct_dn 
                        WHERE 
                          rdn = configsetRDN
                        AND parentdn like 'cn=oracle internet directory,cn=configsets,cn=metadird,%' ;

      CURSOR c_DSATTRSTORE (EntryIdent IN NUMBER) IS 
                          SELECT attrval 
                          FROM 
                               ds_attrstore 
                          WHERE entryid = EntryIdent
                          AND   LOWER(attrname) =  'orclodipconfigdns' ;

    BEGIN

      configRDN := 'cn=configset' || configSet ;

      existing := 0 ;

      OPEN c_DNCatalog(configRDN);
      LOOP
        FETCH c_DNCatalog INTO EntryIdentifier;
        EXIT WHEN c_DNCatalog%NOTFOUND;

        OPEN c_DSATTRSTORE(EntryIdentifier);
        LOOP
          FETCH c_DSATTRSTORE INTO profileDN;
          EXIT WHEN c_DSATTRSTORE%NOTFOUND;

          pos := INSTR(LOWER(profileDN),'cn=subscriber profile',1,1) ;

          profileRDN := SUBSTR(profileDN,1,pos);

          IF ( INSTR(LOWER(profileRDN),LOWER(profileName),1,1) > 0 )
          THEN
            existing := 1 ;
            EXIT ;
          END IF ;

        END LOOP ;
        CLOSE c_DSATTRSTORE;

        EXIT ;

      END LOOP ;
      CLOSE c_DNCatalog;

    END profileExistInConfig;

-- ---------------------------------------------------------------------------

    PROCEDURE GetProfileInfo(outArray OUT dip_emd_profile_array_type) IS

    BEGIN

      profileCount := 0 ;

      outArray := dip_emd_profile_array_type();

      GetSyncProfileInfo(-1,outArray);
      GetProvProfileInfo(-1,outArray);

    END GetProfileInfo;

-- ---------------------------------------------------------------------------

    PROCEDURE GetInstanceProfileInfo(instance IN NUMBER ,
                             outArray OUT dip_emd_profile_array_type) IS

    BEGIN

      profileCount := 0 ;

      outArray := dip_emd_profile_array_type();

      GetSyncProfileInfo(instance,outArray);
      GetProvProfileInfo(instance,outArray);

    END GetInstanceProfileInfo;

-- ---------------------------------------------------------------------------

    PROCEDURE GetSyncProfileInfo(instance IN NUMBER,
                                 outArray IN OUT dip_emd_profile_array_type) IS

      EntryIdentifier NUMBER;
      RDN VARCHAR2(256);

      attrName VARCHAR2(256);
      attrVal  VARCHAR2(2048);

      configSet NUMBER;
      existing NUMBER;

      agentName VARCHAR2(256);
      agentcontrol VARCHAR2(32);
      lastexectime VARCHAR2(32);
      OIDlastappliedChgnum VARCHAR2(32);
      syncInterval VARCHAR2(32);
      synchronizationstatus VARCHAR2(256);
      profileStatus VARCHAR2(256);
      synchronizationerrors VARCHAR2(2048);

      convDate DATE ;

      CURSOR c_DNCatalog IS 
                        SELECT 
                            entryid ,rdn 
                        FROM ct_dn 
                        WHERE 
                  parentdn like 'cn=oracle internet directory,cn=changelog subscriber,cn=subscriber profile,%' 
                        ORDER BY rdn ;

      CURSOR c_DSATTRSTORE (EntryIdent IN NUMBER) IS 
                              SELECT LOWER(attrname),
                                     attrval 
                              FROM 
                                   ds_attrstore 
                              WHERE entryid = EntryIdent
                              AND   LOWER(attrname) IN 
                                      ('orclodipagentname',
                                       'orclodipagentcontrol',
                                       'orclodiplastexecutiontime',
                                       'orcllastappliedchangenumber',
                                       'orclodipschedulinginterval',
                                       'orclodipsynchronizationstatus',
                                       'orclodipsynchronizationerrors') ;

    BEGIN

      configSet := -1 ;
      existing := 0;

      DBMS_OUTPUT.PUT_LINE('Retrieving Synchronization Profile ...');

      IF (instance >= 1) 
      THEN
        GetConfigSetFromInstance(instance,configSet);
        IF (configSet = -1 )
        THEN
          RETURN ;
        END IF ;
      END IF;

      OPEN c_DNCatalog ;

      LOOP

        FETCH c_DNCatalog INTO EntryIdentifier,RDN ;
        EXIT WHEN c_DNCatalog%NOTFOUND;

        --DBMS_OUTPUT.PUT_LINE('Fetched EntryID :'|| EntryIdentifier );
        --DBMS_OUTPUT.PUT_LINE('RDN:'|| RDN );

        agentName := ' ';
        agentcontrol := ' ';
        lastexectime := 'Not Executed Yet';
        OIDlastappliedChgnum := 'N/A';
        syncInterval := '60';
        synchronizationstatus := 'N/A';
        synchronizationerrors := 'N/A';

        OPEN c_DSATTRSTORE(EntryIdentifier);

        LOOP

          existing := 1;

          FETCH c_DSATTRSTORE INTO attrName,attrVal ;
          EXIT WHEN c_DSATTRSTORE%NOTFOUND;

          --DBMS_OUTPUT.PUT_LINE('Got Attr :'|| attrName );
          --DBMS_OUTPUT.PUT_LINE('and Value :'|| attrVal );

          IF ( attrName = 'orclodipagentname' )
          THEN
            agentName := attrVal;

            IF (configSet != -1 )
            THEN
              --DBMS_OUTPUT.PUT_LINE('Checking Existance Of Profile : ' ||
                                    --agentName || ' against ConfigSet : ' ||
                                    --configSet );
              profileExistInConfig(agentName,configSet,existing);

              --DBMS_OUTPUT.PUT_LINE('Existing  : ' || existing );

              IF ( existing = 0 )
              THEN
                EXIT ;
              END IF ;
            END IF;
          ELSIF ( attrName = 'orclodipagentcontrol' )
          THEN
            IF ( INSTR(lower(attrval),'enable',1) > 0)
            THEN
              agentcontrol := 'ENABLED';
            ELSE
              agentcontrol := 'DISABLED';
            END IF;
          ELSIF ( attrName = 'orclodiplastexecutiontime' )
          THEN
            SELECT TO_DATE(attrVal,'YYYYMMDDHH24MISS') INTO 
                   convDate FROM DUAL ;
            SELECT TO_CHAR(convDate,'DD-MON-YYYY HH24:MI:SS') iNTO 
                   lastexectime FROM DUAL ;
          ELSIF ( attrName = 'orcllastappliedchangenumber' )
          THEN
            OIDlastappliedChgnum := attrVal;
          ELSIF ( attrName = 'orclodipschedulinginterval' )
          THEN
            syncInterval := attrVal;
          ELSIF ( attrName = 'orclodipsynchronizationstatus' )
          THEN
            synchronizationstatus := attrVal;
          ELSIF ( attrName = 'orclodipsynchronizationerrors' )
          THEN
            IF (synchronizationerrors != 'N/A')
            THEN
              synchronizationerrors := synchronizationerrors || '\n' || attrVal;
            ELSE
              synchronizationerrors := attrVal;
            END IF;
          END IF;

        END LOOP;
        CLOSE c_DSATTRSTORE;

        IF ( existing != 0 )
        THEN

          outArray.extend;

          outArray(profileCount+1) := dip_emd_profile_type(agentName,
                                                      'SYNCHRONIZATION',
                                                       agentcontrol,
                                                       lastexectime,
                                                       OIDlastappliedChgnum,
                                                       syncInterval,
                                                       synchronizationstatus,
                                                       synchronizationerrors);

          profileCount := profileCount + 1;

        END IF;

      END LOOP;
      CLOSE c_DNCatalog;

    END GetSyncProfileInfo;

-- ---------------------------------------------------------------------------

    PROCEDURE GetProvProfileInfo(instance IN NUMBER,
                                 outArray IN OUT dip_emd_profile_array_type) IS

      EntryIdentifier NUMBER;
      RDN VARCHAR2(256);

      attrName VARCHAR2(256);
      attrVal  VARCHAR2(2048);

      configSet NUMBER;
      existing NUMBER;

      profileName VARCHAR2(256);
      profileProvAppName VARCHAR2(256);
      profileProvOrgName VARCHAR2(256);
      profileStatus VARCHAR2(32);
      profileLastProcessingTime VARCHAR2(32);
      OIDlastappliedChgnum VARCHAR2(32);
      profileSchedule VARCHAR2(32);
      profileProcessingStatus VARCHAR2(256);
      profileProcessingErrors VARCHAR2(256);
      
      convDate DATE ;

      CURSOR c_DNCatalog IS 
                        SELECT 
                            entryid ,rdn 
                        FROM ct_dn 
                        WHERE 
                  parentdn like 'cn=oracle internet directory,cn=changelog subscriber,cn=provisioning profiles,%' 
                        ORDER BY rdn ;

      CURSOR c_DSATTRSTORE (EntryIdent IN NUMBER) IS 
                              SELECT LOWER(attrname),
                                     attrval 
                              FROM 
                                   ds_attrstore 
                              WHERE entryid = EntryIdent
                              AND   LOWER(attrname) IN 
                                      ('orclodipprofilename',
                                       'orclstatus',
                                       'orclodipprofilelastprocessingtime',
                                       'orcllastappliedchangenumber',
                                       'orclodipprofileschedule',
                                       'orclodipprovisioningappname',
                                       'orclodipprovisioningorgname',
                                       'orclodipprofileprocessingstatus',
                                       'orclodipprofileprocessingerrors') ;

    BEGIN

      DBMS_OUTPUT.PUT_LINE('Retrieving Provisioning Profile ...');

      configSet := -1 ;

      IF (instance >= 1) 
      THEN
        GetConfigSetFromInstance(instance,configSet);
        IF (configSet != 0)
        THEN
          RETURN;
        END IF;
      END IF;

      OPEN c_DNCatalog ;

      LOOP

        FETCH c_DNCatalog INTO EntryIdentifier,RDN ;
        EXIT WHEN c_DNCatalog%NOTFOUND;

        --DBMS_OUTPUT.PUT_LINE('Fetched EntryID :'|| EntryIdentifier );
        --DBMS_OUTPUT.PUT_LINE('RDN:'|| RDN );

        profileName := '';
        profileStatus := '';
        profileLastProcessingTime := 'Not Executed Yet';
        OIDlastappliedChgnum := 'Not Executed Yet';
        profileSchedule := '';
        profileProcessingStatus := 'N/A';
        profileProvAppName := '';
        profileProvOrgName := '';
        profileProcessingErrors := 'N/A';
      
        OPEN c_DSATTRSTORE(EntryIdentifier);

        LOOP

          FETCH c_DSATTRSTORE INTO attrName,attrVal ;
          EXIT WHEN c_DSATTRSTORE%NOTFOUND;

          --DBMS_OUTPUT.PUT_LINE('Got Attr :'|| attrName );
          --DBMS_OUTPUT.PUT_LINE('and Value :'|| attrVal );

          IF ( attrName = 'orclodipprofilename' )
          THEN
            profileName := attrVal;
          ELSIF ( attrName = 'orclstatus' )
          THEN
            IF ( INSTR(lower(attrval),'enable',1) > 0)
            THEN
              profileStatus := 'ENABLED';
            ELSE
              profileStatus := 'DISABLED';
            END IF;
          ELSIF ( attrName = 'orclodipprofilelastprocessingtime' )
          THEN
            SELECT TO_DATE(attrVal,'YYYYMMDDHH24MISS') INTO 
                   convDate FROM DUAL ;
            SELECT TO_CHAR(convDate,'DD-MON-YYYY HH24:MI:SS') iNTO 
                   profileLastProcessingTime FROM DUAL ;
          ELSIF ( attrName = 'orcllastappliedchangenumber' )
          THEN
            OIDlastappliedChgnum := attrVal;
          ELSIF ( attrName = 'orclodipprofileschedule' )
          THEN
            profileSchedule := attrVal;
          ELSIF ( attrName = 'orclodipprofileprocessingstatus' )
          THEN
            profileProcessingStatus := attrVal;
          ELSIF ( attrName = 'orclodipprovisioningappname' )
          THEN
            profileProvAppName := attrVal;
          ELSIF ( attrName = 'orclodipprovisioningorgname' )
          THEN
            profileProvOrgName := attrVal;
          ELSIF ( attrName = 'orclodipprofileprocessingerrors' )
          THEN
            IF (profileProcessingErrors != 'N/A')
            THEN
              profileProcessingErrors := profileProcessingErrors || '\n' || attrVal;
            ELSE
              profileProcessingErrors := attrVal;
            END IF;
          END IF;

        END LOOP;
        CLOSE c_DSATTRSTORE;

        outArray.extend;

        DBMS_OUTPUT.PUT_LINE('Org Name :'|| profileProvOrgName );

        profileName := profileProvAppName || ' (for ' || profileProvOrgName
                        || ' )' ;

        outArray(profileCount+1) := dip_emd_profile_type(profileName,
                                                      'PROVISIONING',
                                                      profileStatus,
                                                      profileLastProcessingTime,
                                                      OIDlastappliedChgnum,
                                                      profileSchedule,
                                                      profileProcessingStatus,
                                                      profileProcessingErrors);

        profileCount := profileCount + 1;

      END LOOP;
      CLOSE c_DNCatalog;

    END GetProvProfileInfo;

-- ---------------------------------------------------------------------------

END ODIGetDIPInfo;
/

-- ------------------------- LDAP server config set --------------------------

DROP TYPE oid_configset_array_type;
DROP TYPE oid_configset_type;

CREATE OR REPLACE TYPE oid_configset_type AS Object (
 configSetNo        varchar2(4000),
 nonSslPort         varchar2(4000),
 maxCc              varchar2(4000),
 serverProc         varchar2(4000),
 sslEnable          varchar2(4000),
 sslPort            varchar2(4000),
 sslWalletURL       varchar2(4000),
 sslVer             varchar2(4000),
 sslAuthentication  varchar2(4000)
);
/

CREATE OR REPLACE TYPE oid_configset_array_type AS TABLE OF oid_configset_type;
/

CREATE OR REPLACE PACKAGE OIDconfigInfo IS

PROCEDURE GetConfigSetInfo (outArray OUT oid_configset_array_type);

END OIDconfigInfo;
/

CREATE OR REPLACE PACKAGE BODY OIDconfigInfo AS

  PROCEDURE GetConfigSetInfo (outArray OUT oid_configset_array_type) IS

    configSetNo        varchar2(4000);
    configCount        NUMBER;
    entryID            NUMBER;
    attrName           VARCHAR2(255);
    attrVal            VARCHAR2(4000);

    nonSslPort         varchar2(4000);
    maxCc              varchar2(4000);
    serverProc         varchar2(4000);
    sslEnable          varchar2(4000);
    sslPort            varchar2(4000);
    sslWalletURL       varchar2(4000);
    sslVer             varchar2(4000);
    sslAuthentication  varchar2(4000);

    CURSOR cursConfigSetEntryNo IS
                      SELECT
                        DISTINCT
                        SUBSTR(RDN, 13),
                        ENTRYID
                      FROM
                        CT_DN
                      WHERE
                        LOWER(RDN) LIKE '%configset%' AND
                        LOWER(PARENTDN) LIKE '%subconfigsubentry%osdldapd%'
                        ORDER BY TO_NUMBER(SUBSTR(RDN, 13)), ENTRYID;

    CURSOR cursConfigSetInfo (eID IN NUMBER) IS
                      SELECT
                        LOWER(ATTRNAME),
                        ATTRVAL
                      FROM
                        DS_ATTRSTORE 
                      WHERE
                        ENTRYID = eID AND 
                        LOWER(ATTRNAME) 
                        IN 
                          ('orclnonsslport', 
                           'orclmaxcc', 
                           'orclserverprocs', 
                           'orclsslenable', 
                           'orclsslport', 
                           'orclsslwalleturl', 
                           'orclsslversion', 
                           'orclsslauthentication'
                          ); 

    BEGIN

    outArray := oid_configset_array_type();
    configCount := 1;
    configSetNo := '';
    attrName := '';
    attrVal := '';

    nonSslPort := '';
    maxCc := '';
    serverProc := '';
    sslEnable := '';
    sslPort := '';
    sslWalletURL := '';
    sslVer := '';
    sslAuthentication := '';    

    OPEN cursConfigSetEntryNo;
    LOOP
      FETCH cursConfigSetEntryNo INTO configSetNo, entryID;
      EXIT WHEN cursConfigSetEntryNo%NOTFOUND;

      nonSslPort := '';
      maxCc := '';
      serverProc := '';
      sslEnable := '';
      sslPort := '';
      sslWalletURL := '';
      sslVer := '';
      sslAuthentication := '';    

      OPEN cursConfigSetInfo(entryID);
      LOOP
        FETCH cursConfigSetInfo INTO attrName, attrVal;
        EXIT WHEN cursConfigSetInfo%NOTFOUND;

        IF (attrName = 'orclnonsslport')
        THEN
          nonSslPort := attrVal;
        ELSIF (attrName = 'orclmaxcc')
        THEN
          maxCc := attrVal; 
        ELSIF (attrName = 'orclserverprocs')
        THEN
          serverProc := attrVal; 
        ELSIF (attrName = 'orclsslenable')
        THEN
          sslEnable := attrVal; 
        ELSIF (attrName = 'orclsslport')
        THEN
          sslPort := attrVal; 
        ELSIF (attrName = 'orclsslwalleturl')
        THEN
          sslWalletURL := attrVal; 
        ELSIF (attrName = 'orclsslversion')
        THEN
          sslVer := attrVal; 
        ELSIF (attrName = 'orclsslauthentication')
        THEN
          sslAuthentication := attrVal; 
        END IF;

      END LOOP;
      CLOSE cursConfigSetInfo;

      outArray.extend;
      outArray(configCount) := oid_configset_type(configSetNo,
                                                  nonSslPort,
                                                  maxCc,
                                                  serverProc,
                                                  sslEnable,
                                                  sslPort,
                                                  sslWalletURL,
                                                  sslVer,
                                                  sslAuthentication);
      configCount := configCount + 1;

    END LOOP;
    CLOSE cursConfigSetEntryNo;

  END GetConfigSetInfo;

END OIDconfigInfo;
/
 

