-- Remove some portion of the dictionary objects created by initdbj.sql

-- This script must be run as a subscript of a script which sets the
-- variable jvmrmaction.
-- Possible values are
--  FULL_REMOVAL:        remove all java related objects
--  DOWNGRADE_8.1.7_TO_8.1.6: remove or massage system objects as appropriate
--                       when downgrading from 8.1.7 to 8.1.6
--  DOWNGRADE_8.1.6_TO_8.1.5: remove or massage system objects as appropriate
--                       when downgrading from 8.1.6 to 8.1.5 (after having
--                       earlier downgraded from 8.1.7 to 8.1.6)
--  GRADE_REMOVAL:       remove java related objects as appropriate during
--                       upgrade or downgrade
--  NONE:                do nothing


print jvmrmaction

begin if :jvmrmaction = 'FULL_REMOVAL' or
         (:jvmrmaction = 'GRADE_REMOVAL' and
          initjvmaux.startstep('JVMRMDBJ')) then

initjvmaux.drp('drop package dbms_java');
initjvmaux.drp('drop PUBLIC SYNONYM dbms_java');
initjvmaux.drp('drop FUNCTION dbj_long_name');
initjvmaux.drp('drop function "NameFromLastDDL"');
initjvmaux.drp('drop PUBLIC SYNONYM "NameFromLastDDL"');
initjvmaux.drp('drop FUNCTION dbj_short_name');
initjvmaux.drp('drop PUBLIC SYNONYM dbj_short_name');

if :jvmrmaction = 'GRADE_REMOVAL' then initjvmaux.endstep; end if;

end if;end;
/
