-- Remove some portion of the dictionary objects created by initsec.sql

-- This script must be run as a subscript of a script which sets the
-- variable jvmrmaction.
-- Possible values are
--  FULL_REMOVAL:        remove all java related objects
--  DOWNGRADE_8.1.7_TO_8.1.6: remove or massage system objects as appropriate
--                       when downgrading from 8.1.7 to 8.1.6
--  DOWNGRADE_8.1.6_TO_8.1.5: remove or massage system objects as appropriate
--                       when downgrading from 8.1.6 to 8.1.5 (after having
--                       earlier downgraded from 8.1.7 to 8.1.6)
--  GRADE_REMOVAL:       remove java related objects as appropriate during
--                       upgrade or downgrade
--  NONE:                do nothing

print jvmrmaction

--- The following form will generate errors if the view dba_java_policy
--- is not yet defined, as will typically be the case when this script is
--- called from initsec.  These errors can be ignored.

begin if :jvmrmaction = 'DOWNGRADE_8.1.7_TO_8.1.6' then

if initjvmaux.startstep('REMOVE_JAVA_DEPLOY_PERMISSIONS') then

--- remove JAVA_DEPLOY permissions
initjvmaux.exec('
declare
  CURSOR D is
    select SEQ from dba_java_policy where GRANTEE = ''JAVA_DEPLOY'' ;
  ROW integer;
begin
  open D;
  loop
    fetch D into row;
    exit when D%NOTFOUND;
    -- dbms_output.put_line(row);
    dbms_java.disable_permission(row);
    dbms_java.delete_permission(row);
  end loop;
end;
');


initjvmaux.endstep; end if;

end if; end;
/

begin if :jvmrmaction = 'DOWNGRADE_9.2.0_TO_9.0.1' then

if initjvmaux.startstep('REMOVE_JAVA_DEPLOY_FILE_PERMISSIONS') then

  initjvmaux.exec('
  begin
  dbms_java.revoke_permission( ''JAVA_DEPLOY'', ''SYS:java.io.FilePermission'', ''javavm/admin/*'', ''write'' );
  dbms_java.revoke_permission( ''JAVA_DEPLOY'', ''SYS:java.io.FilePermission'', ''javavm/deploy/*'', ''read'' );
  end;
  ');

  initjvmaux.endstep;

end if;

if initjvmaux.startstep('REMOVE_SQLPERMISSION_PERMISSIONS') then

  --- remove SQLPermission related rows
  initjvmaux.exec('
    declare
      CURSOR D is 
        select SEQ from dba_java_policy where 
          ( name like ''%java.sql.SQLPermission%'' and 
            type_name like ''%.PolicyTablePermission'' ) or 
          type_name = ''java.sql.SQLPermission'' ;
      ROW integer;
    begin
      open D;
      loop
        fetch D into row;
        exit when D%NOTFOUND;
        -- dbms_output.put_line(row);
        dbms_java.disable_permission(row);
        dbms_java.delete_permission(row);
      end loop;
    end;
      ');
    
  initjvmaux.endstep; end if;
  
end if; end;
/   

begin if :jvmrmaction = 'FULL_REMOVAL' or 
         (:jvmrmaction = 'DOWNGRADE_8.1.7_TO_8.1.6' and
          initjvmaux.startstep('DROP_817_SECURITY_TABLES_ETC')) then

initjvmaux.drp('drop TABLE java$policy$shared$table');
initjvmaux.drp('drop ROLE java_deploy');

if :jvmrmaction = 'DOWNGRADE_8.1.7_TO_8.1.6' then initjvmaux.endstep; end if;

end if;end;
/

begin if :jvmrmaction = 'FULL_REMOVAL' or
         (:jvmrmaction = 'DOWNGRADE_8.1.6_TO_8.1.5' and
          initjvmaux.startstep('DROP_816_SECURITY_TABLES_ETC')) then

initjvmaux.drp('drop TABLE java$policy$');
initjvmaux.drp('drop SEQUENCE java$policy$sequence$');
initjvmaux.drp('drop VIEW dba_java_policy');
initjvmaux.drp('drop PUBLIC SYNONYM dba_java_policy');
initjvmaux.drp('drop VIEW user_java_policy');
initjvmaux.drp('drop PUBLIC SYNONYM user_java_policy');
initjvmaux.drp('drop ROLE java_admin');

if :jvmrmaction = 'DOWNGRADE_8.1.6_TO_8.1.5' then initjvmaux.endstep; end if;

end if;end;
/

begin if :jvmrmaction = 'FULL_REMOVAL' then

-- We go through and drop all shared data objects with names
-- beginning with JAVA$POLICY$SHARED$ 

declare 
  cursor S is
     select 'DROP JAVA DATA "' || object_name || '"' from user_objects 
       where object_type = 'JAVA DATA' 
             and object_name like 'JAVA$POLICY$SHARED$%';
   DDL_CURSOR integer;
begin
  open S;
  DDL_CURSOR := dbms_sql.open_cursor;
  loop
    declare 
      cmd varchar2(50);
    begin
      fetch S into cmd;
      exit when S%NOTFOUND;
      -- I execute the ddl directly rather than using initjvmaux.drp
      -- because for reasons I don't understand initjvmaux.drp is
      -- causing a crash - jschwarz 3/2000
      dbms_sql.parse(DDL_CURSOR, cmd, dbms_sql.native);
    exception
      when others then
        null;
    end;
  end loop;
  dbms_sql.close_cursor(DDL_CURSOR);
  close S;
end;

end if;end;
/
