-- create java$policy$ table and views

create table java$policy$
(
        kind# number,
        grantee# number,
        type_schema# number,        
        type_name varchar2(4000),
        name varchar2(4000),
        action varchar2(4000),
        status# number,
        key number
);

create sequence java$policy$sequence$;

-- Explicitly "bootstrap" rows into table that are needed to execute the
-- grant's below.
begin if initjvmaux.startstep('JVMSEC1_INSERT1') then

initjvmaux.exec('

insert into java$policy$
  values( 0, 0,
          0, ''java.lang.RuntimePermission'', ''createClassLoader'', null,
          2, java$policy$sequence$.nextval ) 
');

initjvmaux.endstep; end if; end;
/

begin if initjvmaux.startstep('JVMSEC1_INSERT2') then

initjvmaux.exec('

insert into java$policy$
  values( 0, 1,
          0, ''java.util.PropertyPermission'', ''*'', ''read'',
          2, java$policy$sequence$.nextval )
');

initjvmaux.endstep; end if; end;
/



-- a table java$policy$shared$version is created below.  See the
-- comment there for an explanation of why creation is deferred.

create or replace view dba_java_policy 
   (kind, grantee, type_schema, type_name, name, action, enabled, seq) 
as select 
   decode(jp.kind#, 0, 'GRANT', 1, 'RESTRICT'),
   u.name,
   ut.name,
   jp.type_name,
   jp.name,
   jp.action,
   decode(jp.status#, 2, 'ENABLED', 3, 'DISABLED'),
   jp.key
from 
  java$policy$ jp, sys.user$ u, sys.user$ ut
where
  jp.grantee# = u.user# and jp.type_schema# = ut.user# 
order by u.name, ut.name, jp.type_name, jp.name, jp.action;

comment on table dba_java_policy is
'java security Permissions for all users';


create public synonym DBA_JAVA_POLICY for DBA_JAVA_POLICY;

grant select on DBA_JAVA_POLICY to select_catalog_role;

create or replace view user_java_policy 
  (kind, grantee_name, type_schema, type_name,  name, action, enabled, seq) 
as select 
  djp.kind, djp.grantee, djp.type_schema,
  djp.type_name, djp.name, djp.action, djp.enabled, djp.seq
from 
  dba_java_policy djp, sys.user$ u
where 
  u.name = djp.grantee and
  ( ( u.user# in ( select distinct privilege# from SYS.SYSAUTH$ 
               where privilege# > 0 
               start with grantee# = userenv('SCHEMAID') 
               connect by PRIOR  privilege# = grantee# ) )
     or u.name = 'PUBLIC' 
     or u.user# = userenv('SCHEMAID') );

comment on table user_java_policy is
'java security Permissions for current user';

create public synonym USER_JAVA_POLICY for USER_JAVA_POLICY;

grant select on USER_JAVA_POLICY to PUBLIC with grant option;

-- The role that has the right to administer JAVA Permissions
create role java_admin;
grant java_admin to dba;

