-- populate the policy table

-- make the bedrock principal explicit.
-- This is done twice for a subtle reason.  
-- If initsec has run previously (so there is an SRO in use)
-- the code in jvmrmsec will drop the SRO. If the SRO is in use
-- in the current session it will cause an ORA-29549 (session state cleared)
-- first time you try to run java.  The first call to dbms_java.grant_policy_permission
-- will be that call.
-- Since grant_policy_permission doesn't do anything if the Permission has already been
-- granted calling it twice is harmless.
call dbms_java.grant_policy_permission('SYS', 'SYS', 'oracle.aurora.rdbms.security.PolicyTablePermission', '*');
call dbms_java.grant_policy_permission('SYS', 'SYS', 'oracle.aurora.rdbms.security.PolicyTablePermission', '*');


commit;

-- grant to JAVA_ADMIN the right to administer all known permissions. 
call dbms_java.grant_policy_permission('JAVA_ADMIN', 'SYS', 'oracle.aurora.rdbms.security.PolicyTablePermission', '*');
call dbms_java.grant_policy_permission('JAVA_ADMIN', 'SYS', 'java.util.PropertyPermission', '*');
call dbms_java.grant_policy_permission('JAVA_ADMIN', 'SYS', 'java.io.SerializablePermission', '*');
call dbms_java.grant_policy_permission('JAVA_ADMIN', 'SYS', 'java.io.FilePermission', '*');
call dbms_java.grant_policy_permission('JAVA_ADMIN', 'SYS', 'java.net.NetPermission', '*');
call dbms_java.grant_policy_permission('JAVA_ADMIN', 'SYS', 'java.net.SocketPermission', '*');
call dbms_java.grant_policy_permission('JAVA_ADMIN', 'SYS', 'java.security.SecurityPermission', '*');
call dbms_java.grant_policy_permission('JAVA_ADMIN', 'SYS', 'java.lang.RuntimePermission', '*');
call dbms_java.grant_policy_permission('JAVA_ADMIN', 'SYS', 'java.lang.reflect.ReflectPermission', '*');
call dbms_java.grant_policy_permission('JAVA_ADMIN', 'SYS', 'java.security.AllPermission', '*');
call dbms_java.grant_policy_permission('JAVA_ADMIN', 'SYS', 'oracle.aurora.security.JServerPermission', '*');
commit;

-- grant some Permissions to PUBLIC 
call dbms_java.grant_permission('PUBLIC', 'SYS:java.util.PropertyPermission', '*', 'read');
call dbms_java.grant_permission('PUBLIC', 'SYS:java.util.PropertyPermission', 'user.language', 'write');
call dbms_java.grant_permission('PUBLIC', 'SYS:java.lang.RuntimePermission','exitVM', null);
call dbms_java.grant_permission('PUBLIC', 'SYS:java.lang.RuntimePermission','createSecurityManager', null);
call dbms_java.grant_permission('PUBLIC', 'SYS:java.lang.RuntimePermission','modifyThread', null);
call dbms_java.grant_permission('PUBLIC', 'SYS:java.lang.RuntimePermission','modifyThreadGroup', null);

-- Subject to restrictions, anybody can load any class
call dbms_java.grant_permission('PUBLIC', 'SYS:oracle.aurora.security.JServerPermission', 'LoadClassInPackage.*', null);
call dbms_java.restrict_permission('PUBLIC', 'SYS:oracle.aurora.security.JServerPermission', 'LoadClassInPackage.java.*', null);
call dbms_java.restrict_permission('PUBLIC', 'SYS:oracle.aurora.security.JServerPermission', 'LoadClassInPackage.oracle.aurora.*', null);
call dbms_java.restrict_permission('PUBLIC', 'SYS:oracle.aurora.security.JServerPermission', 'LoadClassInPackage.oracle.jdbc.*', null);


