-- grant some Permissions to JavaUserPriv
call dbms_java.grant_permission('JAVAUSERPRIV', 'SYS:java.net.SocketPermission', '*', 'connect,resolve');
call dbms_java.grant_permission('JAVAUSERPRIV', 'SYS:java.io.FilePermission', '<<ALL FILES>>', 'read');
call dbms_java.grant_permission('JAVAUSERPRIV', 'SYS:java.lang.RuntimePermission', 'getProtectionDomain', null);
call dbms_java.grant_permission('JAVAUSERPRIV', 'SYS:java.lang.RuntimePermission', 'accessClassInPackage.*', null);
call dbms_java.grant_permission('JAVAUSERPRIV', 'SYS:java.lang.RuntimePermission', 'defineClassInPackage.*', null);
call dbms_java.grant_permission('JAVAUSERPRIV', 'SYS:java.lang.RuntimePermission', 'stopThread', null);

-- grant some Permissions to JavaSysPriv
call dbms_java.grant_permission('JAVASYSPRIV', 'SYS:java.io.SerializablePermission', '*', null);
call dbms_java.grant_permission('JAVASYSPRIV', 'SYS:java.io.FilePermission', '<<ALL FILES>>', 'read,write,execute,delete');
call dbms_java.grant_permission('JAVASYSPRIV', 'SYS:java.net.SocketPermission', '*', 'accept,connect,listen,resolve');
call dbms_java.grant_permission('JAVASYSPRIV', 'SYS:java.lang.RuntimePermission', 'createClassLoader', null);
call dbms_java.grant_permission('JAVASYSPRIV', 'SYS:java.lang.RuntimePermission', 'getClassLoader', null);
call dbms_java.grant_permission('JAVASYSPRIV', 'SYS:java.lang.RuntimePermission', 'setContextClassLoader', null);
call dbms_java.grant_permission('JAVASYSPRIV', 'SYS:java.lang.RuntimePermission', 'setFactory', null);
call dbms_java.grant_permission('JAVASYSPRIV', 'SYS:java.lang.RuntimePermission', 'setIO', null);
call dbms_java.grant_permission('JAVASYSPRIV', 'SYS:java.lang.RuntimePermission', 'setFileDescriptor', null);
call dbms_java.grant_permission('JAVASYSPRIV', 'SYS:java.lang.RuntimePermission', 'readFileDescriptor', null);
call dbms_java.grant_permission('JAVASYSPRIV', 'SYS:java.lang.RuntimePermission', 'writeFileDescriptor', null);
call dbms_java.grant_permission('JAVASYSPRIV', 'SYS:java.lang.RuntimePermission', 'writeFileDescriptor', null);


-- Permissions granted explicitly to SYS but not to JavaSysPriv
-- because they are regarded as particularly dangerous

call dbms_java.grant_permission('SYS', 'SYS:java.net.NetPermission', '*', null);
call dbms_java.grant_permission('SYS', 'SYS:java.security.SecurityPermission', '*', null);
call dbms_java.grant_permission('SYS', 'SYS:java.util.PropertyPermission', '*', 'write');
call dbms_java.grant_permission('SYS', 'SYS:java.lang.reflect.ReflectPermission', '*', null);
call dbms_java.grant_permission('SYS', 'SYS:java.lang.RuntimePermission', '*', null);

call dbms_java.grant_permission('SYS', 'SYS:java.lang.RuntimePermission', 'loadLibrary.xaNative', null);
call dbms_java.grant_permission('SYS', 'SYS:java.lang.RuntimePermission', 'loadLibrary.corejava', null);
call dbms_java.grant_permission('SYS', 'SYS:java.lang.RuntimePermission', 'loadLibrary.oraawt', null);
call dbms_java.grant_permission('SYS', 'SYS:java.lang.RuntimePermission', 'loadLibrary.oraioser', null);
call dbms_java.grant_permission('SYS', 'SYS:java.lang.RuntimePermission', 'loadLibrary.corejava_d', null);

-- grant Permissions to JavaDebugPriv
call dbms_java.grant_permission('JAVADEBUGPRIV', 'SYS:oracle.aurora.security.JServerPermission', 'Debug', null);
GRANT DEBUG CONNECT SESSION TO JAVADEBUGPRIV;
GRANT DEBUG ANY PROCEDURE TO JAVADEBUGPRIV;


-- JServerPermission granted only to SYS, and not to JavaSysPriv 
-- as these are not standard part of JDK policies.

call dbms_java.grant_permission('SYS', 'SYS:oracle.aurora.security.JServerPermission', '*', null);

call dbms_java.grant_permission('SYS', 'SYS:oracle.aurora.security.JServerPermission', 'LoadClassInPackage.java.*', null);
call dbms_java.grant_permission('SYS', 'SYS:oracle.aurora.security.JServerPermission', 'LoadClassInPackage.oracle.aurora.*', null);
call dbms_java.grant_permission('SYS', 'SYS:oracle.aurora.security.JServerPermission', 'LoadClassInPackage.oracle.jdbc.*', null);

-- 

-- We granted explicit loadLibrary permissions above, 
-- JNI is not supported for general use therefore we take away the right to administer
-- loadLibrary from JAVA_ADMIN. So before anyone (even SYS or DBA) can
-- grant loadLibrary they are going to have to give back the explicit Permission to do
-- so
call dbms_java.restrict_permission('PUBLIC', 'SYS:java.lang.RuntimePermission', 'loadLibrary.*', null);

call dbms_java.restrict_permission('PUBLIC', 'SYS:oracle.aurora.rdbms.security.PolicyTablePermission', '0:java.lang.RuntimePermission#loadLibrary.*', null);

-- grant permissions to EjbClient
call dbms_java.grant_permission('EJBCLIENT', 'SYS:java.net.SocketPermission','*', 'connect,resolve');
call dbms_java.grant_permission( 'EJBCLIENT', 'SYS:java.lang.RuntimePermission', 'createClassLoader', '' );
call dbms_java.grant_permission( 'EJBCLIENT', 'SYS:java.lang.RuntimePermission', 'getClassLoader', '' );

-- grant permissions related to java.sql.SQLPermission.
-- this was added in 9.2, when we move to JDK 1.3

call dbms_java.grant_policy_permission('JAVA_ADMIN', 'SYS', 'java.sql.SQLPermission', '*');
call dbms_java.grant_permission('JAVASYSPRIV', 'SYS:java.sql.SQLPermission', 'setLog', null);
