-- subscript for jvmunnn to do a subset of initjvm as part of upgrade

/*
#######################################################################
#######################################################################
  The following statement may cause an
  ORA-29554: unhandled Java out of memory condition
  error.
  If so, this is because there is insufficient system tablespace,
  shared or java pool size, or some other resource value is too small.
  An additional message describing the problem will be output by
  the statement.
#######################################################################
#######################################################################
*/

declare
 trash number;
begin
 select 1 into trash from java$jvm$status where action != 'DOWNGRADERELOAD';
 initjvmaux.check_sizes_for_cjs;
exception when no_data_found then null;
end;
/

-- Load all the Java classes
begin if initjvmaux.startstep('CREATE_JAVA_SYSTEM') then
  initjvmaux.rollbacksetup;
  commit;
  initjvmaux.rollbackset;
  initjvmaux.exec('create or replace java system');
  commit;
  initjvmaux.rollbackcleanup;
  initjvmaux.endstep;
end if; end;
/


-- Java Sanity check for installation
-- Define package dbms_java
@@initjvm2

-- Java Sanity Check

-- Verify that a simple java stored procedure works
select dbms_java.longname('foo') from dual;

-- Check for any Java classes that are invalid.
-- The following query should return 0 rows.

select nvl(longdbcs,name) from obj$,javasnm$ where
  status != 1 and owner#=0 and name=short(+) and
  (type#=56 or 
   (type#=29 and
    obj# in (select joxftobn from x$joxft where bitand(joxftflags,96)!=0)));

-- Find all the error messages.
-- Create the get error package for LoadJava
@@initjvm4

-- Triggers to run startup and shutdown Java code
-- The configuration data for currently registered MTS listener endpoints
-- SQLJ initialization
-- XA JSP initialization
@@initjvm5
