-- Subscript for upgrade/downgrade to call to remove system classes
-- and support packages on downgrade, or upgrade them on upgrade.

-- This script can not function properly in SVRMGR.  The following 
-- lines are intended to abort the script if it is being run with
-- SVRMGR, but will be interpreted simply as remarks by SQLPLUS.
rem -
set stoponerror on
rem -
udjvmrm.sql must be run with SQLPLUS, not SVRMGRL

-- This script may only be called from d0x0x0x0 or jvmdbmig.sql.  
-- Otherwise, jvmudaction will be undefined and the following will 
-- abort the script.
whenever sqlerror exit;

/*
/*
  If the following sequence results in
   SP2-0552: Bind variable "JVMUDACTION" not declared.
  followed by
   ORA-01476: divisor is equal to zero
  thereby causing SQLPLUS to exit, it is because this script is 
  not being run as a subscript of jvmdbmig.sql or d0x0x0x0.sql, as required.
*/
variable scratch varchar2(30)
execute :scratch := :jvmudaction; :scratch := 'not null';
declare z number := 0; begin if :scratch is null then z := 1/z;end if;end;
/

whenever sqlerror continue;

@@jisrm

variable jvmrmaction varchar2(30)
execute :jvmrmaction := 'GRADE_REMOVAL';

delete from java$rmjvm$aux;
commit;

@@jvmrm

call initjvmaux.drp('drop table JAVA$CLASS$MD5$TABLE');

column jvmuscript new_value jvmuscript noprint;
select initjvmaux.jvmuscript as jvmuscript from dual;

begin
  if initjvmaux.registrystatus = 'DOWNGRADING' and
     initjvmaux.startstep('SET_REGISTRY_DOWNGRADED') then
    dbms_registry.downgraded('JAVAVM',substr(:jvmudsubaction,instr(:jvmudsubaction,'_',-1)+1));
    initjvmaux.endstep;
  end if;
end;
/

begin
  if initjvmaux.registrystatus = 'UPGRADING' and
     initjvmaux.startstep('DROP_SROS') then
    update obj$ set status=5
      where owner#=0 and type#=29 and name='oracle/aurora/rdbms/Compiler';
    commit;
    declare
      cursor C1 is select
         'DROP JAVA DATA "' || u.name || '"."' || o.name || '"'
         from obj$ o,user$ u where o.type#=56 and u.user#=o.owner#;
    
      ddl_statement varchar2(200);
      iterations number;
      previous_iterations number;
      loop_count number;
      my_err     number;
    begin
      previous_iterations := 10000000;
      loop
        -- To make sure we eventually stop, pick a max number of iterations
        select count(*) into iterations from obj$ where type#=56;
        exit when iterations=0 or iterations >= previous_iterations;
        previous_iterations := iterations;
        loop_count := 0;
        open C1;
        loop
          begin
            fetch C1 into ddl_statement;
            exit when C1%NOTFOUND or loop_count > iterations;
          exception when others then
             my_err := sqlcode;
             if my_err = -1555 then -- snapshot too old, re-execute fetch query
               exit;
             else
               raise;
             end if;
          end;
          initjvmaux.exec(ddl_statement);
          loop_count := loop_count + 1;
        end loop;
        close C1;
      end loop;
    end;
    commit;
    delete from java$policy$shared$table;
    update obj$ set status=1
      where owner#=0 and type#=29 and name='oracle/aurora/rdbms/Compiler';
    commit;
    initjvmaux.endstep;
  end if;
end;
/

delete from java$rmjvm$aux;
commit;

begin
  if initjvmaux.registrystatus = 'UPGRADING' and
     initjvmaux.startstep('CLEAN_DEPENDENCIES') then
    initjvmaux.rollbacksetup;
    commit;
    initjvmaux.rollbackset;
    insert into java$rmjvm$aux (select joxftobn from x$joxfc where bitand(joxftflags,96)!=0);
    commit;
    delete from dependency$ where d_obj# in (select obj# from java$rmjvm$aux);
    commit;
    initjvmaux.rollbackcleanup;
    initjvmaux.endstep;
  end if;
end;
/

delete from java$rmjvm$aux;
commit;

begin
  if initjvmaux.registrystatus = 'UPGRADING' and
     initjvmaux.startstep('FIX_DEPENDENCY_TIMESTAMPS') then
    initjvmaux.rollbacksetup;
    commit;
    initjvmaux.rollbackset;
    execute immediate 'update dependency$ set p_timestamp=(select stime from obj$ where obj#=p_obj#) where (select stime from obj$ where obj#=p_obj#)!=p_timestamp and (select type# from obj$ where obj#=p_obj#)=29  and (select owner# from obj$ where obj#=p_obj#)=0';
    commit;
    initjvmaux.rollbackcleanup;
    initjvmaux.endstep;
  end if;
end;
/

@@&&jvmuscript

-- end of the line in the downgrade case
begin
  if :jvmudaction = 'DOWNGRADE' then
    initjvmaux.endaction();
  end if;
end;
/

