REM
REM You must connect as SYSDBA prior to running this script
REM

-- 
-- Internal installation script for ORD - steps that must be executed as SYSDBA
--

--
-- Privs needed by SYS
--
grant all privilege to SYS;
-- grant create any operator to SYS;
-- grant create any indextype to SYS;
-- grant drop any indextype to SYS;
-- grant drop any operator to SYS;
-- grant javauserpriv to SYS;
call dbms_java.grant_permission ('SYSTEM', 'java.io.FilePermission', 
                                 '<<ALL FILES>>', 'read');

-- 
-- Privs needed by ORDSYS 
--
grant create view, create any synonym, drop any synonym to ordsys;
grant create session,resource,create library, create procedure to ordsys;
grant create operator to ordsys;
grant create indextype to ordsys;
grant create type to ordsys;
grant create table to ordsys;
grant create public synonym to ordsys;
grant drop any indextype to ordsys;
grant drop any operator to ordsys;
grant drop any type to ordsys;
grant drop public synonym to ordsys;
grant javauserpriv to ordsys;
grant java_deploy to ORDSYS;

--
-- Privs needed for ORDSYS to use import/export extensibility
--

grant insert on sys.exppkgobj$ to ORDSYS; 
grant insert on sys.exppkgact$ to ORDSYS; 
grant insert on sys.expdepobj$ to ORDSYS; 
grant insert on sys.expdepact$ to ORDSYS; 
grant delete on sys.exppkgobj$ to ORDSYS; 
grant delete on sys.exppkgact$ to ORDSYS; 
grant delete on sys.expdepobj$ to ORDSYS; 
grant delete on sys.expdepact$ to ORDSYS; 
 

--
-- Privs needed by ORDPLUGINS 
--
grant create session to ordplugins;
grant resource,create library, create procedure to ordplugins;
grant create operator to ordplugins;
grant create indextype to ordplugins;
grant create type to ordplugins;
grant create table to ordplugins;
grant create public synonym to ordplugins;
grant drop any indextype to ordplugins;
grant drop any operator to ordplugins;
grant drop any type to ordplugins;
grant drop public synonym to ordplugins;


--
-- Privs needed by MDSYS
--
@%ORACLE_HOME%/md/admin/mdprivs.sql

--
-- Grants needed for ORDSYS views
-- 

grant select on dba_views to ordsys with grant option;
grant select on dba_tables to ordsys with grant option;
grant select on dba_object_tables to ordsys with grant option;

REM Install UTL_RAW

@%ORACLE_HOME%/rdbms/admin/utlraw.sql
@%ORACLE_HOME%/rdbms/admin/prvtrawb.plb
