--
-- Top level upgrade script for ORD from 8.1.7.  This upgrade script must be
-- invoked before upgrading interMedia or Spatial.
--
-- Prerequisites:
--  You must change directory to the admin directory which 
--    contains these scripts before invoking this upgrade script.
--  You must connect / as SYSDBA before invoking this script

--
-- Steps that must be executed as SYSDBA
--

---
--- remove keyword "any" from the privilegs.
---
begin
  execute immediate 
   'revoke create any operator, create any indextype, create any type, 
       create any table from ORDSYS';

  execute immediate 
   'revoke create any operator, create any indextype, create any type, 
       create any table from ORDPLUGINS';

---
--- revoke connect role and grant the necessary privileges.
--- connect role has following privileges:
--- Alter Session: has to be removed for security reason. 
--- Create Cluster: removed. 
--- Create Database Link: removed. 
--- Create Sequence: removed. 
--- Create Session: kept, see imprv.sql. 
--- Create Synonym: kept, see imprv.sql. 
--- Create Table: kept, see imprv.sql. 
--- Create View: removed from ordplugins and si_infomtn_schema 
---
  execute immediate 
   'revoke connect from ORDSYS';

  execute immediate 
   'revoke connect from ORDPLUGINS';

  EXCEPTION
    WHEN OTHERS THEN
      NULL; 

end;
/

@@ordisys.sql

-- 
-- Steps that must be executed as ORDSYS
--
alter session set current_schema="ORDSYS";
@@ordiords.sql

alter session set current_schema="SYS";
