/* $Header: EventSample.java 08-may-2006.08:43:16 clakshma Exp $ */
 
/* Copyright (c) 2000, 2006, Oracle. All rights reserved.  */

/**
 * DESCRIPTION
 * This file illustrates the basic use of DOMMutationEvents
 * This illustrates how to create an event listener,register it and listen 
 * to events
 */

import org.w3c.dom.Node;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

import oracle.xml.parser.v2.XMLText;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLDOMImplementation;

public class EventSample 
{
   public static void main (String args[])
   { 
     // instantiate the event listener
     // see end of this file for implementation of the listener
     eventlistener evtlist = new eventlistener();

     // create a new document
     XMLDocument doc1 = new XMLDocument();
     XMLDOMImplementation impl = (XMLDOMImplementation) doc1.getImplementation();

     // autoevents flag has to be set to use events 
     impl.setFeature("oracle.xml.AutoEvents");

     // register the event listener on the document node for 
     // below listed type of events
     doc1.addEventListener("DOMNodeRemoved",evtlist,false);
     doc1.addEventListener("DOMNodeInserted",evtlist,false);
     doc1.addEventListener("DOMCharacterDataModified",evtlist,false);

     // see below to find how to register a listener on different type of nodes
     // and listen to different kind of events
     XMLElement el = (XMLElement)doc1.createElement("element");
     XMLElement el1= (XMLElement)doc1.createElement("element1");
     XMLText text = (XMLText) doc1.createTextNode("abcde");
     text.addEventListener("DOMCharacterDataModified",evtlist,false);
     el.addEventListener("DOMNodeRemoved",evtlist,false);
     el.addEventListener("DOMNodeRemovedFromDocument",evtlist,false);
     el.addEventListener("DOMCharacterDataModified",evtlist,false); 
     el1.addEventListener("DOMNodeRemoved",evtlist,false);
     el1.addEventListener("DOMNodeRemovedFromDocument",evtlist,false);
     el1.addEventListener("DOMCharacterDataModified",evtlist,false); 
     el.addEventListener("DOMNodeInserted",evtlist,false);
     el.addEventListener("DOMNodeInsertedIntoDocument",evtlist,false);
     el1.addEventListener("DOMNodeInserted",evtlist,false);
     el1.addEventListener("DOMNodeInsertedIntoDocument",evtlist,false);
     doc1.appendChild(el);
     el.setAttribute("attr","val");
     doc1.removeEventListener("DOMNodeInserted",evtlist,false);
     NamedNodeMap nl = (NamedNodeMap)el.getAttributes();
     XMLAttr att = (XMLAttr) nl.item(0);
     att.addEventListener("DOMAttrModified",evtlist,false);
     el.addEventListener("DOMAttrModified",evtlist,false);
     doc1.addEventListener("DOMAttrModified",evtlist,false);

     // mutations that triggers the events !
     att.setNodeValue("abc");
     el.appendChild(el1);
     el.appendChild(text);
     text.setNodeValue("xyz");
     doc1.removeChild(el);
    
     // prints the trace of event calls
     evtlist.print();
   }

}


class eventlistener implements EventListener 
{
  String s ;
  public eventlistener()
  {
     s = "";
  }

  public void handleEvent(Event e)
  {
    s += " Event recieved rightly " + "\n";
    s += e.getType() + "\n";
    s += " The Target is " + ((Node)(e.getTarget())).getNodeName() + "\n";
    s += "**********" + "\n" ;
  }

  public void print()
  {
     System.out.println(s);
  }
}




